#version 300 es

precision mediump float;
uniform mediump float stepx;
uniform mediump float stepy;
uniform mediump float scale;
uniform mediump vec4 color;
uniform mediump float threshold;

// we want 20 samples but only 8 ins available...
in vec2 vTexcoord0;
in vec2 vTexcoord0_p1;
in vec2 vTexcoord0_p2;
in vec2 vTexcoord0_p3;
in vec2 vTexcoord0_p4;
in vec2 vTexcoord0_p5;
in vec2 vTexcoord0_m1;
in vec2 vTexcoord0_m2;

out vec4 gl_FragColor;

uniform sampler2D s_texture0;

void main() {
	vec2 off = vec2(stepx, stepy) * scale; // TODO: make it vec2 uniform...
	vec4 c = texture2D(s_texture0, vTexcoord0);
	c += texture2D(s_texture0, vTexcoord0_p1);
	c += texture2D(s_texture0, vTexcoord0_p2);
	c += texture2D(s_texture0, vTexcoord0_p3);
	c += texture2D(s_texture0, vTexcoord0_p4);
	c += texture2D(s_texture0, vTexcoord0_p5);
	c += texture2D(s_texture0, vTexcoord0 + off * 6.0);
	c += texture2D(s_texture0, vTexcoord0 + off * 7.0);
	c += texture2D(s_texture0, vTexcoord0 + off * 8.0);
	c += texture2D(s_texture0, vTexcoord0 + off * 9.0);
	c += texture2D(s_texture0, vTexcoord0_m1);
	c += texture2D(s_texture0, vTexcoord0_m2);
	c += texture2D(s_texture0, vTexcoord0 - off * 3.0);
	c += texture2D(s_texture0, vTexcoord0 - off * 4.0);
	c += texture2D(s_texture0, vTexcoord0 - off * 5.0);	
	c += texture2D(s_texture0, vTexcoord0 - off * 6.0);
	c += texture2D(s_texture0, vTexcoord0 - off * 7.0);
	c += texture2D(s_texture0, vTexcoord0 - off * 8.0);	
	c += texture2D(s_texture0, vTexcoord0 - off * 9.0);
	
	c = c - threshold * 20.0;
	c = c * (color / 20.0);
	gl_FragColor = c;
		
}