#version 430

in vec2 vTexcoord0;
uniform sampler2D s_texture0;

uniform vec2 vResolution;
uniform vec2 vResolutionInv;
uniform float iter;
uniform vec4 threshold;

// output for 2 buffers
layout(location = 0) out vec4 outColor;

vec3 threshold_input(vec3 inpt)
{
	return max(vec3(0.0), inpt - threshold.xyz);
}

vec3 KawaseBlurFilter(sampler2D tex, vec2 texCoord, vec2 pixelSize, float iteration)
{
	vec2 texCoordSample;
	vec2 halfPixelSize = pixelSize / 2.0f;
	vec2 dUV = ( pixelSize.xy * vec2(iteration) ) + halfPixelSize.xy;

	vec3 cOut;

	// Sample top left pixel
	texCoordSample.x = texCoord.x - dUV.x;
	texCoordSample.y = texCoord.y + dUV.y;
	
	cOut = texture( tex, texCoordSample ).xyz;

	// Sample top right pixel
	texCoordSample.x = texCoord.x + dUV.x;
	texCoordSample.y = texCoord.y + dUV.y;

	cOut += texture( tex, texCoordSample ).xyz;

	// Sample bottom right pixel
	texCoordSample.x = texCoord.x + dUV.x;
	texCoordSample.y = texCoord.y - dUV.y;
	cOut += texture( tex, texCoordSample ).xyz;

	// Sample bottom left pixel
	texCoordSample.x = texCoord.x - dUV.x;
	texCoordSample.y = texCoord.y - dUV.y;

	cOut += texture( tex, texCoordSample ).xyz;

	// Average 
	cOut *= 0.25f;
	
	return threshold_input(cOut);
}

void main()
{
	// TODO: this 0.5 is to fix the sampling positions. there is something fucked up with initial sampling pattern...
	outColor = vec4(KawaseBlurFilter(s_texture0, vTexcoord0, vResolutionInv, iter * 0.5), 1.0);
}
