attribute vec3 vPosition;
attribute vec2 vTexcoord;
uniform mat4 mModelview;
uniform mat4 mProjection;
uniform mat4 mRotation;
varying mediump vec3 vDirection;

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	vDirection = vPosition * 4.0; // this will give us range from -0.5 to 0.5
	vDirection.z = 1.0;
	vDirection = normalize(vDirection);
	
	vDirection = (mRotation * vec4(vDirection, 1.0)).xyz;
}