precision mediump float;
varying lowp vec2 vTexcoord0;
varying lowp vec2 vTexcoord0_1x;
varying lowp vec2 vTexcoord0_1y;
varying lowp vec2 vTexcoord0_3x;
varying lowp vec2 vTexcoord0_3y;
uniform sampler2D s_texture0; // lowres deformation texture
uniform sampler2D s_texture1; // envmap
uniform float timediff;
uniform float scale;

void main() {
	lowp vec4 deform = texture2D(s_texture0, vTexcoord0);
	
	//lowp vec4 deformx = texture2D(s_texture0, vTexcoord0 + vec2(1.0/64.0, 0.5/64.0));
	//lowp vec4 deformy = texture2D(s_texture0, vTexcoord0 + vec2(0.5/64.0, 1.0/64.0));
	
	//lowp vec4 deformx2 = texture2D(s_texture0, vTexcoord0 + vec2(3.0/64.0, 0.5/64.0));
	//lowp vec4 deformy2 = texture2D(s_texture0, vTexcoord0 + vec2(0.5/64.0, 3.0/64.0));
	
	lowp vec4 deformx = texture2D(s_texture0, vTexcoord0_1x);
	lowp vec4 deformy = texture2D(s_texture0, vTexcoord0_1y);
	
	lowp vec4 deformx2 = texture2D(s_texture0, vTexcoord0_3x);
	lowp vec4 deformy2 = texture2D(s_texture0, vTexcoord0_3y);

	lowp vec2 gradient = vec2(deform.x - deformx.x, deform.x - deformy.x);
	lowp vec2 gradient2 = vec2(deform.x - deformx2.x, deform.x - deformy2.x);
	
	//lowp vec4 envmap = texture2D(s_texture1, 0.5 + gradient * 0.1) * (0.1 + deform.x * 1.1);
	lowp vec4 envmap = texture2D(s_texture0, vTexcoord0 + gradient * 0.1);
	//envmap = envmap * 0.7;
	
	envmap = envmap * (0.95 + 0.4 * dot(vTexcoord0-0.5, gradient)); 
	
	envmap.x += gradient2.x * 0.6 + gradient2.y * 0.2;
	envmap.y += gradient2.x * 0.3 + gradient2.y * 0.1;
	
	gl_FragColor = envmap;
	
	
}