attribute vec3 vPosition;
attribute vec2 vTexcoord;
uniform mat4 mModelview;
uniform mat4 mProjection;
uniform mat4 mRotation;
varying lowp vec2 vTexcoord0;
varying lowp vec2 vTexcoord0_1x;
varying lowp vec2 vTexcoord0_1y;
varying lowp vec2 vTexcoord0_3x;
varying lowp vec2 vTexcoord0_3y;

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	vTexcoord0 = vTexcoord;
	vTexcoord0_1x = vTexcoord + vec2(1.0/64.0, 0.5/64.0);
	vTexcoord0_1y = vTexcoord + vec2(0.5/64.0, 1.0/64.0);
	vTexcoord0_3x = vTexcoord + vec2(3.0/64.0, 0.5/64.0);
	vTexcoord0_3y = vTexcoord + vec2(0.5/64.0, 3.0/64.0);
}