#version 430

in vec2 vTexcoord0;
uniform sampler2D s_texture0;

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

struct CustomPostprocessParams
{
	float param1;
	float param2;
	float param3;
	float param4;
	vec4  param_color1;
	vec4  param_color2;
};

layout (std140, row_major) uniform CustomPostprocessParamsBuffer {
	CustomPostprocessParams params;
};

uniform sampler2D  sAlbedo;
uniform sampler2D  sTextureDepth;
uniform usampler2D sNormalMaterial;
uniform usampler2D sMetalnessRoughnessMaterialTags;
uniform sampler2D  sShadow;

layout(location = 0) out vec4 outColor;

void main()
{
	vec4 base_color = texture(s_texture0, vTexcoord0);
	outColor = base_color;
	outColor.r = params.param1;
	outColor.g = params.param2;
	outColor.b = params.param3;

	outColor = texture(sAlbedo, vTexcoord0) * 0.1;
	outColor = texture(sShadow, vTexcoord0) * 0.1;
	outColor = pow(texture(sTextureDepth, vTexcoord0).rrrr, vec4(10.0));
}
