#version 300 es

precision mediump float;
in vec3 vNorm;
in vec4 vPos;
in vec4 vCoords;
in vec4 vWorldPos;
in vec3 vWorldNorm;
in vec2 vTCoord;

// output for 2 buffers
layout(location = 0) out vec4 outAlbedo;
layout(location = 1) out vec4 outNormalMaterial;

// albedo
uniform sampler2D s_texture0;

// normal
uniform sampler2D s_texture1;

// envmap (mips - roughness)
uniform samplerCube s_envmap;

// material id
uniform float materialId;

// material roughness
uniform float mat_roughness;

void main() {
	float g = vNorm.z * 0.5 + 0.5;
	
	vec3 incident_eye = normalize(vWorldPos.xyz);
    vec3 normal = normalize(vWorldNorm.xyz);
	vec3 reflected = -reflect(incident_eye, normal);
	
	outNormalMaterial = vec4(normalize(vWorldNorm) * 0.5 + 0.5, materialId);
	
	vec4 envmap = textureLod(s_envmap, reflected, mat_roughness) * 0.75 + 0.25;
	
	float ndotl = dot(normal, incident_eye);
	
	outAlbedo = vec4(ndotl) * envmap * texture(s_texture0, vTCoord);
}
