#version 430

#define MATERIAL_PROPERTIES_BINDING 1
#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;

layout(rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;

struct CopyRTMaterialPropertyToStencilParams
{
	int scale_denominator;
	int _pad0;
	int _pad1;
	int _pad2;
};

layout (std140, row_major) uniform CopyRTMaterialPropertyToStencilParamsBuffer
{
	CopyRTMaterialPropertyToStencilParams params;
};

void main() {

	// all we do is discard where material RT properties are not present
	// for the downsampled case be conservative and mark as RT if 1/4 is at leart RT

	ivec2 base_pos = ivec2(gl_FragCoord.xy);

	int is_rt_counter = 0;
	int sample_count = 0;
	if (params.scale_denominator == 1)
	{
		sample_count = 1;

		MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
		metalness_roughness_material_tags = decode_metalness_roughness_material_tags(imageLoad(imMetalnessRoughnessMaterialTags, base_pos).rgba);
		uint materialIndex = metalness_roughness_material_tags.material_index;

		MaterialPropertiesGPU material = materials.material_properties[materialIndex];
	
		uint material_flags = material.flags;

		// also check material overrides. only include 4 attributes
		if ((metalness_roughness_material_tags.material_flag_overrides & MaterialFlag_OverrideFlags) != 0)
		{
			material_flags &= ~0xf;
			material_flags |= metalness_roughness_material_tags.material_flag_overrides & 0xf;
		}

		bool is_reflective = (material_flags & MaterialFlag_Reflective) != 0;
		if (is_reflective)
			is_rt_counter++;
	}

	if (params.scale_denominator == 2)
	{
		sample_count = 4;
		base_pos *= 2;
		for(int iy = 0; iy < 2; iy++)
		{
			for(int ix = 0; ix < 2; ix++)
			{
				float metalness;
				float roughness;
				uint materialIndex;

				decode_metalness_roughness_material(imageLoad(imMetalnessRoughnessMaterialTags, base_pos + ivec2(ix, iy)).rg, metalness, roughness, materialIndex);
				MaterialPropertiesGPU material = materials.material_properties[materialIndex];

				if ((material.flags & MaterialFlag_Reflective) != 0)
					is_rt_counter++;
			}
		}
	}

	// NOTE: do we want conservative to be more or less rt?
	//if (is_rt_counter == 0)
	if (is_rt_counter < sample_count)
		discard;
}
