#version 300 es

precision mediump float;
uniform mediump float dispersal;
uniform mediump vec3 chromadistortion;
//uniform int samples;
uniform mediump float halowidth;
uniform sampler2D s_texture0;

in vec2 vTexcoord0;
in vec2 sample_vector;

out vec4 gl_FragColor;

lowp vec3 textureDistorted(
	in sampler2D tex,
	in vec2 sample_center, // where we'd normally sample
	in vec2 sample_vector,
	in vec3 distortion // per-channel distortion coeffs
) {

	lowp vec3 v = vec3(
		texture2D(tex, sample_center + sample_vector * distortion.r).r,
		texture2D(tex, sample_center + sample_vector * distortion.g).g,
		texture2D(tex, sample_center + sample_vector * distortion.b).b
	);

	//v -= 0.3;
	
	return v;
}

void main()
{
	//float _dispersal = 0.3;
	float _dispersal = dispersal;
	//vec3 _chromadistortion = _vec3(0.0, 0.0, 0.0);
	vec3 _chromadistortion = chromadistortion;
	//float _halowidth = 0.1;
	float _halowidth = halowidth;
	            
	lowp vec2 image_center = vec2(0.5);

	//vec2 sample_vector = (image_center - vTexcoord0) * _dispersal;	// calculated in vshader
	lowp vec2 halo_vector = normalize(sample_vector) * _halowidth;

	float halo_weight = 1.0 - length(vec2(0.5) - (vTexcoord0 + halo_vector)) * 3.0;
	halo_weight = clamp(halo_weight, 0.0, 1.0);
	
	lowp vec3 result = halo_weight * textureDistorted(s_texture0, vTexcoord0 + halo_vector, halo_vector, chromadistortion).rgb;

	for (int i = 0; i < 10; ++i) // using uniform as a condition completely kills performance:(
	{
		lowp vec2 offset = sample_vector * float(i);

		float weight = 1.0 - length(vec2(0.5) - (vTexcoord0 + offset)) * 3.0;
		
		weight = clamp(weight, 0.0, 1.0);
		result += weight * textureDistorted(s_texture0, vTexcoord0 + offset, offset, _chromadistortion).rgb;
	} 
	
	gl_FragColor = vec4(0.5 + (result * 0.4 - 0.5) * 1.4, 1.0);
	
}