#version 300 es

attribute vec3 vPosition;
attribute vec2 vTexcoord;
uniform mat4 mModelview;
uniform mat4 mProjection;

uniform mediump float dispersal;

out vec2 vTexcoord0;
out mediump vec2 sample_vector;
	

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	vTexcoord0.xy = - vTexcoord.xy + 1.0; // mirror source coords along x and y

	vec2 image_center = vec2(0.5);
	sample_vector = (image_center - vTexcoord0) * dispersal;

}