#version 430

#include <../materials/commons.glsl>

in vec2 vTexcoord0;
uniform sampler2D s_texture0;		// depth
uniform sampler2D s_texture1;		// color
uniform usampler2D s_texture2;		// material/normal

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

uniform vec4 vNearFarPlane; // min, max, 2*min*max, max-min

uniform float depthCoordsScale = 1.0; // when depth is different res than color data

// output for 2 buffers
layout(location = 0) out vec4 outColor;

float linearize_depth(in float d)
{
	return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
}

// bilateral blur
#define KERNEL_RADIUS 4
#define g_Sharpness 0.1

float continuity_value(vec2 uv)
{
	uint encoded_normal_material = texture(s_texture2, uv * depthCoordsScale).r;
	int materialId = decode_material(encoded_normal_material);
	vec3 normal = decode_normal(encoded_normal_material);
	
	//return linearize_depth(texture(s_texture0, uv * depthCoordsScale).x) + materialId;
	return linearize_depth(texture(s_texture0, uv * depthCoordsScale).x) * (materialId + 1); 
}

vec4 BlurFunction(vec2 uv, float rx, float ry, vec4 center_c, float center_d, inout float w_total)
{
  vec4  c = texture2D(s_texture1, uv );
  float d = continuity_value(uv);
  
  const float BlurSigma = float(KERNEL_RADIUS) * 0.5;
  const float BlurFalloff = 1.0 / (2.0*BlurSigma*BlurSigma);
  
  float r = length(dot(rx, ry));
  float ddiff = (d - center_d) * g_Sharpness;
  float w = exp2(-r*r*BlurFalloff - ddiff*ddiff);
  w_total += w;

  return c*w;
}

vec4 fetch_hbao_blur(vec2 texCoord)
{
  vec4  center_c = texture2D(s_texture1, texCoord );
  float center_d = continuity_value(texCoord);
  
  vec4  c_total = center_c;
  float w_total = 1.0;
  
  for (int ry = -KERNEL_RADIUS; ry <= KERNEL_RADIUS; ry += 1)
  {
	for (int rx = -KERNEL_RADIUS; rx <= KERNEL_RADIUS; rx += 1)
	{
		if (rx == 0 && ry == 0)
			continue;
		vec2 uv = texCoord + vec2(rx, ry) * vResolutionInv;
		c_total += BlurFunction(uv, rx, ry, center_c, center_d, w_total);
	}
  }

  return c_total/w_total;
}


void main()
{
	outColor = fetch_hbao_blur(gl_FragCoord.xy / vec2(1920.0, 1080.0));
	
	//outColor = vec4(0.01 * linearize_depth(texelFetch(s_texture0, ivec2(textureSize(s_texture0, 0) * vTexcoord0 * depthCoordsScale + 0.5), 0).x));
}
