#version 430

#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;
uniform sampler2D sColor;
uniform sampler2D sDepth;

struct PostDepthOfFieldParams
{
	vec2   resolution;
	vec2   inv_resolution;

	vec4   camera_projection_params;
	vec4   near_far_plane;

	float  focus_point;
	float  focus_scale;
	float  far_plane;
	int    debug_blur_size;
};

layout (std140, row_major) uniform PostDepthOfFieldParamsBuffer {
	PostDepthOfFieldParams dof_params;
};

layout(location = 0) out vec4 outColor;

// https://blog.voxagon.se/2018/05/04/bokeh-depth-of-field-in-single-pass.html

const float GOLDEN_ANGLE = 2.39996323; 
const float MAX_BLUR_SIZE = 20.0; 
const float RAD_SCALE = 0.5; // Smaller = nicer blur, larger = faster

#if 1
float linearizeDepth(float d)
{
	return dof_params.near_far_plane.z / (dof_params.near_far_plane.y + dof_params.near_far_plane.x - d * dof_params.near_far_plane.w);
}
#else
float linearizeDepth(float d)
{
	return d * dof_params.far_plane;
}
#endif

float getBlurSize(float depth, float focusPoint, float focusScale)
{
	float coc = clamp((1.0 / focusPoint - 1.0 / depth)*focusScale, -1.0, 1.0);
	return abs(coc) * MAX_BLUR_SIZE;
}

void main()
{
	float depth = linearizeDepth(texture(sDepth, vTexcoord0).r);
	float coc   = getBlurSize(depth, dof_params.focus_point, dof_params.focus_scale);
	outColor = vec4(coc, depth / dof_params.far_plane, 0.0, 1.0);
}


