
#ifndef VERTEX_MODIFIER_QUANTIZE_H
#define VERTEX_MODIFIER_QUANTIZE_H

struct VertexModifierQuantizeParams
{
	vec3  quantization_step;
	float quantization_modifier_factor;
	vec3  offset;
	int   quantize_x;
	int   quantize_y;
	int   quantize_z;
};

//const int VERTEX_MODIFIER_QUANTIZE_INFLUENCE_SCOPE_PER_INSTANCE = 0;
//const int VERTEX_MODIFIER_QUANTIZE_INFLUENCE_SCOPE_GLOBAL       = 1;

void vertex_modifier_quantize_apply(VertexModifierQuantizeParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
	// TODO: Add instance transform handling here
	vec3 p = vtx.pos;
	p = (cs_transforms.mat_local_to_model, vec4(p, 1.0)).xyz;
	p = floor((p + params.offset) / params.quantization_step) * params.quantization_step - params.offset;
	p = (cs_transforms.mat_local_to_model_inv, vec4(p, 1.0)).xyz;

	float f = mix(1.0, modifier_factor.factor, params.quantization_modifier_factor);
	if (params.quantize_x != 0)
		vtx.pos.x = mix(vtx.pos.x, p.x, f);
	if (params.quantize_y != 0)
		vtx.pos.y = mix(vtx.pos.y, p.y, f);
	if (params.quantize_z != 0)
		vtx.pos.z = mix(vtx.pos.z, p.z, f);

}

#endif // VERTEX_MODIFIER_QUANTIZE_H



