precision mediump float;
//uniform vec4 vColor;

uniform float scale;
uniform float time;
uniform float timediff;

uniform mediump sampler2D s_texture0; // 2048x2048 texture split into 8x8 256x256 ones
varying mediump vec3 vDirection;  


void main() {

	// we will be taking 20 samples
	int i;
	float c = 0.0;
	float step = 0.5;  // this should go to around 60;
	mediump vec3 dir;
	float b = 0.0;
	float nscale = 0.7;
	float timefactor = time * 0.5;
	
	for(i=0; i<40; i++)
	{
		dir = vDirection * step;
		dir.xy = dir.xy * nscale + 0.5;
		dir.z += timefactor;
		float z = mod(dir.z, 63.0);
		// now we need to pick a virtual texture to sample...
		float ix = mod(floor(z), 8.0);
		float iy = floor(z) / 8.0;
		
		mediump vec2 st = (fract(dir.xy) + vec2(ix, iy)) / 8.0;
		float v1 = texture2D(s_texture0, st).x; // sampled 3d texture
		
		// second tile (ceiled z)
		
		z = mod(z + 1.0, 63.0);
		ix = mod(floor(z), 8.0);
		iy = floor(z) / 8.0;
		st = (fract(dir.xy) + vec2(ix, iy)) / 8.0;
		
		float v2 = texture2D(s_texture0, st).x; // sampled 3d texture
		float v = mix(v1, v2, fract(z)) - 0.5;
		
		b += v;
		v = abs(v);
		if (v < 0.035)
			c += v * v;
		step += 0.015 + v * 0.4;
		nscale = nscale * 1.005;
	}	

	b = max(-0.2, b) * 0.65;
	b = b * b;
	
	c = c * 120.0 / step;
	c = c * c;
	
	float vign = 1.8 - 26.8 * length(vDirection.xy);
	vign = min(1.1, vign);
	gl_FragColor = vign * vec4(c + b * 0.6, c + b * 0.35, c + b * 0.15, 1.0);
}