#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct CompositeParams
{
    float ssr_scaling_factor;
    int composite_output_mode;
    float raytrace_scaling_factor;
    float _pad1;
};

const float _416[7] = float[](0.071303434669971466064453125, 0.13151411712169647216796875, 0.189879238605499267578125, 0.2146064341068267822265625, 0.189879238605499267578125, 0.13151411712169647216796875, 0.071303434669971466064453125);

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    float taa_blend;
    float taa_gamma;
    uint transparency_blend;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _196;

layout(set = 0, binding = 2, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_params;
} _231;

layout(set = 0, binding = 3, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _522;

layout(set = 0, binding = 4, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 5, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1510;

layout(set = 0, binding = 7) uniform sampler2D sSSR;
layout(set = 0, binding = 8) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 9) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 10) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 11) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 12) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 13) uniform sampler2D sAlbedo;
layout(set = 0, binding = 14) uniform sampler2D sShadow;
layout(set = 0, binding = 15) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 16) uniform sampler2D sVoxelOcclusion;
layout(set = 0, binding = 17) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 18) uniform sampler2D sParticles;
layout(set = 0, binding = 19) uniform sampler2D sRaytrace;
layout(set = 0, binding = 20) uniform sampler2D sDebug;
layout(set = 0, binding = 21) uniform sampler2D sWireframeColor;
layout(set = 0, binding = 22) uniform sampler2D sWireframeDepth;
layout(set = 0, binding = 6, rgba16f) uniform writeonly image2D imTarget;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _196.dispatch_setup.near_far_plane.z / ((_196.dispatch_setup.near_far_plane.y + _196.dispatch_setup.near_far_plane.x) - (d * _196.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_196.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec4 sample_ssr(inout vec2 p, float depth)
{
    p *= _231.composite_params.ssr_scaling_factor;
    float s = 0.0;
    vec4 v = vec4(0.0);
    float r = 10.5 * clamp(1.0 / depth, 0.5, 2.0);
    v = textureLod(sSSR, p, 0.0);
    s = v.w;
    vec4 _258 = v;
    vec3 _260 = _258.xyz * s;
    v.x = _260.x;
    v.y = _260.y;
    v.z = _260.z;
    for (int y = -2; y <= 2; y++)
    {
        for (int x = -2; x <= 2; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            if (s < 1.0)
            {
                ivec2 smpl_pos = ivec2(p * _196.dispatch_setup.resolution) + ivec2(x, y);
                vec3 blue_noise = texelFetch(s_BlueNoise, ivec3(smpl_pos % ivec2(128), 0), 0).xyz;
                vec4 pxl = textureLod(sSSR, vec2(smpl_pos) * _196.dispatch_setup.inv_resolution, 0.0);
                if (pxl.w > s)
                {
                    vec3 _346 = pxl.xyz * pxl.w;
                    v.x = _346.x;
                    v.y = _346.y;
                    v.z = _346.z;
                    s = pxl.w;
                }
            }
        }
    }
    return vec4(v.xyz, s);
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _522.composite_setup.fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _522.composite_setup.fill_color.xyz) + specular, 1.0);
}

vec4 sample_volumetric_fog(uvec2 pixel_pos, float ref_depth, uint ref_material_idx)
{
    vec4 c0 = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
    vec4 vc = vec4(0.0);
    float total_w = 1.0;
    for (int y = -3; y <= 3; y++)
    {
        for (int x = -3; x <= 3; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            ivec2 sampling_pos = ivec2(pixel_pos) + ivec2(x, y);
            float w = _416[x + 3] * _416[y + 3];
            uvec4 param = texelFetch(sMetalnessRoughnessMaterialTags, sampling_pos, 0);
            MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
            if (ref_material_idx != metalness_roughness_material_tags.material_index)
            {
                w = 0.0;
            }
            float depth = texelFetch(sTextureDepth, sampling_pos, 0).x;
            if (abs(depth - ref_depth) > 0.00999999977648258209228515625)
            {
                w = 0.0;
            }
            if (w > 0.0)
            {
                vec4 c = texelFetch(sVolumetricFog, sampling_pos, 0);
                vc += (c * w);
                total_w += w;
            }
        }
    }
    return (c0 + vc) / vec4(total_w);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_196.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_196.dispatch_setup.camera_projection_params.z) + ((_196.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _196.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_196.dispatch_setup.camera_projection_params.w) + ((_196.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _196.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 normal = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    float voxel_occlusion_diffuse = 0.0;
    float voxel_occlusion_specular = 0.0;
    float voxel_occlusion_combined = 0.0;
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _196.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _196.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _196.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        voxel_occlusion_combined = voxel_light.w;
        vec2 voxel_occlusion = texelFetch(sVoxelOcclusion, ivec2(pixel_pos), 0).xy;
        voxel_occlusion_diffuse = voxel_occlusion.x;
        voxel_occlusion_specular = voxel_occlusion.y;
        vec4 color_1 = vec4(0.0);
        vec3 _710 = abs(local_normal);
        color_1.x = _710.x;
        color_1.y = _710.y;
        color_1.z = _710.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_522.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _522.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    uint materialIndex = metalness_roughness_material_tags.material_index;
    if (is_background == false)
    {
        MaterialPropertiesGPU _780;
        _780.diffuse = materials.material_properties[materialIndex].diffuse;
        _780.transparency = materials.material_properties[materialIndex].transparency;
        _780.emissive = materials.material_properties[materialIndex].emissive;
        _780.roughness = materials.material_properties[materialIndex].roughness;
        _780.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _780.refraction = materials.material_properties[materialIndex].refraction;
        _780.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _780.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _780.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _780.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _780.metalness = materials.material_properties[materialIndex].metalness;
        _780.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _780.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _780.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _780.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _780.flags = materials.material_properties[materialIndex].flags;
        _780._pad0 = materials.material_properties[materialIndex]._pad0;
        _780._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _780;
    }
    vec4 _781 = shadow;
    vec4 _789 = shadow;
    vec3 _791 = _789.xyz + ((_781.xyz * voxel_light.xyz) * _522.composite_setup.global_illumination_strength);
    shadow.x = _791.x;
    shadow.y = _791.y;
    shadow.z = _791.z;
    vec4 _803 = shadow;
    vec3 _805 = _803.xyz + (voxel_light.xyz * _522.composite_setup.global_illumination_base_strength);
    shadow.x = _805.x;
    shadow.y = _805.y;
    shadow.z = _805.z;
    if ((material.flags & 8u) != 0u)
    {
        vec2 param_6 = vec2(pixel_pos) * _196.dispatch_setup.inv_resolution;
        float param_7 = depth;
        vec4 _826 = sample_ssr(param_6, param_7);
        ssr = _826;
        ssr_factor = 1.0;
    }
    vec3 param_8 = world;
    vec3 param_9 = local_normal;
    vec3 param_10 = vec3(0.0);
    vec3 param_11 = vec3(0.0);
    float param_12 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_8, param_9, param_10, param_11, param_12);
    vec4 _843 = shadow;
    vec3 _845 = _843.xyz + fill_color.xyz;
    shadow.x = _845.x;
    shadow.y = _845.y;
    shadow.z = _845.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _868 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _522.composite_setup.ambient_color.xyz;
        color.x = _868.x;
        color.y = _868.y;
        color.z = _868.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _887 = color;
    vec3 _889 = _887.xyz + (ssr.xyz * 4.0);
    color.x = _889.x;
    color.y = _889.y;
    color.z = _889.z;
    vec4 _898 = color;
    vec3 _901 = _898.xyz + vec3(shadow.w);
    color.x = _901.x;
    color.y = _901.y;
    color.z = _901.z;
    if (_231.composite_params.composite_output_mode == 0)
    {
        float fog_density = linear_depth;
        if (_522.composite_setup.fog_range > 0.0)
        {
            fog_density /= _522.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _522.composite_setup.fog_height, 0.0, 1.0)) * _522.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _522.composite_setup.fog_color.xyz;
        vec4 _954 = color;
        vec3 _959 = mix(_954.xyz, fog_color, vec3(fog_density));
        color.x = _959.x;
        color.y = _959.y;
        color.z = _959.z;
        uvec2 param_13 = pixel_pos;
        float param_14 = depth;
        uint param_15 = materialIndex;
        vec4 volumetric_fog_color = sample_volumetric_fog(param_13, param_14, param_15);
        if (_522.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _980 = volumetric_fog_color;
            vec3 _985 = pow(_980.xyz, vec3(_522.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _985.x;
            volumetric_fog_color.y = _985.y;
            volumetric_fog_color.z = _985.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (true)
        {
            volumetric_fog_blend = 1.0 - volumetric_fog_blend;
            if (_522.composite_setup.volumetric_fog_strength > 0.0)
            {
                volumetric_fog_blend = exp((-volumetric_fog_blend) / _522.composite_setup.volumetric_fog_strength);
            }
            else
            {
                volumetric_fog_blend = 0.0;
            }
            volumetric_fog_blend = clamp(volumetric_fog_blend * _522.composite_setup.volumetric_fog_intensity, 0.0, 1.0);
        }
        vec4 _1017 = color;
        vec3 _1023 = mix(_1017.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _1023.x;
        color.y = _1023.y;
        color.z = _1023.z;
        if (_522.composite_setup.transparency_blend == 0u)
        {
            vec4 _1042 = color;
            vec3 _1044 = _1042.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _1044.x;
            color.y = _1044.y;
            color.z = _1044.z;
        }
        if (_522.composite_setup.transparency_blend == 1u)
        {
            vec4 _1056 = color;
            vec3 _1064 = mix(_1056.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _1064.x;
            color.y = _1064.y;
            color.z = _1064.z;
        }
    }
    else
    {
        if (_231.composite_params.composite_output_mode == 1)
        {
            color.x = albedo.xyz.x;
            color.y = albedo.xyz.y;
            color.z = albedo.xyz.z;
        }
        else
        {
            if (_231.composite_params.composite_output_mode == 2)
            {
                vec3 _1094 = (normal * 0.5) + vec3(0.5);
                color.x = _1094.x;
                color.y = _1094.y;
                color.z = _1094.z;
            }
            else
            {
                if (_231.composite_params.composite_output_mode == 3)
                {
                    vec3 _1109 = vec3(metalness_roughness_material_tags.roughness);
                    color.x = _1109.x;
                    color.y = _1109.y;
                    color.z = _1109.z;
                }
                else
                {
                    if (_231.composite_params.composite_output_mode == 4)
                    {
                        vec3 _1127 = texelFetch(sShadow, ivec2(pixel_pos), 0).xyz;
                        color.x = _1127.x;
                        color.y = _1127.y;
                        color.z = _1127.z;
                    }
                    else
                    {
                        if (_231.composite_params.composite_output_mode == 6)
                        {
                            vec3 _1154 = max(texelFetch(sShadow, ivec2(pixel_pos), 0).xyz, (albedo.xyz * voxel_light.xyz) * _522.composite_setup.global_illumination_strength);
                            color.x = _1154.x;
                            color.y = _1154.y;
                            color.z = _1154.z;
                        }
                        else
                        {
                            if (_231.composite_params.composite_output_mode == 5)
                            {
                                vec3 _1171 = voxel_light.xyz * _522.composite_setup.global_illumination_strength;
                                color.x = _1171.x;
                                color.y = _1171.y;
                                color.z = _1171.z;
                            }
                            else
                            {
                                if (_231.composite_params.composite_output_mode == 7)
                                {
                                    float ao = max(voxel_occlusion_combined, 1.0 - hbao);
                                    vec3 _1195 = vec3(1.0 - clamp(ao * _522.composite_setup.occlusion_strength, 0.0, 1.0));
                                    color.x = _1195.x;
                                    color.y = _1195.y;
                                    color.z = _1195.z;
                                    vec3 _1203 = vec3(voxel_occlusion_diffuse);
                                    color.x = _1203.x;
                                    color.y = _1203.y;
                                    color.z = _1203.z;
                                }
                                else
                                {
                                    if (_231.composite_params.composite_output_mode == 8)
                                    {
                                        vec3 _1218 = vec3(float(materialIndex));
                                        color.x = _1218.x;
                                        color.y = _1218.y;
                                        color.z = _1218.z;
                                    }
                                    else
                                    {
                                        if (_231.composite_params.composite_output_mode == 9)
                                        {
                                            uint material_flags = material.flags;
                                            if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
                                            {
                                                material_flags &= 4294967280u;
                                                material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
                                            }
                                            if ((material_flags & 1u) != 0u)
                                            {
                                                color.x = 1.0;
                                                color.y = 0.0;
                                                color.z = 0.0;
                                            }
                                        }
                                        else
                                        {
                                            if (_231.composite_params.composite_output_mode == 10)
                                            {
                                                vec3 _1278 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _231.composite_params.raytrace_scaling_factor), 0).xyz;
                                                color.x = _1278.x;
                                                color.y = _1278.y;
                                                color.z = _1278.z;
                                            }
                                            else
                                            {
                                                if (_231.composite_params.composite_output_mode == 11)
                                                {
                                                    vec3 _1300 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _231.composite_params.raytrace_scaling_factor), 0).www;
                                                    color.x = _1300.x;
                                                    color.y = _1300.y;
                                                    color.z = _1300.z;
                                                }
                                                else
                                                {
                                                    if (_231.composite_params.composite_output_mode == 12)
                                                    {
                                                        uvec2 param_16 = pixel_pos;
                                                        float param_17 = depth;
                                                        uint param_18 = materialIndex;
                                                        vec4 f = sample_volumetric_fog(param_16, param_17, param_18);
                                                        float blend = exp((-f.w) / _522.composite_setup.volumetric_fog_strength);
                                                        color.x = f.xyz.x;
                                                        color.y = f.xyz.y;
                                                        color.z = f.xyz.z;
                                                    }
                                                    else
                                                    {
                                                        if (_231.composite_params.composite_output_mode == 13)
                                                        {
                                                            vec3 _1345 = abs(particles.xyz);
                                                            color.x = _1345.x;
                                                            color.y = _1345.y;
                                                            color.z = _1345.z;
                                                        }
                                                        else
                                                        {
                                                            if (_231.composite_params.composite_output_mode == 14)
                                                            {
                                                                vec3 _1365 = vec3(fract(float(metalness_roughness_material_tags.component_tags) / 16.0));
                                                                color.x = _1365.x;
                                                                color.y = _1365.y;
                                                                color.z = _1365.z;
                                                            }
                                                            else
                                                            {
                                                                if (_231.composite_params.composite_output_mode == 15)
                                                                {
                                                                    vec3 _1384 = texelFetch(sDebug, ivec2(pixel_pos), 0).xyz;
                                                                    color.x = _1384.x;
                                                                    color.y = _1384.y;
                                                                    color.z = _1384.z;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (true)
    {
        int search_dist = 1;
        vec4 wc = texelFetch(sWireframeColor, ivec2(pixel_pos), 0);
        float wd = texelFetch(sWireframeDepth, ivec2(pixel_pos), 0).x;
        int _1411 = -search_dist;
        for (int iy = _1411; iy < search_dist; iy++)
        {
            int _1422 = -search_dist;
            for (int ix = _1422; ix < search_dist; ix++)
            {
                if ((ix == 0) && (iy == 0))
                {
                    continue;
                }
                float wd_neighborhood = texelFetch(sWireframeDepth, ivec2(pixel_pos) + ivec2(ix, iy), 0).x;
                if (wd_neighborhood < wd)
                {
                    wd = wd_neighborhood;
                    wc = texelFetch(sWireframeColor, ivec2(pixel_pos) + ivec2(ix, iy), 0);
                }
            }
        }
        if (wd < 1.0)
        {
            bool _1475 = wd < depth;
            bool _1484;
            if (!_1475)
            {
                _1484 = (wd >= depth) && is_background;
            }
            else
            {
                _1484 = _1475;
            }
            if (_1484)
            {
                vec4 _1487 = color;
                vec3 _1494 = mix(_1487.xyz, wc.xyz, vec3(wc.w));
                color.x = _1494.x;
                color.y = _1494.y;
                color.z = _1494.z;
            }
            else
            {
                if (wd < 1.0)
                {
                    float pattern = step(0.5, fract((((_1510.globals.global_time * float(pixel_pos.x)) * _196.dispatch_setup.inv_resolution.x) + ((_1510.globals.global_time * float(pixel_pos.y)) * _196.dispatch_setup.inv_resolution.y)) * 0.300000011920928955078125));
                    pattern = (pattern * 0.4000000059604644775390625) + 0.60000002384185791015625;
                    vec4 _1539 = color;
                    vec3 _1551 = mix(_1539.xyz, (wc.xyz * pattern) * 0.25, vec3(0.25 * wc.w));
                    color.x = _1551.x;
                    color.y = _1551.y;
                    color.z = _1551.z;
                }
            }
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 