#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _270;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _294;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _317;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _361;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _419;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _479;

layout(set = 0, binding = 9, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _830;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _877;

layout(set = 0, binding = 8, std430) buffer VM1
{
    ParticleModifierAttractor_Params VM1_params;
} _913;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_317.prt_prev_positions[(id * 3u) + 0u], _317.prt_prev_positions[(id * 3u) + 1u], _317.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _276;
    _276.life_time = _270.prt_states[id].life_time;
    _276.life_span = _270.prt_states[id].life_span;
    _276.generation_id = _270.prt_states[id].generation_id;
    _276.color = _270.prt_states[id].color;
    ParticleState _275 = _276;
    return _275;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _479.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _479.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _250 = hash(param);
    uint param_1 = _250;
    float _252 = floatConstruct(param_1);
    return _252;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _419.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _419.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _419.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_361.in_vtx_data[coord_offset + 0u], _361.in_vtx_data[coord_offset + 1u], _361.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_361.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _339 = color_convert_rgb_float3_uint(param);
    uint v = _339;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    for (int iteration = 0; iteration < 5; iteration++)
    {
        float fid = float((id + uint(iteration * 45827)) & 16777215u);
        float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed * 5.131999969482421875;
        float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
        float param_3 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
        face_idx += first_face_idx;
        uint param_4 = face_idx;
        RTFace rt_face = rt_get_face(param_4);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_5 = p0_idx;
        vec3 p0 = rt_get_vertex(param_5);
        uint param_6 = p1_idx;
        vec3 p1 = rt_get_vertex(param_6);
        uint param_7 = p2_idx;
        vec3 p2 = rt_get_vertex(param_7);
        uint param_8 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_8);
        uint param_9 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_9);
        uint param_10 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_10);
        float param_11 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_11);
        float param_12 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_12);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        float alpha = ((c0.w * bc.x) + (c1.w * bc.y)) + (c2.w * ((1.0 - bc.x) - bc.y));
        float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
        if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
        {
            if (emitter_params.surface_distance > 0.0)
            {
                vec3 n = normalize(cross(p0 - p1, p0 - p2));
                pos += (n * emitter_params.surface_distance);
            }
            if (pos.x == 1234567.0)
            {
                pos += vec3(fid_seed);
            }
            p.pos = pos;
            ParticleState param_13 = p.state;
            vec3 param_14 = emitter_params.particle_color.xyz;
            prt_set_color(param_13, param_14);
            p.state = param_13;
            ParticleState param_15 = p.state;
            float param_16 = lifetime;
            prt_spawn(param_15, param_16);
            p.state = param_15;
            if (emitter_params.alpha_to_modifier_factor != 0)
            {
                modifier_factor.factor = alpha;
            }
            emitted = true;
            break;
        }
    }
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _283;
    _283.life_time = state.life_time;
    _283.life_span = state.life_span;
    _283.generation_id = state.generation_id;
    _283.color = state.color;
    _270.prt_states[id] = _283;
}

void prt_set_position(uint id, vec3 p)
{
    _294.prt_positions[(id * 3u) + 0u] = p.x;
    _294.prt_positions[(id * 3u) + 1u] = p.y;
    _294.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_830.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _882 = atomicAdd(_877.VM0_params.pending, -1);
        int pending = _882;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _893;
            _893.constrained = _877.VM0_params.constrained;
            _893.debug_counter = _877.VM0_params.debug_counter;
            _893.debug_counter2 = _877.VM0_params.debug_counter2;
            _893.debug_counter3 = _877.VM0_params.debug_counter3;
            _893.position = _877.VM0_params.position;
            _893.falloff_mode = _877.VM0_params.falloff_mode;
            _893.radius = _877.VM0_params.radius;
            _893.falloff_inverse = _877.VM0_params.falloff_inverse;
            _893.particle_color = _877.VM0_params.particle_color;
            _893.particle_lifetime = _877.VM0_params.particle_lifetime;
            _893.particle_lifetime_randomness = _877.VM0_params.particle_lifetime_randomness;
            _893.rate = _877.VM0_params.rate;
            _893.seed = _877.VM0_params.seed;
            _893.surface_distance = _877.VM0_params.surface_distance;
            _893.pending = _877.VM0_params.pending;
            _893.transformed_data_location_idx = _877.VM0_params.transformed_data_location_idx;
            _893.transformed_data_location_num = _877.VM0_params.transformed_data_location_num;
            _893.alpha_to_modifier_factor = _877.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_4 = _893;
            ModifierFactor param_5 = modifier_factor;
            Particle param_6 = p;
            uint param_7 = id;
            uint param_8 = uint(pending);
            particle_emitter_geometry_emit(param_4, param_5, param_6, param_7, param_8);
            modifier_factor = param_5;
            p = param_6;
        }
    }
    ParticleState param_9 = p.state;
    if (prt_is_alive(param_9))
    {
        ParticleModifierAttractor_Params _918;
        _918.position = _913.VM1_params.position;
        _918.radius = _913.VM1_params.radius;
        _918.velocity = _913.VM1_params.velocity;
        ParticleModifierAttractor_Params param_10 = _918;
        ModifierFactor param_11 = modifier_factor;
        ParticleLifecycleParams _925;
        _925.time_step = _830.lifecycle_params.time_step;
        _925.max_lifetime = _830.lifecycle_params.max_lifetime;
        _925.reset = _830.lifecycle_params.reset;
        _925._pad1 = _830.lifecycle_params._pad1;
        ParticleLifecycleParams param_12 = _925;
        Particle param_13 = p;
        uint param_14 = id;
        particle_modifier_attractor(param_10, param_11, param_12, param_13, param_14);
        p = param_13;
    }
    ParticleState param_15 = p.state;
    float param_16 = _830.lifecycle_params.time_step;
    float param_17 = _830.lifecycle_params.max_lifetime;
    prt_advance_life(param_15, param_16, param_17);
    p.state = param_15;
    uint param_18 = id;
    ParticleState param_19 = p.state;
    prt_set_state(param_18, param_19);
    uint param_20 = id;
    vec3 param_21 = p.pos;
    prt_set_position(param_20, param_21);
}

 