#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

const uvec2 _926[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct VXParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    int filter_step;
    int compute_diffuse;
    int compute_specular;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _228;

layout(set = 0, binding = 3, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _400;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 4, std140) uniform VoxelLightingParams
{
    VXParams voxel_lighting_setup;
} _1064;

layout(set = 0, binding = 5, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 11) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 6, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 7, rgba16f) uniform writeonly image2D imTargetLighting;
layout(set = 0, binding = 8, rg16f) uniform writeonly image2D imTargetOcclusion;
layout(set = 0, binding = 9, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 13) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 14) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 10, rgba8) uniform image2D imDebug;
layout(set = 0, binding = 15) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 16) uniform sampler2D sTargetLightingPrevious;

int decode_material(uint data)
{
    return int(data >> 31u);
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

float linearizeDepth(float d)
{
    return _228.dispatch_setup.near_far_plane.z / ((_228.dispatch_setup.near_far_plane.y + _228.dispatch_setup.near_far_plane.x) - (d * _228.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_228.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

vec4 rt_cone_trace_sample_cubemap(sampler3D smp, int texture_size, vec3 p, float mip)
{
    return textureLod(smp, p, mip);
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _193 = v;
    float _197 = v.w;
    vec3 _200 = (_193.xyz * _197) * 128.0;
    v.x = _200.x;
    v.y = _200.y;
    v.z = _200.z;
    return v.xyz * v.xyz;
}

vec4 rt_cone_trace_occlusion(ivec2 screen_pos, sampler3D voxel_color_texture, sampler3D voxel_occupancy_texture, vec3 grid_size, int grid_res, vec3 grid_origin, vec3 origin, vec3 surface_normal, vec3 dir, float range, float lightTraceDistanceScale, float roughness, int rays, float color_falloff, float occlusion_falloff, float trace_range)
{
    if (range <= 0.0)
    {
        return vec4(0.0);
    }
    float occ = 0.0;
    vec3 occ_color = vec3(0.0);
    for (int si = 0; si < rays; si++)
    {
        vec3 c_color = vec3(0.0);
        float c_occlusion = 0.0;
        int frame = _400.globals.monotonic;
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, frame & 15), 0).xy;
        vec2 hash = _noise;
        vec3 param = dir;
        mat3 _427 = matrixFromVector(param);
        mat3 vecSpace = _427;
        float param_1 = hash.x * roughness;
        float param_2 = hash.y;
        vec3 V = CosineSampleHemisphere(param_1, param_2);
        V = vecSpace * V;
        float VdotN = dot(V, surface_normal);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * roughness;
            float param_4 = hash.y;
            V = CosineSampleHemisphere(param_3, param_4);
            V = vecSpace * V;
            VdotN = dot(V, surface_normal);
            if (VdotN < 0.0)
            {
                return vec4(0.0);
            }
        }
        vec3 p = origin;
        float prestep_distance = 3.0;
        p += ((surface_normal * range) * prestep_distance);
        float base_V = hash.x;
        float l = base_V * range;
        float max_l = 0.0;
        float coneAperture = tan(((roughness * 3.1415927410125732421875) * 0.5) * 0.100000001490116119384765625);
        float range_rcp = 1.0 / range;
        int steps = 0;
        bool is_inside = false;
        int iter = 0;
        bool loop = true;
        while (loop)
        {
            float diameter = max(range, (2.0 * coneAperture) * l);
            float mip = min(3.5, log2(diameter * range_rcp));
            vec3 grid_p = ((p + (V * l)) - grid_origin) / grid_size;
            vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _564 = all(greaterThanEqual(sample_p, vec3(0.0)));
                bool _571;
                if (_564)
                {
                    _571 = all(lessThan(sample_p, vec3(1.0)));
                }
                else
                {
                    _571 = _564;
                }
                if (_571)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _577 = any(lessThan(sample_p, vec3(0.0)));
                bool _584;
                if (!_577)
                {
                    _584 = any(greaterThanEqual(sample_p, vec3(1.0)));
                }
                else
                {
                    _584 = _577;
                }
                if (_584)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            float mip_coarse = min(3.5, mip + 1.0);
            int param_5 = 256;
            vec3 param_6 = sample_p;
            float param_7 = mip_coarse;
            vec4 gc = vec4(rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_5, param_6, param_7).xxxx);
            if (gc.w > 0.0040000001899898052215576171875)
            {
                int param_8 = 256;
                vec3 param_9 = sample_p;
                float param_10 = mip;
                gc.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_8, param_9, param_10).x;
                int param_11 = 256;
                vec3 param_12 = sample_p;
                float param_13 = mip;
                vec4 param_14 = rt_cone_trace_sample_cubemap(voxel_color_texture, param_11, param_12, param_13);
                vec3 _628 = color_convert_rgbm_rgb(param_14);
                vec3 _632 = vec3(_628);
                gc.x = _632.x;
                gc.y = _632.y;
                gc.z = _632.z;
            }
            if (gc.w > 0.75)
            {
                gc.w = 1.0;
            }
            float blend = 1.0 - c_occlusion;
            c_occlusion = min(1.0, c_occlusion + gc.w);
            c_color += (gc.xyz * blend);
            l += (diameter * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
            if (mip >= 1.5)
            {
                break;
            }
        }
        while (loop)
        {
            float diameter_1 = max(range, (2.0 * coneAperture) * l);
            float mip_1 = min(3.5, log2(diameter_1 * range_rcp));
            vec3 grid_p_1 = ((p + (V * l)) - grid_origin) / grid_size;
            vec3 sample_p_1 = (grid_p_1 + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _724 = all(greaterThanEqual(sample_p_1, vec3(0.0)));
                bool _730;
                if (_724)
                {
                    _730 = all(lessThan(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _730 = _724;
                }
                if (_730)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _736 = any(lessThan(sample_p_1, vec3(0.0)));
                bool _743;
                if (!_736)
                {
                    _743 = any(greaterThanEqual(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _743 = _736;
                }
                if (_743)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            if (is_inside)
            {
                vec4 gc_1 = vec4(0.0);
                int param_15 = 256;
                vec3 param_16 = sample_p_1;
                float param_17 = mip_1;
                gc_1.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_15, param_16, param_17).x;
                if (gc_1.w > 0.0040000001899898052215576171875)
                {
                    int param_18 = 256;
                    vec3 param_19 = sample_p_1;
                    float param_20 = mip_1;
                    vec4 param_21 = rt_cone_trace_sample_cubemap(voxel_color_texture, param_18, param_19, param_20);
                    vec3 _772 = color_convert_rgbm_rgb(param_21);
                    vec3 _776 = vec3(_772);
                    gc_1.x = _776.x;
                    gc_1.y = _776.y;
                    gc_1.z = _776.z;
                }
                if (gc_1.w > 0.75)
                {
                    gc_1.w = 1.0;
                }
                float blend_1 = 1.0 - c_occlusion;
                c_occlusion = min(1.0, c_occlusion + gc_1.w);
                c_color += (gc_1.xyz * blend_1);
            }
            l += (diameter_1 * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
        }
        c_occlusion = min(1.0, c_occlusion);
        float power = 0.75;
        occ += (c_occlusion / pow(l * occlusion_falloff, power));
        occ_color += (c_color * dot(V, dir));
    }
    occ /= float(rays);
    occ_color /= vec3(float(rays));
    if (occ > 1.0)
    {
        occ = 1.0;
    }
    return vec4(occ_color, occ);
}

float sample_previous_depth_max(sampler2D s, vec2 p, float ref_d)
{
    float d = texelFetch(s, ivec2((p * _228.dispatch_setup.resolution) + vec2(0.5)), 0).x;
    vec4 d4 = textureGather(s, p);
    float param = d;
    return linearizeDepth(param);
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_228.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float param_2;
    float param_3;
    uint param_4;
    vec3 view_direction;
    vec3 view_direction_prev;
    for (int i = 0; i < 1; i++)
    {
        ivec2 pos = ivec2((pixel_pos * uvec2(1u)) + _926[i]);
        ivec2 noise_pos = pos & ivec2(127);
        uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
        uint param = encoded_normal_material;
        int materialId = decode_material(param);
        if ((materialId & 1) == 1)
        {
            imageStore(imTargetLighting, pos, vec4(1.0));
            imageStore(imTargetOcclusion, pos, vec4(1.0));
        }
        else
        {
            uvec2 param_1 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
            decode_metalness_roughness_material(param_1, param_2, param_3, param_4);
            float metalness = param_2;
            float roughness = param_3;
            uint material = param_4;
            view_direction.x = (-_228.dispatch_setup.camera_projection_params.z) + ((_228.dispatch_setup.camera_projection_params.x * float(pos.x)) * _228.dispatch_setup.inv_resolution.x);
            view_direction.y = (-_228.dispatch_setup.camera_projection_params.w) + ((_228.dispatch_setup.camera_projection_params.y * float(pos.y)) * _228.dispatch_setup.inv_resolution.y);
            view_direction.z = 1.0;
            view_direction.y = -view_direction.y;
            uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
            uint param_5 = encoded_normal_material_1;
            vec3 vNorm = decode_normal(param_5);
            uint param_6 = encoded_normal_material_1;
            int materialId_1 = decode_material(param_6);
            float param_7 = texelFetch(sTextureDepth, pos, 0).x;
            float depth = linearizeDepth(param_7);
            vec3 param_8 = view_direction;
            float param_9 = depth;
            vec3 world = positionFromDepth(param_8, param_9);
            vec3 dir = normalize(world - _228.dispatch_setup.camera_position);
            vec4 diffuse = vec4(0.0);
            vec4 specular = vec4(0.0);
            bool _1067 = _1064.voxel_lighting_setup.compute_diffuse != 0;
            bool _1083;
            if (_1067)
            {
                _1083 = (materials.material_properties[material].flags & 32768u) != 0u;
            }
            else
            {
                _1083 = _1067;
            }
            if (_1083)
            {
                ivec2 param_10 = noise_pos;
                vec3 param_11 = in_bbox_data.grid_size_voxelize.xyz;
                int param_12 = 256;
                vec3 param_13 = in_bbox_data.bbox_voxelize_min.xyz;
                vec3 param_14 = world;
                vec3 param_15 = vNorm;
                vec3 param_16 = vNorm;
                float param_17 = range;
                float param_18 = _1064.voxel_lighting_setup.light_trace_distance_scale;
                float param_19 = min(1.0, 0.550000011920928955078125 + (roughness * 0.25));
                int param_20 = 1;
                float param_21 = _1064.voxel_lighting_setup.light_falloff_factor;
                float param_22 = _1064.voxel_lighting_setup.occlusion_falloff_factor;
                float param_23 = _1064.voxel_lighting_setup.trace_range;
                diffuse = rt_cone_trace_occlusion(param_10, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_11, param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21, param_22, param_23) * vec4(vec3(1.0 - metalness), 1.0);
            }
            bool _1140 = _1064.voxel_lighting_setup.compute_specular != 0;
            bool _1149;
            if (_1140)
            {
                _1149 = (materials.material_properties[material].flags & 16384u) != 0u;
            }
            else
            {
                _1149 = _1140;
            }
            if (_1149)
            {
                vec3 dir_1 = normalize(reflect(world - _228.dispatch_setup.camera_position, vNorm));
                float specular_roughness = dot(dir_1, vNorm) * roughness;
                specular_roughness *= specular_roughness;
                ivec2 param_24 = noise_pos;
                vec3 param_25 = in_bbox_data.grid_size_voxelize.xyz;
                int param_26 = 256;
                vec3 param_27 = in_bbox_data.bbox_voxelize_min.xyz;
                vec3 param_28 = world;
                vec3 param_29 = vNorm;
                vec3 param_30 = dir_1;
                float param_31 = range;
                float param_32 = _1064.voxel_lighting_setup.light_trace_distance_scale;
                float param_33 = specular_roughness;
                int param_34 = 1;
                float param_35 = _1064.voxel_lighting_setup.light_falloff_factor;
                float param_36 = _1064.voxel_lighting_setup.occlusion_falloff_factor;
                float param_37 = _1064.voxel_lighting_setup.trace_range;
                specular = rt_cone_trace_occlusion(param_24, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_25, param_26, param_27, param_28, param_29, param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37);
                specular *= (1.0 - ((roughness * roughness) * 0.85000002384185791015625));
            }
            else
            {
                specular.w = 0.0;
            }
            vec4 combined_lighting_occlusion = diffuse;
            vec4 _1218 = combined_lighting_occlusion;
            vec3 _1220 = _1218.xyz + specular.xyz;
            combined_lighting_occlusion.x = _1220.x;
            combined_lighting_occlusion.y = _1220.y;
            combined_lighting_occlusion.z = _1220.z;
            float diffuse_occlusion = diffuse.w;
            float specular_occlusion = specular.w;
            vec2 combined_occlusion = vec2(diffuse_occlusion, specular_occlusion);
            float specular_occlusion_contribution = clamp(0.5 - roughness, 0.0, 1.0);
            combined_lighting_occlusion.w = (combined_lighting_occlusion.w * (1.0 - (specular_occlusion_contribution * 0.5))) + (specular.w * specular_occlusion_contribution);
            if (false)
            {
                vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
                combined_lighting_occlusion.x = hash.x;
                combined_lighting_occlusion.y = hash.y;
                combined_lighting_occlusion.z = hash.z;
                combined_lighting_occlusion.w = hash.x;
            }
            float samples = imageLoad(imDebug, pos).w * 255.0;
            bool _1292;
            if (true)
            {
                _1292 = (materials.material_properties[material].flags & 65536u) != 0u;
            }
            else
            {
                _1292 = true;
            }
            if (_1292)
            {
                vec4 view_prev = vec4(world, 1.0);
                view_prev = _228.dispatch_setup.mat_view_previous * view_prev;
                view_prev = _228.dispatch_setup.mat_projection * view_prev;
                vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
                vec2 screen_prev = proj_prev.xy;
                proj_prev.y = 1.0 - proj_prev.y;
                bool _1328 = screen_prev.x >= 0.0;
                bool _1334;
                if (_1328)
                {
                    _1334 = screen_prev.y >= 0.0;
                }
                else
                {
                    _1334 = _1328;
                }
                bool _1340;
                if (_1334)
                {
                    _1340 = screen_prev.x < 1.0;
                }
                else
                {
                    _1340 = _1334;
                }
                bool _1346;
                if (_1340)
                {
                    _1346 = screen_prev.y < 1.0;
                }
                else
                {
                    _1346 = _1340;
                }
                if (_1346)
                {
                    view_direction_prev.x = (-_228.dispatch_setup.camera_projection_params.z) + (_228.dispatch_setup.camera_projection_params.x * screen_prev.x);
                    view_direction_prev.y = (-_228.dispatch_setup.camera_projection_params.w) + (_228.dispatch_setup.camera_projection_params.y * screen_prev.y);
                    view_direction_prev.z = 1.0;
                    vec2 param_38 = proj_prev.xy;
                    float param_39 = texelFetch(sTextureDepth, pos, 0).x;
                    float depth_prev = sample_previous_depth_max(sTextureDepthPrevious, param_38, param_39);
                    vec3 param_40 = view_direction_prev;
                    float param_41 = depth_prev;
                    vec3 world_prev = positionFromDepthPrevious(param_40, param_41);
                    vec3 param_42 = vNorm;
                    mat4 param_43 = _228.dispatch_setup.mat_model;
                    vec3 screenVNorm = vector_transform_by_mat33(param_42, param_43);
                    float tolerance = _1064.voxel_lighting_setup.reprojection_tolerance;
                    if (length(world - world_prev) <= tolerance)
                    {
                        vec4 combined_lighting_occlusion_prev = textureLod(sTargetLightingPrevious, proj_prev.xy + (_228.dispatch_setup.inv_resolution * 0.5), 0.0);
                        float f = 0.100000001490116119384765625;
                        f = 1.0 / (1.0 + min(4.0, samples));
                        combined_lighting_occlusion = mix(combined_lighting_occlusion_prev, combined_lighting_occlusion, vec4(f));
                        samples += 1.0;
                        imageStore(imDebug, pos, vec4(f, 0.0, 0.0, samples / 255.0));
                    }
                    else
                    {
                        samples = 1.0;
                        imageStore(imDebug, pos, vec4(0.0, 1.0, 1.0, samples / 255.0));
                    }
                }
            }
            imageStore(imTargetLighting, pos, combined_lighting_occlusion);
            imageStore(imTargetOcclusion, pos, vec4(combined_occlusion, 0.0, 0.0));
        }
    }
}

 