#version 450
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#extension GL_KHR_shader_subgroup_ballot : require
layout(early_fragment_tests) in;

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state_user_data
{
    uint dummy;
};

struct ray_traversal_params
{
    float trace_range_primary;
    float trace_range_secondary;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    bool running;
    int16_t bounces;
    int16_t material;
    int tests;
    int face_tests;
    bool hit;
    bool left;
    bool inside_transparent;
    uint active_threads_factor;
    uint active_threads_samples;
    float final_color_factor;
    ray_state_user_data user_data;
};

struct IBLOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float trace_range_primary;
    float trace_range_secondary;
    float roughness_clamp;
    float env_map_intensity;
    int lights_num;
    float initial_face_start_distance;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct _3198
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _573;

layout(set = 1, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _680;

layout(set = 1, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _693;

layout(set = 1, binding = 4, std430) readonly buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _1422;

layout(set = 1, binding = 5, std430) readonly buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 1, binding = 6, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 7, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _2151;

layout(set = 1, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 9, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 10, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _3087;

layout(set = 1, binding = 11, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _3208;

layout(set = 1, binding = 15) uniform usampler3D s_grid_marker;
layout(set = 1, binding = 16) uniform samplerCube s_reflection;
layout(set = 1, binding = 17) uniform sampler2D s_BRDF;
layout(set = 1, binding = 18) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 34) uniform sampler2D material_textures[64];
layout(set = 1, binding = 98) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 12, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 99) uniform sampler2D sTextureDepth;
layout(set = 1, binding = 13, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 1, binding = 14, rgba16f) uniform readonly image2D imAlbedo;

layout(location = 1) in _3198 vtx_input;
layout(location = 0) out vec4 outFresnelReflection;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

float linearizeDepth(float d)
{
    return _2151.rt_setup.near_far_plane.z / ((_2151.rt_setup.near_far_plane.y + _2151.rt_setup.near_far_plane.x) - (d * _2151.rt_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 rt_randomize_dir_for_roughness(inout ivec2 screen_pos, inout vec3 dir, vec3 n, inout float roughness, inout float bounce_throughput)
{
    bounce_throughput = 1.0;
    if (roughness > 0.0)
    {
        roughness = min(_2151.rt_setup.roughness_clamp, roughness);
        roughness = dot(dir, n) * roughness;
        bounce_throughput *= max(0.0, 1.0 - roughness);
        int frame = _3087.globals.monotonic & 127;
        float clamped_roughness = roughness * roughness;
        screen_pos &= ivec2(127);
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, 0), 0).xy;
        vec2 hash = fract(_noise + vec2(float(frame) * 1.61803400516510009765625));
        float param = hash.x * clamped_roughness;
        float param_1 = hash.y;
        vec3 d = CosineSampleHemisphere(param, param_1);
        vec3 param_2 = dir;
        mat3 _3135 = matrixFromVector(param_2);
        mat3 vecSpace = _3135;
        d = vecSpace * d;
        float VdotN = dot(d, n);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * clamped_roughness;
            float param_4 = hash.y;
            d = CosineSampleHemisphere(param_3, param_4);
            d = vecSpace * d;
            VdotN = dot(d, n);
            if (VdotN > 0.0)
            {
                dir = d;
            }
        }
        else
        {
            dir = d;
        }
    }
    return dir;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

bool is_pos_inside_grid(i16vec3 icell)
{
    int16_t icell_mask = (icell.x | icell.y) | icell.z;
    if ((int(icell_mask) & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

bool rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u) ? true : false;
}

bool fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return rt_read_grid_marker_high_res(s_grid_marker, param);
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return rt_read_grid_marker_low_res(s_grid_marker, param_1);
    }
}

ivec3 dda_step_from_dir(vec3 dir, vec3 cell_step)
{
    vec3 s = step(vec3(0.0), dir);
    vec3 sgn = ((s * cell_step) * 2.0) - cell_step;
    return ivec3(sgn);
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _693.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _693.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _693.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_573.in_vtx_data[coord_offset + 0u], _573.in_vtx_data[coord_offset + 1u], _573.in_vtx_data[coord_offset + 2u]);
    return p;
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _1356 = v < 0.0;
    bool _1364;
    if (!_1356)
    {
        _1364 = (u + v) > 1.0;
    }
    else
    {
        _1364 = _1356;
    }
    if (_1364)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2(ray_state_user_data user_data, uint list_index, bool bucket_full, uint max_tests, vec3 origin, vec3 dir, int skip_fi, float max_t, inout int closest_fi, inout uint material_flags, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc, out int face_tests)
{
    face_tests = 0;
    closest_fi = -1;
    closest_it = max_t;
    uint head = _1422.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    if ((max_tests != 4294967295u) && (cnt >= max_tests))
    {
        closest_fi = -1;
        return;
    }
    face_tests = int(cnt);
    for (int fi_idx = 0; uint(fi_idx) < cnt; fi_idx++)
    {
        int fi = int(in_faces_list_data.node_buffer[(head + uint(fi_idx)) + 1u]);
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        RTFace rt_face = rt_get_face(param);
        uint param_1 = rt_face.v0;
        vec3 p0 = rt_get_vertex(param_1);
        uint param_2 = rt_face.v1;
        vec3 p1 = rt_get_vertex(param_2);
        uint param_3 = rt_face.v2;
        vec3 p2 = rt_get_vertex(param_3);
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _1505 = it1.t >= 0.0;
        bool _1512;
        if (_1505)
        {
            _1512 = it1.t <= closest_it;
        }
        else
        {
            _1512 = _1505;
        }
        if (_1512)
        {
            if ((rt_face.material_flags & 64u) == 0u)
            {
                if (dot(dir, it1.normal) >= 0.0)
                {
                    continue;
                }
            }
            closest_fi = fi;
            closest_it = it1.t;
        }
    }
    if (closest_fi != (-1))
    {
        uint param_9 = uint(closest_fi);
        RTFace rt_face_1 = rt_get_face(param_9);
        uint param_10 = rt_face_1.v0;
        vec3 p0_1 = rt_get_vertex(param_10);
        uint param_11 = rt_face_1.v1;
        vec3 p1_1 = rt_get_vertex(param_11);
        uint param_12 = rt_face_1.v2;
        vec3 p2_1 = rt_get_vertex(param_12);
        vec3 param_13 = origin;
        vec3 param_14 = dir;
        vec3 param_15 = p2_1;
        vec3 param_16 = p1_1;
        vec3 param_17 = p0_1;
        intersection it1_1 = intersectTriangle3(param_13, param_14, param_15, param_16, param_17);
        closest_norm = it1_1.normal;
        closest_bc = it1_1.bc;
        material_flags = rt_face_1.material_flags;
    }
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return vec2(rt_barycentric_yz(param_4, param_5, param_6, param_7));
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _573.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _573.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_2));
    uint param_3 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_3));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return vec3(normalize(smooth_normal));
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_680.transformed_data_faces[idx].material_idx);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_573.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec4 interpolate_color_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec4 c0 = vec4(rt_get_vertex_color(param_1));
    uint param_2 = i1;
    vec4 c1 = vec4(rt_get_vertex_color(param_2));
    uint param_3 = i2;
    vec4 c2 = vec4(rt_get_vertex_color(param_3));
    vec4 c = ((c0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (c1 * bc_yz.x)) + (c2 * bc_yz.y);
    return c;
}

vec2 rt_get_vertex_uv0(uint idx)
{
    uint uv0_offset = (idx * 2u) + 50000000u;
    vec2 p = vec2(_573.in_vtx_data[uv0_offset + 0u], _573.in_vtx_data[uv0_offset + 1u]);
    return p;
}

vec2 interpolate_uv_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec2 uv0 = vec2(rt_get_vertex_uv0(param_1));
    uint param_2 = i1;
    vec2 uv1 = vec2(rt_get_vertex_uv0(param_2));
    uint param_3 = i2;
    vec2 uv2 = vec2(rt_get_vertex_uv0(param_3));
    vec2 uv = ((uv0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (uv1 * bc_yz.x)) + (uv2 * bc_yz.y);
    return uv;
}

vec4 evaluate_albedo(int16_t materialIndex, int fi, vec2 bc)
{
    int param = fi;
    vec2 param_1 = bc;
    vec4 c = interpolate_color_from_bc_yz(param, param_1);
    if (materials.material_properties[materialIndex].albedo_sampler >= 0)
    {
        int param_2 = fi;
        vec2 param_3 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param_2, param_3);
        c *= vec4(textureLod(material_textures[materials.material_properties[materialIndex].albedo_sampler], uv, 1.0));
    }
    return c;
}

vec3 evaluate_emissive(int16_t materialIndex, int fi, vec2 bc)
{
    vec3 c = vec3(1.0);
    if (materials.material_properties[materialIndex].emissive_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = vec3(textureLod(material_textures[materials.material_properties[materialIndex].emissive_sampler], uv, 1.0).xyz);
    }
    return c;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _829 = falloff > cutoff;
    bool _836;
    if (_829)
    {
        _836 = light_distance < light.range;
    }
    else
    {
        _836 = _829;
    }
    if (_836)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1017 = angularInfo.NdotL > 0.0;
    bool _1024;
    if (!_1017)
    {
        _1024 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1024 = _1017;
    }
    if (_1024)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

vec3 sample_projector_texture(sampler2D smpl, inout vec4 coords)
{
    vec3 color = vec3(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _2302 = coords.x < (-coords.w);
    bool _2311;
    if (!_2302)
    {
        _2311 = coords.x > coords.w;
    }
    else
    {
        _2311 = _2302;
    }
    bool _2321;
    if (!_2311)
    {
        _2321 = coords.y < (-coords.w);
    }
    else
    {
        _2321 = _2311;
    }
    bool _2330;
    if (!_2321)
    {
        _2330 = coords.y > coords.w;
    }
    else
    {
        _2330 = _2321;
    }
    if (_2330)
    {
        return color;
    }
    vec4 _2335 = coords;
    float _2340 = coords.w;
    vec2 _2342 = (_2335.xy * vec2(0.5)) + (vec2(0.5) * _2340);
    coords.x = _2342.x;
    coords.y = _2342.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w)).xyz;
    return color;
}

IBLOutput ibl(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    float mip_count = 7.5;
    float lod = clamp(perceptual_roughness * mip_count, 0.0, mip_count);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = texture(s_BRDF, brdf_sample_point).xy;
    vec3 diffuseLight = textureLod(s_reflection, n, 5.0).xyz;
    vec3 specularLight = textureLod(s_reflection, r, lod).xyz * (brdf.x + brdf.y);
    IBLOutput ibl_1;
    ibl_1.color_weighted = (diffuseColor * diffuseLight) + (specularColor * specularLight);
    ibl_1.color_raw = diffuseLight + specularLight;
    return ibl_1;
}

vec3 evaluate_lighting(vec3 p, vec3 o, vec3 n, int material, vec3 albedo, vec3 emissive)
{
    vec3 c = vec3(0.0);
    vec3 world = p;
    vec3 view = normalize(o - p);
    vec3 f0 = vec3(0.039999999105930328369140625);
    float metallic = materials.material_properties[material].metalness;
    vec3 baseColor = vec3(clamp(materials.material_properties[material].diffuse * albedo, vec3(0.0), vec3(1.0)));
    vec3 diffuseColor = (baseColor * (vec3(1.0) - f0)) * (1.0 - metallic);
    vec3 specularColor = vec3(mix(f0, baseColor, vec3(metallic)));
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    float roughness = materials.material_properties[material].roughness;
    float alphaRoughness = roughness * roughness;
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    for (int light_idx = 0; light_idx < _2151.rt_setup.lights_num; light_idx++)
    {
        LightProperties _2490;
        _2490.diffuse = lights.light_properties[light_idx].diffuse;
        _2490.direction = lights.light_properties[light_idx].direction;
        _2490.position = lights.light_properties[light_idx].position;
        _2490.up = lights.light_properties[light_idx].up;
        _2490.right = lights.light_properties[light_idx].right;
        _2490.dimensions = lights.light_properties[light_idx].dimensions;
        _2490._pad1 = lights.light_properties[light_idx]._pad1;
        _2490.intensity = lights.light_properties[light_idx].intensity;
        _2490.range = lights.light_properties[light_idx].range;
        _2490.cutoff = lights.light_properties[light_idx].cutoff;
        _2490.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _2490.is_area = lights.light_properties[light_idx].is_area;
        _2490.type = lights.light_properties[light_idx].type;
        _2490.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _2490.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _2490.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _2490.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _2490.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _2490.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _2490.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _2490.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _2490.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _2490.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _2490.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _2490.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _2490.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _2490.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _2490.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _2490.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _2490.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _2490.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _2490.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _2490;
        if ((light.type & 3) != 0)
        {
            vec3 pointToLight = light.position.xyz - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction.xyz;
            }
            pointToLight = normalize(pointToLight);
            float NdotL = dot(vec3(n), pointToLight);
            vec3 lighting = vec3(0.0);
            if (NdotL > 0.0)
            {
                float attenuation = 1.0;
                if ((light.type & 2) != 0)
                {
                    LightProperties param = light;
                    vec3 param_1 = world;
                    attenuation = light_calculate_spot_attenuation(param, param_1);
                }
                if (attenuation > 0.0)
                {
                    vec4 vShadowCoords = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                    vec3 param_2 = pointToLight;
                    MaterialInfo param_3 = materialInfo;
                    vec3 param_4 = n;
                    vec3 param_5 = view;
                    lighting = (getPointShade(param_2, param_3, param_4, param_5) * (light.intensity * attenuation)) * light.diffuse.xyz;
                    if ((light.type & 16) != 0)
                    {
                        vec4 vShadowCoords_1 = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                        float shadow = 0.0;
                        vec4 param_6 = vShadowCoords_1;
                        vec3 _2605 = sample_projector_texture(LightProjectorSamplers[light.projector_sampler], param_6);
                        lighting *= (_2605 * ((1.0 - shadow) * light.projector_intensity));
                    }
                    c += lighting;
                }
            }
        }
    }
    vec3 param_7 = n;
    vec3 param_8 = view;
    vec3 param_9 = diffuseColor;
    vec3 param_10 = specularColor;
    vec3 param_11 = specularEnvironmentR0;
    vec3 param_12 = specularEnvironmentR90;
    float param_13 = roughness;
    IBLOutput ibl_1 = ibl(param_7, param_8, param_9, param_10, param_11, param_12, param_13);
    c += (ibl_1.color_weighted * _2151.rt_setup.env_map_intensity);
    c += (emissive * materials.material_properties[material].emissive_factor);
    return vec3(c);
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(vec3(v), n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

vec3 yCgCo2rgb(vec3 ycc)
{
    float R = (ycc.x - ycc.y) + ycc.z;
    float G = ycc.x + ycc.y;
    float B = (ycc.x - ycc.y) - ycc.z;
    return vec3(R, G, B);
}

vec3 spectrum_offset_ycgco(float t)
{
    vec3 ygo = vec3(1.0, 0.0, (-1.25) * t);
    vec3 param = ygo;
    return yCgCo2rgb(param);
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int hit_face, uint hit_material_flags, vec2 bc, bool flip_normal_on_glass)
{
    uint param = uint(hit_face);
    int16_t hit_material = int16_t(rt_get_triangle_material(param));
    int16_t param_1 = hit_material;
    int param_2 = hit_face;
    vec2 param_3 = bc;
    vec4 hit_albedo = evaluate_albedo(param_1, param_2, param_3);
    int16_t param_4 = hit_material;
    int param_5 = hit_face;
    vec2 param_6 = bc;
    vec3 hit_emissive = evaluate_emissive(param_4, param_5, param_6) * vec3(materials.material_properties[hit_material].emissive);
    vec3 camera_position = _2151.rt_setup.camera_position;
    if (flip_normal_on_glass)
    {
        vec3 d = camera_position - state.origin;
        camera_position = reflect(d, -state.normal) + state.origin;
    }
    vec3 param_7 = state.origin;
    vec3 param_8 = camera_position;
    vec3 param_9 = state.normal;
    int param_10 = int(hit_material);
    vec3 param_11 = hit_albedo.xyz;
    vec3 param_12 = hit_emissive;
    vec3 hit_color = evaluate_lighting(param_7, param_8, param_9, param_10, param_11, param_12);
    bool hit_material_reflective = materials.material_properties[hit_material].roughness < 1.0;
    if ((materials.material_properties[state.material].flags & 32u) == 0u)
    {
        hit_color = vec3(state.color * hit_color);
        state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
        bool _2872;
        if (!state.hit)
        {
            _2872 = int(state.bounces) == 4;
        }
        else
        {
            _2872 = state.hit;
        }
        state.hit = _2872;
    }
    else
    {
        bool _2876 = hit_material_reflective == false;
        bool _2882;
        if (_2876)
        {
            _2882 = (hit_material_flags & 32u) == 0u;
        }
        else
        {
            _2882 = _2876;
        }
        if (_2882)
        {
            state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            state.running = false;
            state.hit = true;
        }
        else
        {
            bool _2901 = hit_material_reflective == true;
            bool _2907;
            if (_2901)
            {
                _2907 = (hit_material_flags & 32u) == 0u;
            }
            else
            {
                _2907 = _2901;
            }
            if (_2907)
            {
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
                bool _2931;
                if (!state.hit)
                {
                    _2931 = int(state.bounces) == 4;
                }
                else
                {
                    _2931 = state.hit;
                }
                state.hit = _2931;
            }
            else
            {
                float alpha = 0.25 * (1.0 - materials.material_properties[state.material].transparency);
                float absorbance = alpha * (-length(prev_state_origin - state.origin));
                float attenuation = exp(absorbance);
                bool is_current_transparent_and_doublesided = (materials.material_properties[state.material].flags & 96u) == 96u;
                if (is_current_transparent_and_doublesided == false)
                {
                    attenuation = 1.0;
                }
                float hit_transparency = 1.0 - ((1.0 - materials.material_properties[hit_material].transparency) * hit_albedo.w);
                state.transparency = (state.transparency * hit_transparency) * attenuation;
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            }
        }
    }
    if ((hit_material_flags & 32u) == 0u)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
        state.inside_transparent = false;
    }
    else
    {
        vec3 param_13 = state.dir;
        vec3 param_14 = state.normal;
        vec3 refracted_dir = glass_refract(param_13, param_14);
        float angle = dot(refracted_dir, state.dir);
        float threshold = 0.0;
        angle = 1.0 - abs(angle);
        float factor = clamp(angle * 5.0, 0.0, 1.0);
        angle *= 10.5;
        float param_15 = angle;
        state.color = mix(state.color, spectrum_offset_ycgco(param_15), vec3(factor));
        state.dir = refracted_dir;
        state.inside_transparent = !state.inside_transparent;
    }
    bool _3052 = (hit_material_flags & 1u) == 0u;
    bool _3058;
    if (_3052)
    {
        _3058 = (hit_material_flags & 32u) == 0u;
    }
    else
    {
        _3058 = _3052;
    }
    if (_3058)
    {
        state.running = false;
        state.hit = true;
    }
    state.material = hit_material;
}

int findClosestDDAMultibounce(ray_traversal_params traversal_params, inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces)
{
    closest_fi = -1;
    closest_it = 1000000.0;
    vec3 cellDimension = vec3(in_bbox_data.grid_size_raytrace.xyz);
    float tmin = 0.0;
    float tmax = traversal_params.trace_range_primary;
    vec3 ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro_cell / cellDimension));
    vec3 s = step(vec3(0.0), state.dir);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 deltaT = (sgn * cellDimension) / state.dir;
    vec3 nextCrossingT = vec3(tmin) + ((((floor(ro_cell / cellDimension) + s) * cellDimension) - ro_cell) / state.dir);
    float rt = tmin;
    bool inside = false;
    bool prev_inside = inside;
    int max_iter = 1024;
    bool param = true;
    int threads_running = int(ballot_count(param));
    int param_20;
    uint param_21;
    float param_22;
    vec3 param_23;
    vec2 param_24;
    int param_25;
    while ((rt < tmax) && (max_iter >= 0))
    {
        bool hit = false;
        max_iter--;
        state.tests++;
        if (state.running == false)
        {
            break;
        }
        rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        prev_inside = prev_inside || inside;
        inside = false;
        bool search_bucket = false;
        uint icell_idx = 0u;
        bool bucket_full = false;
        i16vec3 param_1 = i16vec3(icell);
        if (is_pos_inside_grid(param_1))
        {
            inside = true;
            icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
            ivec3 param_2 = icell;
            int param_3 = 0;
            bucket_full = fetch_grid_marker_for_cell(param_2, param_3);
        }
        if (true)
        {
            bool _1795;
            if (!bucket_full)
            {
                _1795 = (prev_inside == true) && (inside == false);
            }
            else
            {
                _1795 = bucket_full;
            }
            bool done_criteria = _1795;
            bool param_4 = done_criteria;
            uint hit_threads = ballot_count(param_4);
            int ii = 0;
            while ((hit_threads < 16u) && (ii < 4))
            {
                state.tests++;
                if (done_criteria == false)
                {
                    max_iter--;
                    vec3 mm = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
                    vec3 param_5 = state.dir;
                    vec3 param_6 = mm;
                    icell += dda_step_from_dir(param_5, param_6);
                    nextCrossingT += (mm * deltaT);
                    rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
                    i16vec3 param_7 = i16vec3(icell);
                    inside = is_pos_inside_grid(param_7);
                    prev_inside = prev_inside || inside;
                    if (inside)
                    {
                        icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
                        ivec3 param_8 = icell;
                        int param_9 = 0;
                        bucket_full = fetch_grid_marker_for_cell(param_8, param_9);
                    }
                    bool _1889;
                    if (!bucket_full)
                    {
                        _1889 = (prev_inside == true) && (inside == false);
                    }
                    else
                    {
                        _1889 = bucket_full;
                    }
                    done_criteria = _1889;
                }
                ii++;
                bool param_10 = done_criteria;
                hit_threads = ballot_count(param_10);
            }
        }
        if (bucket_full)
        {
            bool param_11 = true;
            state.active_threads_factor += ballot_count(param_11);
            state.active_threads_samples++;
            int face_tests = 0;
            uint max_tests = 4294967295u;
            bool _1913 = closest_fi == (-1);
            bool _1920;
            if (_1913)
            {
                _1920 = state.face_tests > 512;
            }
            else
            {
                _1920 = _1913;
            }
            if (_1920)
            {
                max_tests = 16u;
            }
            ray_state_user_data param_12 = state.user_data;
            uint param_13 = icell_idx;
            bool param_14 = bucket_full;
            uint param_15 = max_tests;
            vec3 param_16 = state.origin;
            vec3 param_17 = state.dir;
            int param_18 = skip_fi;
            float param_19 = min(tmax, rt);
            findClosestBucket2(param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21, param_22, param_23, param_24, param_25);
            state.user_data = param_12;
            closest_fi = param_20;
            uint closest_material_flags = param_21;
            closest_it = param_22;
            vec3 closest_normal = param_23;
            vec2 closest_bc = param_24;
            face_tests = param_25;
            state.face_tests += face_tests;
            if (closest_fi != (-1))
            {
                state.bounces += 1s;
                state.normal = closest_normal;
                hit = true;
                skip_fi = closest_fi;
                bool _1983 = int(state.bounces) >= max_bounces;
                bool _1991;
                if (!_1983)
                {
                    _1991 = (closest_material_flags & 2048u) != 0u;
                }
                else
                {
                    _1991 = _1983;
                }
                if (_1991)
                {
                    state.running = false;
                }
                int param_26 = closest_fi;
                vec3 param_27 = state.origin + (state.dir * closest_it);
                vec2 bc = barycentric_for_face_yz(param_26, param_27);
                if ((closest_material_flags & 128u) == 0u)
                {
                    int param_28 = closest_fi;
                    vec2 param_29 = bc;
                    vec3 param_30 = state.normal;
                    state.normal = interpolate_normal_from_bc_yz(param_28, param_29, param_30);
                }
                bool flip_normal_on_glass = false;
                if ((closest_material_flags & 32u) != 0u)
                {
                    flip_normal_on_glass = (dot(state.normal, state.dir) > 0.0) ? true : false;
                }
                vec3 prev_state_origin = state.origin;
                state.origin += (state.dir * closest_it);
                ray_state param_31 = state;
                vec3 param_32 = prev_state_origin;
                int param_33 = closest_fi;
                uint param_34 = closest_material_flags;
                vec2 param_35 = bc;
                bool param_36 = flip_normal_on_glass;
                evaluate_material(param_31, param_32, param_33, param_34, param_35, param_36);
                state = param_31;
                if (max_bounces > 1)
                {
                    vec3 ird = vec3(1.0) / state.dir;
                    ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
                    vec3 s_1 = step(vec3(0.0), state.dir);
                    vec3 sgn_1 = (s_1 * 2.0) - vec3(1.0);
                    deltaT = (sgn_1 * cellDimension) * ird;
                    nextCrossingT = vec3(tmin) + ((((floor(ro_cell / cellDimension) + s_1) * cellDimension) - ro_cell) * ird);
                    tmax = traversal_params.trace_range_secondary;
                    rt = tmin;
                }
            }
        }
        if ((inside == false) && (prev_inside == true))
        {
            state.running = false;
            state.left = true;
        }
        if (!hit)
        {
            vec3 mm_1 = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
            vec3 param_37 = state.dir;
            vec3 param_38 = mm_1;
            icell += dda_step_from_dir(param_37, param_38);
            nextCrossingT += (mm_1 * deltaT);
        }
    }
    return 0;
}

vec4 sample_env_map(vec3 r, float roughness)
{
    vec4 v = textureLod(s_reflection, r, 0.5 + (roughness * 15.0));
    return vec4(max(vec4(0.0), v));
}

void main()
{
    ivec2 scaled_sample_pos = ivec2(gl_FragCoord.xy) * ivec2(_2151.rt_setup.screen_sampling_scale);
    ivec2 native_sample_pos = ivec2(gl_FragCoord.xy);
    vec4 color = vec4(1.0);
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos;
    vec3 dir = -normalize(_3208.transform_params.vCameraPosition - worldPos);
    vec3 origin = _3208.transform_params.vCameraPosition;
    int closest_fi = -1;
    int16_t material = 0s;
    uvec2 param = imageLoad(imMetalnessRoughnessMaterialTags, scaled_sample_pos).xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    float metalness = param_1;
    float roughness = param_2;
    uint materialIndex = param_3;
    if (materialIndex == 1u)
    {
    }
    material = int16_t(uint16_t(materialIndex));
    vec3 view_direction;
    view_direction.x = ((-_2151.rt_setup.camera_projection_params.x) * 0.5) + ((_2151.rt_setup.camera_projection_params.x * float(scaled_sample_pos.x)) / 1920.0);
    view_direction.y = ((-_2151.rt_setup.camera_projection_params.y) * 0.5) + ((_2151.rt_setup.camera_projection_params.y * float(scaled_sample_pos.y)) / 1080.0);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float param_4 = texelFetch(sTextureDepth, native_sample_pos, 0).x;
    float depth = linearizeDepth(param_4);
    vec3 param_5 = view_direction;
    float param_6 = depth;
    vec3 view_coords = positionFromDepth(param_5, param_6);
    view_coords = (_2151.rt_setup.mat_model * vec4(view_coords, 1.0)).xyz;
    dir = -normalize(_3208.transform_params.vCameraPosition - view_coords);
    float closest_it = length(origin - view_coords);
    uint encoded_normal_material = imageLoad(imNormalMaterial, scaled_sample_pos).x;
    uint param_7 = encoded_normal_material;
    vec3 normal = vec3(normalize(decode_normal(param_7)));
    vec3 worldNorm = normal;
    outFresnelReflection = vec4(0.0);
    origin += (dir * closest_it);
    ray_traversal_params traversal_params;
    traversal_params.trace_range_primary = _2151.rt_setup.trace_range_primary;
    traversal_params.trace_range_secondary = _2151.rt_setup.trace_range_secondary;
    vec4 albedo_value = imageLoad(imAlbedo, scaled_sample_pos);
    ray_state state;
    state.color = vec3(1.0);
    float _3363;
    if (materials.material_properties[material].transparency == 0.0)
    {
        _3363 = 1.0;
    }
    else
    {
        _3363 = materials.material_properties[material].transparency;
    }
    state.transparency = _3363;
    state.transparency = 1.0 - ((1.0 - state.transparency) * albedo_value.w);
    state.normal = normal;
    state.material = material;
    state.running = true;
    state.dir = dir;
    state.origin = origin;
    state.bounces = 1s;
    state.hit = false;
    state.left = false;
    state.inside_transparent = false;
    state.tests = 0;
    state.face_tests = 0;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    state.final_color_factor = 1.0;
    bool pre_step_along_ray = false;
    bool pre_step_along_normal = !pre_step_along_ray;
    bool _3405 = materials.material_properties[material].roughness == 1.0;
    bool _3413;
    if (_3405)
    {
        _3413 = (materials.material_properties[material].flags & 32u) == 0u;
    }
    else
    {
        _3413 = _3405;
    }
    if (_3413)
    {
        dir = reflect(dir, vec3(normal));
        state.hit = true;
    }
    else
    {
        if ((materials.material_properties[material].flags & 32u) != 0u)
        {
            float fresnel = pow(1.0 - max(0.0, dot(vec3(worldNorm), normalize(_3208.transform_params.vCameraPosition - view_coords))), 4.0);
            float reflection = mix(1.0 - state.transparency, 1.0, fresnel);
            vec3 glass_reflection = vec3(0.0);
            if (reflection > 0.001000000047497451305389404296875)
            {
                if (pre_step_along_normal)
                {
                    state.origin += (vec3(normal) * _2151.rt_setup.initial_face_start_distance);
                }
                vec3 ref_dir = reflect(dir, vec3(normal));
                if (materials.material_properties[state.material].roughness > 0.0)
                {
                    ivec2 param_8 = ivec2(native_sample_pos);
                    vec3 param_9 = ref_dir;
                    vec3 param_10 = vec3(normal);
                    float param_11 = materials.material_properties[state.material].roughness;
                    float param_12;
                    vec3 _3509 = rt_randomize_dir_for_roughness(param_8, param_9, param_10, param_11, param_12);
                    state.final_color_factor = param_12;
                    ref_dir = _3509;
                }
                state.dir = ref_dir;
                if (pre_step_along_ray)
                {
                    state.origin += (state.dir * _2151.rt_setup.initial_face_start_distance);
                }
                ray_traversal_params param_13 = traversal_params;
                ray_state param_14 = state;
                int param_15 = closest_fi;
                int param_18 = 1;
                int param_16;
                float param_17;
                int _3537 = findClosestDDAMultibounce(param_13, param_14, param_15, param_16, param_17, param_18);
                state = param_14;
                int ref_closest_fi = param_16;
                float ref_closest_it = param_17;
                if (ref_closest_fi != (-1))
                {
                    glass_reflection = state.color;
                }
                else
                {
                    vec3 param_19 = normal;
                    float param_20 = materials.material_properties[state.material].roughness;
                    glass_reflection = sample_env_map(param_19, param_20).xyz;
                }
                reflection = (reflection - 0.001000000047497451305389404296875) / 0.999000012874603271484375;
            }
            outFresnelReflection = vec4(glass_reflection, reflection);
            return;
        }
        return;
    }
    vec3 _3806 = state.color * state.final_color_factor;
    color.x = _3806.x;
    color.y = _3806.y;
    color.z = _3806.z;
    if (state.hit)
    {
    }
}

 