#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct ModifierFactorWaveTransfer_Params
{
    int type;
    float frequency;
    float phase_shift;
    float amplitude;
    float base;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 6, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _1410;

layout(set = 0, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1423;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1435;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1458;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1483;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1491;

layout(set = 0, binding = 8, std140) uniform VM0
{
    InstanceModifierRandomizerV2_Params VM0_params;
} _1525;

layout(set = 0, binding = 9, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1551;

layout(set = 0, binding = 10, std140) uniform VM2
{
    InstanceModifierLookAt_Params VM2_params;
} _1566;

layout(set = 0, binding = 11, std140) uniform VM3
{
    ModifierFactorWaveTransfer_Params VM3_params;
} _1592;

layout(set = 0, binding = 12, std140) uniform VM4
{
    ModifierFactorCurveTransfer_Params VM4_params;
} _1605;

layout(set = 0, binding = 13, std140) uniform VM5
{
    InstanceModifierRandomizerV2_Params VM5_params;
} _1617;

layout(set = 0, binding = 14, std140) uniform VM6
{
    layout(row_major) ModifierFactorNoise_Params VM6_params;
} _1641;

layout(set = 0, binding = 15, std140) uniform VM7
{
    InstanceModifierRandomizerV2_Params VM7_params;
} _1654;

layout(set = 0, binding = 5, std430) buffer VM8
{
    InstanceModifierFactorToColor_Params VM8_params;
} _1671;

layout(set = 0, binding = 16) uniform sampler2D s_Curves;
layout(set = 0, binding = 17) uniform sampler2D s_Gradients;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _261 = hash(param);
    uint param_1 = v.z;
    uint _266 = hash(param_1);
    uint param_2 = (v.x ^ _261) ^ _266;
    uint _269 = hash(param_2);
    return _269;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _298 = floatConstruct(param_1);
    return _298;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _288 = hash(param);
    uint param_1 = _288;
    float _290 = floatConstruct(param_1);
    return _290;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    nnx *= length(nx);
    nny *= length(ny);
    nnz *= length(nz);
    vec3 _1177 = vec3(nnx.x, nny.x, nnz.x);
    instance.m0.x = _1177.x;
    instance.m0.y = _1177.y;
    instance.m0.z = _1177.z;
    vec3 _1190 = vec3(nnx.y, nny.y, nnz.y);
    instance.m1.x = _1190.x;
    instance.m1.y = _1190.y;
    instance.m1.z = _1190.z;
    vec3 _1203 = vec3(nnx.z, nny.z, nnz.z);
    instance.m2.x = _1203.x;
    instance.m2.y = _1203.y;
    instance.m2.z = _1203.z;
}

void modifier_factor_wave_transfer(ModifierFactorWaveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.frequency) + modifier_params.phase_shift;
    if (modifier_params.type == 0)
    {
        v = sin(v);
    }
    else
    {
        if (modifier_params.type == 1)
        {
            float phase = mod(v, 1.0) - 0.5;
            v = abs(2.0 * (phase - floor(phase + 0.5)));
        }
        else
        {
            if (modifier_params.type == 2)
            {
                float phase_1 = mod(v, 1.0) - 0.5;
                v = sign(phase_1);
            }
        }
    }
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _1370 = instance.c;
        vec3 _1376 = mix(_1370.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _1376.x;
        instance.c.y = _1376.y;
        instance.c.z = _1376.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _1390 = instance.c;
        vec3 _1392 = _1390.xyz + c;
        instance.c.x = _1392.x;
        instance.c.y = _1392.y;
        instance.c.z = _1392.z;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_1410.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_1423.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _1435.instance_transform[(id * 3u) + 0u];
    instance.m1 = _1435.instance_transform[(id * 3u) + 1u];
    instance.m2 = _1435.instance_transform[(id * 3u) + 2u];
    vec2 _1465 = unpackHalf2x16(_1458.instance_color[(id * 2u) + 0u]);
    instance.c.x = _1465.x;
    instance.c.y = _1465.y;
    vec2 _1475 = unpackHalf2x16(_1458.instance_color[(id * 2u) + 1u]);
    instance.c.z = _1475.x;
    instance.c.w = _1475.y;
    instance.flipbook_card = _1483.instance_flipbook_card[id];
    instance.hash = _1491.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    InstanceModifierRandomizerV2_Params _1530;
    _1530.replace_previous_rotation_scale = _1525.VM0_params.replace_previous_rotation_scale;
    _1530.randomness_seed = _1525.VM0_params.randomness_seed;
    _1530.replace_previous_position = _1525.VM0_params.replace_previous_position;
    _1530.randomization_input = _1525.VM0_params.randomization_input;
    _1530.position_modifier_base = _1525.VM0_params.position_modifier_base;
    _1530.position_modifier_base_modifier_factor = _1525.VM0_params.position_modifier_base_modifier_factor;
    _1530.position_modifier_range = _1525.VM0_params.position_modifier_range;
    _1530.position_modifier_range_modifier_factor = _1525.VM0_params.position_modifier_range_modifier_factor;
    _1530.rotation_modifier_base = _1525.VM0_params.rotation_modifier_base;
    _1530.rotation_modifier_base_modifier_factor = _1525.VM0_params.rotation_modifier_base_modifier_factor;
    _1530.rotation_modifier_range = _1525.VM0_params.rotation_modifier_range;
    _1530.rotation_modifier_range_modifier_factor = _1525.VM0_params.rotation_modifier_range_modifier_factor;
    _1530.scale_modifier_base = _1525.VM0_params.scale_modifier_base;
    _1530.scale_modifier_base_modifier_factor = _1525.VM0_params.scale_modifier_base_modifier_factor;
    _1530.scale_modifier_range = _1525.VM0_params.scale_modifier_range;
    _1530.scale_modifier_range_modifier_factor = _1525.VM0_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param = _1530;
    ModifierFactor param_1 = modifier_factor;
    Instance param_2 = instance;
    uint param_3 = id;
    instance_modifier_randomizer_v2(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    instance = param_2;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorNoise_Params _1556;
    _1556.transform_local_to_gizmo = _1551.VM1_params.transform_local_to_gizmo;
    _1556.noise_domain_scale = _1551.VM1_params.noise_domain_scale;
    _1556.modifier_function = _1551.VM1_params.modifier_function;
    _1556.noise_domain_offset = _1551.VM1_params.noise_domain_offset;
    _1556.noise_value_scale = _1551.VM1_params.noise_value_scale;
    _1556.noise_value_offset = _1551.VM1_params.noise_value_offset;
    _1556.influence_scope = _1551.VM1_params.influence_scope;
    _1556._pad0 = _1551.VM1_params._pad0;
    _1556._pad1 = _1551.VM1_params._pad1;
    ModifierFactorNoise_Params param_4 = _1556;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_noise(param_4, param_5, param_6);
    modifier_factor = param_5;
    InstanceModifierLookAt_Params _1571;
    _1571.ref_position = _1566.VM2_params.ref_position;
    _1571.look_away = _1566.VM2_params.look_away;
    _1571.axis = _1566.VM2_params.axis;
    InstanceModifierLookAt_Params param_7 = _1571;
    ModifierFactor param_8 = modifier_factor;
    Instance param_9 = instance;
    uint param_10 = id;
    instance_modifier_look_at(param_7, param_8, param_9, param_10);
    modifier_factor = param_8;
    instance = param_9;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorWaveTransfer_Params _1597;
    _1597.type = _1592.VM3_params.type;
    _1597.frequency = _1592.VM3_params.frequency;
    _1597.phase_shift = _1592.VM3_params.phase_shift;
    _1597.amplitude = _1592.VM3_params.amplitude;
    _1597.base = _1592.VM3_params.base;
    ModifierFactorWaveTransfer_Params param_11 = _1597;
    ModifierFactor param_12 = modifier_factor;
    modifier_factor_wave_transfer(param_11, param_12);
    modifier_factor = param_12;
    ModifierFactorCurveTransfer_Params _1610;
    _1610.curve_idx = _1605.VM4_params.curve_idx;
    _1610.input_range_min = _1605.VM4_params.input_range_min;
    _1610.input_range_max = _1605.VM4_params.input_range_max;
    _1610.amplitude = _1605.VM4_params.amplitude;
    _1610.base = _1605.VM4_params.base;
    ModifierFactorCurveTransfer_Params param_13 = _1610;
    ModifierFactor param_14 = modifier_factor;
    modifier_factor_curve_transfer(param_13, param_14);
    modifier_factor = param_14;
    InstanceModifierRandomizerV2_Params _1621;
    _1621.replace_previous_rotation_scale = _1617.VM5_params.replace_previous_rotation_scale;
    _1621.randomness_seed = _1617.VM5_params.randomness_seed;
    _1621.replace_previous_position = _1617.VM5_params.replace_previous_position;
    _1621.randomization_input = _1617.VM5_params.randomization_input;
    _1621.position_modifier_base = _1617.VM5_params.position_modifier_base;
    _1621.position_modifier_base_modifier_factor = _1617.VM5_params.position_modifier_base_modifier_factor;
    _1621.position_modifier_range = _1617.VM5_params.position_modifier_range;
    _1621.position_modifier_range_modifier_factor = _1617.VM5_params.position_modifier_range_modifier_factor;
    _1621.rotation_modifier_base = _1617.VM5_params.rotation_modifier_base;
    _1621.rotation_modifier_base_modifier_factor = _1617.VM5_params.rotation_modifier_base_modifier_factor;
    _1621.rotation_modifier_range = _1617.VM5_params.rotation_modifier_range;
    _1621.rotation_modifier_range_modifier_factor = _1617.VM5_params.rotation_modifier_range_modifier_factor;
    _1621.scale_modifier_base = _1617.VM5_params.scale_modifier_base;
    _1621.scale_modifier_base_modifier_factor = _1617.VM5_params.scale_modifier_base_modifier_factor;
    _1621.scale_modifier_range = _1617.VM5_params.scale_modifier_range;
    _1621.scale_modifier_range_modifier_factor = _1617.VM5_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_15 = _1621;
    ModifierFactor param_16 = modifier_factor;
    Instance param_17 = instance;
    uint param_18 = id;
    instance_modifier_randomizer_v2(param_15, param_16, param_17, param_18);
    modifier_factor = param_16;
    instance = param_17;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorNoise_Params _1645;
    _1645.transform_local_to_gizmo = _1641.VM6_params.transform_local_to_gizmo;
    _1645.noise_domain_scale = _1641.VM6_params.noise_domain_scale;
    _1645.modifier_function = _1641.VM6_params.modifier_function;
    _1645.noise_domain_offset = _1641.VM6_params.noise_domain_offset;
    _1645.noise_value_scale = _1641.VM6_params.noise_value_scale;
    _1645.noise_value_offset = _1641.VM6_params.noise_value_offset;
    _1645.influence_scope = _1641.VM6_params.influence_scope;
    _1645._pad0 = _1641.VM6_params._pad0;
    _1645._pad1 = _1641.VM6_params._pad1;
    ModifierFactorNoise_Params param_19 = _1645;
    ModifierFactor param_20 = modifier_factor;
    CoordinateSystemTrasforms param_21 = cs_transforms;
    modifier_factor_noise(param_19, param_20, param_21);
    modifier_factor = param_20;
    InstanceModifierRandomizerV2_Params _1658;
    _1658.replace_previous_rotation_scale = _1654.VM7_params.replace_previous_rotation_scale;
    _1658.randomness_seed = _1654.VM7_params.randomness_seed;
    _1658.replace_previous_position = _1654.VM7_params.replace_previous_position;
    _1658.randomization_input = _1654.VM7_params.randomization_input;
    _1658.position_modifier_base = _1654.VM7_params.position_modifier_base;
    _1658.position_modifier_base_modifier_factor = _1654.VM7_params.position_modifier_base_modifier_factor;
    _1658.position_modifier_range = _1654.VM7_params.position_modifier_range;
    _1658.position_modifier_range_modifier_factor = _1654.VM7_params.position_modifier_range_modifier_factor;
    _1658.rotation_modifier_base = _1654.VM7_params.rotation_modifier_base;
    _1658.rotation_modifier_base_modifier_factor = _1654.VM7_params.rotation_modifier_base_modifier_factor;
    _1658.rotation_modifier_range = _1654.VM7_params.rotation_modifier_range;
    _1658.rotation_modifier_range_modifier_factor = _1654.VM7_params.rotation_modifier_range_modifier_factor;
    _1658.scale_modifier_base = _1654.VM7_params.scale_modifier_base;
    _1658.scale_modifier_base_modifier_factor = _1654.VM7_params.scale_modifier_base_modifier_factor;
    _1658.scale_modifier_range = _1654.VM7_params.scale_modifier_range;
    _1658.scale_modifier_range_modifier_factor = _1654.VM7_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_22 = _1658;
    ModifierFactor param_23 = modifier_factor;
    Instance param_24 = instance;
    uint param_25 = id;
    instance_modifier_randomizer_v2(param_22, param_23, param_24, param_25);
    modifier_factor = param_23;
    instance = param_24;
    InstanceModifierFactorToColor_Params _1676;
    _1676.color = _1671.VM8_params.color;
    _1676.use_gradient = _1671.VM8_params.use_gradient;
    _1676.color_gradient_idx = _1671.VM8_params.color_gradient_idx;
    _1676.mixing_mode = _1671.VM8_params.mixing_mode;
    InstanceModifierFactorToColor_Params param_26 = _1676;
    ModifierFactor param_27 = modifier_factor;
    Instance param_28 = instance;
    instance_modifier_factor_to_color(param_26, param_27, param_28);
    modifier_factor = param_27;
    instance = param_28;
    _1435.instance_transform[(id * 3u) + 0u] = instance.m0;
    _1435.instance_transform[(id * 3u) + 1u] = instance.m1;
    _1435.instance_transform[(id * 3u) + 2u] = instance.m2;
    _1458.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1458.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1483.instance_flipbook_card[id] = instance.flipbook_card;
}

 