#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _951
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1073;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1087;

layout(set = 1, binding = 4, std140) uniform VM3
{
    ModifierFactorQuantizePosition_Params VM3_params;
} _1120;

layout(set = 1, binding = 5, std140) uniform VM4
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM4_params;
} _1135;

layout(set = 1, binding = 6, std140) uniform VM5
{
    ModifierFactorMulAdd_Params VM5_params;
} _1150;

layout(set = 1, binding = 7, std140) uniform VM6
{
    layout(row_major) ModifierFactorNoise_Params VM6_params;
} _1163;

layout(set = 1, binding = 8) uniform sampler2D s_Curves;
layout(set = 1, binding = 9) uniform sampler2D material_textures[64];

layout(location = 1) in _951 vtx_input;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _927 = material.albedo_sampler >= 0;
    bool _934;
    if (_927)
    {
        _934 = material.albedo_sampler < 16;
    }
    else
    {
        _934 = _927;
    }
    if (_934)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _977 = material.emissive_sampler >= 0;
    bool _983;
    if (_977)
    {
        _983 = material.emissive_sampler < 16;
    }
    else
    {
        _983 = _977;
    }
    if (_983)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
    bool _1018 = material.metalic_roughness_sampler >= 0;
    bool _1024;
    if (_1018)
    {
        _1024 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _1024 = _1018;
    }
    if (_1024)
    {
        vec2 metalic_roughness = vec2(1.0);
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_6 = vtx_input.vLocalPos;
            vec3 param_7 = norm;
            vec3 param_8 = material.triplanar_factor;
            metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_6, param_7, param_8).xy;
        }
        else
        {
            metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).xy;
        }
        material_eval.metalness_texture = clamp(metalic_roughness.x, 0.0, 1.0);
        material_eval.roughness_texture = clamp(metalic_roughness.y, 0.0, 1.0);
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    float factor = eval_input.modifier_factor;
    eval.is_discarded = factor > 0.5;
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
}

void main()
{
    MaterialPropertiesGPU _1080;
    _1080.diffuse = materials.material_properties[_1073.materialIndex].diffuse;
    _1080.transparency = materials.material_properties[_1073.materialIndex].transparency;
    _1080.emissive = materials.material_properties[_1073.materialIndex].emissive;
    _1080.roughness = materials.material_properties[_1073.materialIndex].roughness;
    _1080.triplanar_factor = materials.material_properties[_1073.materialIndex].triplanar_factor;
    _1080.refraction = materials.material_properties[_1073.materialIndex].refraction;
    _1080.normal_factor = materials.material_properties[_1073.materialIndex].normal_factor;
    _1080.emissive_factor = materials.material_properties[_1073.materialIndex].emissive_factor;
    _1080.temporal_accumulation_factor = materials.material_properties[_1073.materialIndex].temporal_accumulation_factor;
    _1080.shadowmap_bias = materials.material_properties[_1073.materialIndex].shadowmap_bias;
    _1080.metalness = materials.material_properties[_1073.materialIndex].metalness;
    _1080.albedo_sampler = materials.material_properties[_1073.materialIndex].albedo_sampler;
    _1080.emissive_sampler = materials.material_properties[_1073.materialIndex].emissive_sampler;
    _1080.normal_sampler = materials.material_properties[_1073.materialIndex].normal_sampler;
    _1080.metalic_roughness_sampler = materials.material_properties[_1073.materialIndex].metalic_roughness_sampler;
    _1080.flags = materials.material_properties[_1073.materialIndex].flags;
    _1080._pad0 = materials.material_properties[_1073.materialIndex]._pad0;
    _1080._pad1 = materials.material_properties[_1073.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1080;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _1087.transform_params.vCameraPosition;
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1087.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1087.transform_params.mModelInv;
    ModifierFactorQuantizePosition_Params _1125;
    _1125.quantization_step = _1120.VM3_params.quantization_step;
    _1125._pad0 = _1120.VM3_params._pad0;
    _1125.offset = _1120.VM3_params.offset;
    _1125.quantize_x = _1120.VM3_params.quantize_x;
    _1125.quantize_y = _1120.VM3_params.quantize_y;
    _1125.quantize_z = _1120.VM3_params.quantize_z;
    ModifierFactorQuantizePosition_Params param = _1125;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_quantize_position(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorDistanceRadial_Params _1140;
    _1140.transform_local_to_gizmo = _1135.VM4_params.transform_local_to_gizmo;
    _1140.falloff_curve_idx = _1135.VM4_params.falloff_curve_idx;
    _1140.falloff_inverse = _1135.VM4_params.falloff_inverse;
    _1140.domain_repeat_x = _1135.VM4_params.domain_repeat_x;
    _1140.domain_repeat_y = _1135.VM4_params.domain_repeat_y;
    _1140.domain_repeat_z = _1135.VM4_params.domain_repeat_z;
    _1140.influence_scope = _1135.VM4_params.influence_scope;
    _1140.modifier_function = _1135.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_3 = _1140;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_distance_radial(param_3, param_4, param_5);
    modifier_factor = param_4;
    ModifierFactorMulAdd_Params _1155;
    _1155.multiply_value = _1150.VM5_params.multiply_value;
    _1155.add_value = _1150.VM5_params.add_value;
    ModifierFactorMulAdd_Params param_6 = _1155;
    ModifierFactor param_7 = modifier_factor;
    modifier_factor_mul_add(param_6, param_7);
    modifier_factor = param_7;
    ModifierFactorNoise_Params _1168;
    _1168.transform_local_to_gizmo = _1163.VM6_params.transform_local_to_gizmo;
    _1168.noise_domain_scale = _1163.VM6_params.noise_domain_scale;
    _1168.modifier_function = _1163.VM6_params.modifier_function;
    _1168.noise_domain_offset = _1163.VM6_params.noise_domain_offset;
    _1168.noise_value_scale = _1163.VM6_params.noise_value_scale;
    _1168.noise_value_offset = _1163.VM6_params.noise_value_offset;
    _1168.influence_scope = _1163.VM6_params.influence_scope;
    _1168._pad0 = _1163.VM6_params._pad0;
    _1168._pad1 = _1163.VM6_params._pad1;
    ModifierFactorNoise_Params param_8 = _1168;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_noise(param_8, param_9, param_10);
    modifier_factor = param_9;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _1073.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = 0.0;
    material_eval.metalness = 0.0;
    material_eval.is_discarded = false;
    material_eval.normal = vec3(0.0);
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    MaterialEvalInput eval_input;
    eval_input.uv0 = vtx_input.vUV0;
    eval_input.normal = vtx_input.vNorm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_11 = material;
    MaterialEval param_12 = material_eval;
    MaterialEvalInput param_13 = eval_input;
    material_evaluate(param_11, param_12, param_13);
    material_eval = param_12;
    eval_input = param_13;
    if (material_eval.is_discarded)
    {
        discard;
    }
}

 