#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _928
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _582;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _593;

layout(set = 0, binding = 10, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _605;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _692;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _884;

layout(set = 0, binding = 11, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _902;

layout(set = 0, binding = 12, std140) uniform VM0
{
    VertexModifierColorizeParams VM0_params;
} _915;

layout(set = 0, binding = 8, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1019;

layout(set = 0, binding = 13) uniform sampler2D s_Gradients;

layout(location = 1) out _928 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        c *= modifier_factor.factor;
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _335 = vtx.color;
    vec3 _341 = mix(_335.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _341.x;
    vtx.color.y = _341.y;
    vtx.color.z = _341.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    m[2].x = 0.0;
    m[2].y = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_582.instance_params.stride > 0)
    {
        uint flipbook_card = _593.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_605.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_605.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_605.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_605.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_605.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_582.instance_params.stride > 0)
    {
        vec4 inst_m0 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 0];
        vec4 inst_m1 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 1];
        vec4 inst_m2 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 2];
        vec3 _723 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _723.x;
        mat_instance_model[0].y = _723.y;
        mat_instance_model[0].z = _723.z;
        vec3 _736 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _736.x;
        mat_instance_model[1].y = _736.y;
        mat_instance_model[1].z = _736.z;
        vec3 _749 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _749.x;
        mat_instance_model[2].y = _749.y;
        mat_instance_model[2].z = _749.z;
        vec3 _762 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _762.x;
        mat_instance_model[3].y = _762.y;
        mat_instance_model[3].z = _762.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_582.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _884.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _902.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _902.transform_params.mModelInv;
    VertexModifierColorizeParams _920;
    _920.color = _915.VM0_params.color;
    _920.alpha = _915.VM0_params.alpha;
    _920.use_gradient = _915.VM0_params.use_gradient;
    _920.color_blend = _915.VM0_params.color_blend;
    _920.alpha_blend = _915.VM0_params.alpha_blend;
    _920.color_gradient_idx = _915.VM0_params.color_gradient_idx;
    _920.mixing_mode = _915.VM0_params.mixing_mode;
    VertexModifierColorizeParams param_5 = _920;
    ModifierFactor param_6 = modifier_factor;
    VertexInput param_7 = vtx_input;
    vertex_modifier_colorize_apply(param_5, param_6, param_7);
    modifier_factor = param_6;
    vtx_input = param_7;
    vtx_output.vLocalPos = vtx_input.pos;
    if (_582.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 0];
        vec4 inst_m1_1 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 1];
        vec4 inst_m2_1 = _692.instance_transform[(gl_InstanceIndex * _582.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_8 = vtx_input.norm;
        mat4 param_9 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_8, param_9));
        vec2 _1025 = unpackHalf2x16(_1019.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1025.x;
        inst_c.y = _1025.y;
        vec2 _1035 = unpackHalf2x16(_1019.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1035.x;
        inst_c.w = _1035.y;
        vec4 _1041 = vtx_input.color;
        vec3 _1045 = _1041.xyz * inst_c.xyz;
        vtx_input.color.x = _1045.x;
        vtx_input.color.y = _1045.y;
        vtx_input.color.z = _1045.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vec3 param_10 = vtx_input.pos;
    mat4 param_11 = _902.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_10, param_11);
    vec3 param_12 = vtx_input.norm;
    mat4 param_13 = _902.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_12, param_13);
    vec3 param_14 = vPosModel;
    mat4 param_15 = _902.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_14, param_15);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _902.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_902.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_902.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_902.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    vec3 param_16 = vtx_output.vCoords;
    mat4 param_17 = _902.transform_params.mProjection;
    vec4 _1147 = vector_transform_by_mat_projection(param_16, param_17);
    gl_Position = _1147;
}

 