#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct Cone
{
    float cosa;
    float h;
    vec3 c;
    vec3 v;
};

struct Ray
{
    vec3 o;
    vec3 d;
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct IBLOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct BasicDeferredParams
{
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    int width;
    int height;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    float taa_blend;
    float taa_gamma;
    uint transparency_blend;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _674;

layout(set = 1, binding = 2, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _1067;

layout(set = 1, binding = 3, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _2708;

layout(set = 1, binding = 4, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 5, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _3594;

layout(set = 1, binding = 7) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 8) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 24) uniform sampler2D s_LTC2;
layout(set = 1, binding = 25) uniform sampler2D s_BRDF;
layout(set = 1, binding = 26) uniform samplerCube sEnviromentMap;
layout(set = 1, binding = 27) uniform sampler2D sAlbedo;
layout(set = 1, binding = 28) uniform usampler2D sNormalMaterial;
layout(set = 1, binding = 29) uniform sampler2D sDepth;
layout(set = 1, binding = 30) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 31) uniform sampler2D sEmissive;
layout(set = 1, binding = 32) uniform sampler2D LightShadowmapSamplers[16];
layout(set = 1, binding = 48) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 64) uniform sampler2D s_LTC1;
layout(set = 1, binding = 65) uniform sampler2D sRaytrace;
layout(set = 1, binding = 66) uniform sampler2D sVoxelOcclusion;
layout(set = 1, binding = 67) uniform usampler2D sRaytraceHitInfo;
layout(set = 1, binding = 68) uniform sampler2D sScreenSpaceOcclusion;

layout(location = 1) in vec4 vFrustum;
layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;
bool twoSided;
bool clipless;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _1067.basic_params.camera_near_far_plane.z / ((_1067.basic_params.camera_near_far_plane.y + _1067.basic_params.camera_near_far_plane.x) - (d * _1067.basic_params.camera_near_far_plane.w));
}

vec3 positionFromDepth(vec4 vDirection, float depth)
{
    return _1067.basic_params.camera_position + (vDirection.xyz * depth);
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

bool inside_light_cone(vec3 p0, vec3 p, float angle, float height)
{
    float hsquared = height * height;
    float cosangle = angle;
    float cDistance = dot(p, p);
    bool _1309 = cDistance <= hsquared;
    bool _1320;
    if (_1309)
    {
        _1320 = dot(p0, p) >= (sqrt(cDistance) * cosangle);
    }
    else
    {
        _1320 = _1309;
    }
    return _1320;
}

bool intersect_cone(Cone s, Ray r, out float v)
{
    v = 0.0;
    vec3 param = s.v;
    vec3 param_1 = r.o - s.c;
    float param_2 = s.cosa;
    float param_3 = s.h;
    if (inside_light_cone(param, param_1, param_2, param_3))
    {
        return true;
    }
    vec3 co = r.o - s.c;
    float a = (dot(r.d, s.v) * dot(r.d, s.v)) - (s.cosa * s.cosa);
    float b = 2.0 * ((dot(r.d, s.v) * dot(co, s.v)) - ((dot(r.d, co) * s.cosa) * s.cosa));
    float c = (dot(co, s.v) * dot(co, s.v)) - ((dot(co, co) * s.cosa) * s.cosa);
    float det = (b * b) - ((4.0 * a) * c);
    if (det < 0.0)
    {
        return false;
    }
    det = sqrt(det);
    float t1 = ((-b) - det) / (2.0 * a);
    float t2 = ((-b) + det) / (2.0 * a);
    float t = t1;
    bool _1446 = t < 0.0;
    bool _1456;
    if (!_1446)
    {
        _1456 = (t2 > 0.0) && (t2 < t);
    }
    else
    {
        _1456 = _1446;
    }
    if (_1456)
    {
        t = t2;
    }
    if (t < 0.0)
    {
        return false;
    }
    vec3 cp = (r.o + (r.d * t)) - s.c;
    float h = dot(cp, s.v);
    if (h < 0.0)
    {
        cp = (r.o + (r.d * max(t1, t2))) - s.c;
        h = dot(cp, s.v);
        if (h < 0.0)
        {
            return false;
        }
    }
    if (h < s.h)
    {
        return true;
    }
    cp = (r.o + (r.d * max(t1, t2))) - s.c;
    h = dot(cp, s.v);
    bool _1530 = h > 0.0;
    bool _1537;
    if (_1530)
    {
        _1537 = h < s.h;
    }
    else
    {
        _1537 = _1530;
    }
    if (_1537)
    {
        return true;
    }
    return false;
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1012 = angularInfo.NdotL > 0.0;
    bool _1019;
    if (!_1012)
    {
        _1019 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1019 = _1012;
    }
    if (_1019)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

float AvgBlockersDepthToPenumbra(float light_size, float z_shadowMapView, float avgBlockersDepth)
{
    float penumbra = (light_size * (z_shadowMapView - avgBlockersDepth)) / avgBlockersDepth;
    return penumbra;
}

float PenumbraFromOccluderSearch(sampler2D smpl, float light_size, vec2 hash, vec4 coords, float sampling_range, int samplesCount, float shadowmap_bias)
{
    float avgBlockersDepth = 0.0;
    float blockersCount = 0.0;
    float penumbraFilterMaxSize = sampling_range;
    bool _418 = coords.x < (-coords.w);
    bool _427;
    if (!_418)
    {
        _427 = coords.x > coords.w;
    }
    else
    {
        _427 = _418;
    }
    bool _437;
    if (!_427)
    {
        _437 = coords.y < (-coords.w);
    }
    else
    {
        _437 = _427;
    }
    bool _446;
    if (!_437)
    {
        _446 = coords.y > coords.w;
    }
    else
    {
        _446 = _437;
    }
    bool _453;
    if (!_446)
    {
        _453 = coords.z < 0.0;
    }
    else
    {
        _453 = _446;
    }
    if (_453)
    {
        return 1.0;
    }
    vec2 shadowMapUV = ((coords.xy / vec2(coords.w)) * 0.5) + vec2(0.5);
    shadowMapUV.y = 1.0 - shadowMapUV.y;
    float z_shadowMapView = coords.z / coords.w;
    for (int i = 0; i < samplesCount; i++)
    {
        vec2 sampleUV = fract(hash + vec2(float(i) * 1.61803400516510009765625)) - vec2(0.5);
        sampleUV = shadowMapUV + (sampleUV * penumbraFilterMaxSize);
        vec4 sampleDepth = textureGather(smpl, sampleUV);
        if (sampleDepth.x < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.x;
            blockersCount += 1.0;
        }
        if (sampleDepth.y < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.y;
            blockersCount += 1.0;
        }
        if (sampleDepth.z < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.z;
            blockersCount += 1.0;
        }
        if (sampleDepth.w < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.w;
            blockersCount += 1.0;
        }
    }
    if (blockersCount > 0.0)
    {
        avgBlockersDepth /= blockersCount;
        float param = light_size;
        float param_1 = z_shadowMapView;
        float param_2 = avgBlockersDepth;
        return AvgBlockersDepthToPenumbra(param, param_1, param_2);
    }
    else
    {
        return 0.0;
    }
}

float sampleShadowPCFNoiseOffset(sampler2DShadow smpl, inout vec4 coords, ivec2 noise_offset, out float in_frustum, int samples, float sampling_range, float shadowmap_bias)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _587 = coords.x < (-coords.w);
    bool _596;
    if (!_587)
    {
        _596 = coords.x > coords.w;
    }
    else
    {
        _596 = _587;
    }
    bool _606;
    if (!_596)
    {
        _606 = coords.y < (-coords.w);
    }
    else
    {
        _606 = _596;
    }
    bool _615;
    if (!_606)
    {
        _615 = coords.y > coords.w;
    }
    else
    {
        _615 = _606;
    }
    bool _622;
    if (!_615)
    {
        _622 = coords.z < 0.0;
    }
    else
    {
        _622 = _615;
    }
    if (_622)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _626 = coords;
    float _631 = coords.w;
    vec2 _633 = (_626.xy * vec2(0.5)) + (vec2(0.5) * _631);
    coords.x = _633.x;
    coords.y = _633.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    float bias = shadowmap_bias;
    float bias2 = 0.300000011920928955078125;
    int taken_samples = 0;
    int h_samples = samples;
    vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_offset & ivec2(127), _674.globals.monotonic & 15), 0).xyz;
    for (int n = 0; n < h_samples; n++)
    {
        vec2 xy = fract(hash.xy + vec2(float(n) * 1.61803400516510009765625)) - vec2(0.5);
        vec4 jittered_coords = coords + vec4((xy.x * sampling_range) * coords.w, (xy.y * sampling_range) * coords.w, bias, 0.0);
        vec4 _727 = jittered_coords;
        vec4 _730 = _727;
        _730.z = _727.w;
        float shadow = textureProjLod(smpl, vec4(_730.xy, _727.z, _730.z), 0.0);
        fact += shadow;
        taken_samples++;
    }
    return fact * (1.0 / float(h_samples));
}

vec4 sampleProjectorTexture(sampler2D smpl, inout vec4 coords)
{
    vec4 color = vec4(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _1179 = coords.x < (-coords.w);
    bool _1188;
    if (!_1179)
    {
        _1188 = coords.x > coords.w;
    }
    else
    {
        _1188 = _1179;
    }
    bool _1198;
    if (!_1188)
    {
        _1198 = coords.y < (-coords.w);
    }
    else
    {
        _1198 = _1188;
    }
    bool _1207;
    if (!_1198)
    {
        _1207 = coords.y > coords.w;
    }
    else
    {
        _1207 = _1198;
    }
    if (_1207)
    {
        return color;
    }
    vec4 _1212 = coords;
    float _1216 = coords.w;
    vec2 _1218 = (_1212.xy * vec2(0.5)) + (vec2(0.5) * _1216);
    coords.x = _1218.x;
    coords.y = _1218.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w));
    return color;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _773 = falloff > cutoff;
    bool _780;
    if (_773)
    {
        _780 = light_distance < light.range;
    }
    else
    {
        _780 = _773;
    }
    if (_780)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

float light_calculate_point_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position.xyz - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0;
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right.xyz;
    rect.diry = light.up.xyz;
    rect.center = light.position.xyz;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1788;
    if (x > 0.0)
    {
        _1788 = v;
    }
    else
    {
        _1788 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1788;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate(vec3 N, vec3 V, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = texture(s_LTC2, uv).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _2550;
        if (twoSided_1)
        {
            _2550 = abs(sum);
        }
        else
        {
            _2550 = max(0.0, sum);
        }
        sum = _2550;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position.xyz - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

float vol_rand(vec2 n)
{
    return fract(sin(dot(n, vec2(12.98980045318603515625, 4.141399860382080078125))) * 43758.546875);
}

float vol_noise(vec2 n)
{
    vec2 b = floor(n);
    vec2 f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
    vec2 param = b;
    vec2 param_1 = b + vec2(1.0, 0.0);
    vec2 param_2 = b + vec2(0.0, 1.0);
    vec2 param_3 = b + vec2(1.0);
    return mix(mix(vol_rand(param), vol_rand(param_1), f.x), mix(vol_rand(param_2), vol_rand(param_3), f.x), f.y);
}

float sampleShadowDist(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, inout vec4 projector_color, inout float shadow_dist)
{
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 0.0;
    }
    bool _1105 = coords.x < (-coords.w);
    bool _1114;
    if (!_1105)
    {
        _1114 = coords.x > coords.w;
    }
    else
    {
        _1114 = _1105;
    }
    bool _1124;
    if (!_1114)
    {
        _1124 = coords.y < (-coords.w);
    }
    else
    {
        _1124 = _1114;
    }
    bool _1133;
    if (!_1124)
    {
        _1133 = coords.y > coords.w;
    }
    else
    {
        _1133 = _1124;
    }
    if (_1133)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _1137 = coords;
    float _1141 = coords.w;
    vec2 _1143 = (_1137.xy * vec2(0.5)) + (vec2(0.5) * _1141);
    coords.x = _1143.x;
    coords.y = _1143.y;
    vec3 samp = coords.xyz / vec3(coords.w);
    vec4 _1157 = coords;
    vec4 _1160 = _1157;
    _1160.z = _1157.w;
    float shadow = textureProj(smpl, vec4(_1160.xy, _1157.z, _1160.z));
    projector_color = vec4(0.0);
    shadow_dist = 0.0;
    return shadow;
}

float calculate_shadow_dist_for_position(LightProperties light, vec3 world, float depth, out vec4 cascadeColor, inout vec4 projector_color, out float shadow_dist)
{
    vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
    cascadeColor = vec4(1.0, 0.100000001490116119384765625, 0.100000001490116119384765625, 1.0);
    vec4 param = vShadowCoords;
    float param_1;
    vec4 param_2;
    float param_3;
    float _1284 = sampleShadowDist(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param, param_1, param_2, param_3);
    float in_frustum = param_1;
    projector_color = param_2;
    shadow_dist = param_3;
    float shadow = _1284;
    shadow *= in_frustum;
    projector_color *= in_frustum;
    return shadow;
}

float volumetric_sample_shadow_spot(LightProperties light, vec4 frustum, float max_depth, inout float attenuation, inout vec4 projector_color)
{
    float fact = 0.0;
    float depth_dir = 0.100000001490116119384765625;
    float depth_pos = 0.0;
    attenuation = 0.0;
    vec2 param = gl_FragCoord.xy + vec2(_674.globals.global_time);
    depth_pos += ((depth_dir * vol_noise(param)) * 2.5);
    int i = 0;
    vec4 param_6;
    vec4 param_7;
    float param_8;
    for (; i < 256; i++)
    {
        vec4 param_1 = frustum;
        float param_2 = depth_pos;
        vec3 ray_world = positionFromDepth(param_1, param_2);
        float lf = 0.0;
        float falloff = dot(light.direction.xyz, normalize(ray_world - light.position.xyz));
        if (falloff > light.cutoff)
        {
            float sample_attenuation = 1.0 - ((1.0 - falloff) / (1.0 - light.cutoff));
            sample_attenuation *= (1.0 - clamp(length(light.position.xyz - ray_world) / light.range, 0.0, 1.0));
            sample_attenuation = pow(sample_attenuation, 3.0);
            LightProperties param_3 = light;
            vec3 param_4 = ray_world;
            float param_5 = depth_pos;
            float _1681 = calculate_shadow_dist_for_position(param_3, param_4, param_5, param_6, param_7, param_8);
            vec4 cascade_color = param_6;
            vec4 projector = param_7;
            float shadow_dist = param_8;
            float shadow_value = _1681;
            lf = sample_attenuation * shadow_value;
            attenuation += sample_attenuation;
            vec4 _1698 = projector_color;
            vec3 _1700 = _1698.xyz + ((projector.xyz * (1.0 - shadow_value)) * sample_attenuation);
            projector_color.x = _1700.x;
            projector_color.y = _1700.y;
            projector_color.z = _1700.z;
        }
        fact += lf;
        depth_dir *= 1.0099999904632568359375;
        depth_pos += depth_dir;
        if (depth_pos > max_depth)
        {
            break;
        }
    }
    vec4 _1727 = projector_color;
    vec3 _1730 = _1727.xyz / vec3(float(i + 1));
    projector_color.x = _1730.x;
    projector_color.y = _1730.y;
    projector_color.z = _1730.z;
    return (attenuation - fact) / float(i + 1);
}

IBLOutput ibl(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    float mip_count = 7.5;
    float lod = clamp(perceptual_roughness * mip_count, 0.0, mip_count);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = texture(s_BRDF, brdf_sample_point).xy;
    vec3 diffuseLight = textureLod(sEnviromentMap, n, 5.0).xyz;
    vec3 specularLight = textureLod(sEnviromentMap, r, lod).xyz * (brdf.x + brdf.y);
    IBLOutput ibl_1;
    ibl_1.color_weighted = ((diffuseColor * diffuseLight) + (specularColor * specularLight)) * _2708.render_lights_params.env_map_intensity;
    ibl_1.color_raw = (diffuseLight + specularLight) * _2708.render_lights_params.env_map_intensity;
    return ibl_1;
}

void main()
{
    twoSided = false;
    clipless = false;
    ivec2 screen_pos = ivec2(gl_FragCoord.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 vNorm = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec4 param_3 = vFrustum;
    float param_4 = depth;
    vec3 world = positionFromDepth(param_3, param_4);
    outColor = vec4(0.0);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, screen_pos, 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        outColor = base_color;
        outColor.w = 0.0;
        return;
    }
    vec3 base_emissive = texelFetch(sEmissive, screen_pos, 0).xyz * materials.material_properties[material].emissive;
    bool is_background = (materialId & 1) == 1;
    bool is_raytraced = (material_flags & 1u) != 0u;
    bool is_particle = (material_flags & 8192u) != 0u;
    if (is_particle == false)
    {
    }
    else
    {
        outColor = base_color;
        outColor.w = 0.0;
        base_color.x = materials.material_properties[material].diffuse.x;
        base_color.y = materials.material_properties[material].diffuse.y;
        base_color.z = materials.material_properties[material].diffuse.z;
    }
    if (false)
    {
        if (is_raytraced)
        {
            float color_magnitude = length(base_color.xyz);
            if (color_magnitude > 1.0)
            {
                vec3 emissive_from_base_color = base_color.xyz - (base_color.xyz / vec3(color_magnitude));
                vec4 _2885 = base_color;
                vec3 _2887 = _2885.xyz - emissive_from_base_color;
                base_color.x = _2887.x;
                base_color.y = _2887.y;
                base_color.z = _2887.z;
                base_emissive += emissive_from_base_color;
            }
            vec3 param_6 = base_color.xyz;
            vec3 _2900 = saturate(param_6);
            base_color.x = _2900.x;
            base_color.y = _2900.y;
            base_color.z = _2900.z;
        }
    }
    vec3 f0 = vec3(0.039999999105930328369140625);
    vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
    float alphaRoughness = roughness * roughness;
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    vec3 view = normalize(_1067.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    if (is_particle == false)
    {
        float param_9;
        float param_22;
        LTCRect param_32;
        vec3 param_34[4];
        float param_52;
        vec4 param_53;
        for (int light_idx = 0; light_idx < _2708.render_lights_params.lights_num; light_idx++)
        {
            LightProperties _2988;
            _2988.diffuse = lights.light_properties[light_idx].diffuse;
            _2988.direction = lights.light_properties[light_idx].direction;
            _2988.position = lights.light_properties[light_idx].position;
            _2988.up = lights.light_properties[light_idx].up;
            _2988.right = lights.light_properties[light_idx].right;
            _2988.dimensions = lights.light_properties[light_idx].dimensions;
            _2988._pad1 = lights.light_properties[light_idx]._pad1;
            _2988.intensity = lights.light_properties[light_idx].intensity;
            _2988.range = lights.light_properties[light_idx].range;
            _2988.cutoff = lights.light_properties[light_idx].cutoff;
            _2988.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _2988.is_area = lights.light_properties[light_idx].is_area;
            _2988.type = lights.light_properties[light_idx].type;
            _2988.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _2988.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _2988.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _2988.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _2988.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _2988.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _2988.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _2988.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _2988.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _2988.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _2988.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _2988.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _2988.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _2988.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _2988.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _2988.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _2988.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _2988.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _2988.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _2988;
            vec3 light_color = vec3(0.0);
            if ((light.type & 2) != 0)
            {
                if ((light.type & 64) != 0)
                {
                    Cone cone = Cone(light.cutoff * 1.0, light.range * 1.5, light.position.xyz, light.direction.xyz);
                    Ray ray = Ray(_1067.basic_params.camera_position, normalize(vFrustum.xyz));
                    float vv = 0.0;
                    Cone param_7 = cone;
                    Ray param_8 = ray;
                    bool _3031 = intersect_cone(param_7, param_8, param_9);
                    vv = param_9;
                    if (_3031 == false)
                    {
                        continue;
                    }
                }
            }
            vec3 pointToLight = light.position.xyz - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction.xyz;
            }
            pointToLight = normalize(pointToLight);
            float NdotL = dot(vNorm, pointToLight);
            if ((materialId & 1) == 1)
            {
                NdotL = 1.0;
            }
            vec3 param_10 = pointToLight;
            MaterialInfo param_11 = materialInfo;
            vec3 param_12 = vNorm;
            vec3 param_13 = view;
            vec3 lighting = (getPointShade(param_10, param_11, param_12, param_13) * light.intensity) * light.diffuse.xyz;
            float shadow = 0.0;
            bool _3085 = (material_flags & 512u) != 0u;
            bool _3092;
            if (_3085)
            {
                _3092 = (light.type & 8) != 0;
            }
            else
            {
                _3092 = _3085;
            }
            bool calculate_shadows = _3092;
            if (is_background)
            {
                shadow = 0.0;
                lighting = vec3(1.0);
                calculate_shadows = false;
            }
            if (((light.type & 3) != 0) && calculate_shadows)
            {
                vec4 vShadowCoords = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                float in_frustum = 0.0;
                vec2 penumbraHash = texelFetch(s_BlueNoise, ivec3(screen_pos & ivec2(127), _674.globals.monotonic & 15), 0).xy;
                float light_size = length(light.dimensions);
                int penumbra_iterations = max(6, min(10, int(light_size * 0.0024999999441206455230712890625)));
                float param_14 = light_size;
                vec2 param_15 = penumbraHash;
                vec4 param_16 = vShadowCoords;
                float param_17 = max(0.25, light_size * 0.20000000298023223876953125) / 1024.0;
                int param_18 = penumbra_iterations;
                float param_19 = materials.material_properties[material].shadowmap_bias;
                float penumbra = PenumbraFromOccluderSearch(LightShadowmapSamplers[light.shadowmap_sampler0], param_14, param_15, param_16, param_17, param_18, param_19);
                int light_iterations = max(4, min(12, int((penumbra * light.roughness_modifier) * 0.25)));
                vec4 param_20 = vShadowCoords;
                ivec2 param_21 = screen_pos;
                int param_23 = light_iterations;
                float param_24 = max(0.25, penumbra * light.roughness_modifier) / 1024.0;
                float param_25 = materials.material_properties[material].shadowmap_bias;
                float _3201 = sampleShadowPCFNoiseOffset(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_20, param_21, param_22, param_23, param_24, param_25);
                in_frustum = param_22;
                shadow = _3201;
                if (NdotL <= 0.0)
                {
                    shadow = max(shadow, smoothstep(0.0, -0.0500000007450580596923828125, NdotL));
                }
            }
            light_color = lighting * (1.0 - shadow);
            if ((light.type & 16) != 0)
            {
                vec4 vShadowCoords_1 = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                vec4 param_26 = vShadowCoords_1;
                vec4 _3242 = sampleProjectorTexture(LightProjectorSamplers[light.projector_sampler], param_26);
                vec3 projector_color = _3242.xyz * light.projector_intensity;
                light_color *= projector_color;
            }
            if ((light.type & 130) == 130)
            {
                LightProperties param_27 = light;
                vec3 param_28 = world;
                float attenuation = light_calculate_spot_attenuation(param_27, param_28);
                light_color *= attenuation;
            }
            else
            {
                if ((light.type & 132) == 132)
                {
                    LightProperties param_29 = light;
                    vec3 param_30 = world;
                    float attenuation_1 = light_calculate_point_attenuation(param_29, param_30);
                    light_color *= attenuation_1;
                }
            }
            if (light.is_area != 0)
            {
                if ((materialId & 1) == 1)
                {
                    light_color = normalize(light.diffuse.xyz) * light.intensity;
                }
                else
                {
                    LightProperties param_31 = light;
                    InitRect(param_31, param_32);
                    LTCRect rect = param_32;
                    LTCRect param_33 = rect;
                    InitRectPoints(param_33, param_34);
                    vec3 points[4] = param_34;
                    float ltc_roughness = roughness;
                    float ltc_intensity = light.intensity;
                    vec3 dcol = light.diffuse.xyz;
                    vec3 scol = dcol;
                    vec3 col = vec3(0.0);
                    vec3 pos = world;
                    vec3 N = vNorm;
                    vec3 V = normalize(_1067.basic_params.camera_position - world);
                    float ndotv = clamp(dot(N, V), 0.0500000007450580596923828125, 1.0);
                    vec2 uv = vec2(ltc_roughness, sqrt(1.0 - ndotv));
                    uv = (uv * 0.984375) + vec2(0.0078125);
                    vec4 t1 = texture(s_LTC1, uv);
                    vec4 t2 = texture(s_LTC2, uv);
                    mat3 Minv = mat3(vec3(vec3(t1.x, 0.0, t1.y)), vec3(0.0, 1.0, 0.0), vec3(vec3(t1.z, 0.0, t1.w)));
                    vec3 param_35 = N;
                    vec3 param_36 = V;
                    vec3 param_37 = pos;
                    mat3 param_38 = Minv;
                    vec3 param_39[4] = points;
                    bool param_40 = twoSided;
                    vec3 _3398 = LTC_Evaluate(param_35, param_36, param_37, param_38, param_39, param_40);
                    vec3 spec = _3398;
                    spec *= ((scol * t2.x) + ((vec3(1.0) - scol) * t2.y));
                    vec3 param_41 = N;
                    vec3 param_42 = V;
                    vec3 param_43 = pos;
                    mat3 param_44 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
                    vec3 param_45[4] = points;
                    bool param_46 = twoSided;
                    vec3 _3427 = LTC_Evaluate(param_41, param_42, param_43, param_44, param_45, param_46);
                    vec3 diff = _3427;
                    col = ((spec * specularColor) + ((dcol * diff) * diffuseColor)) * ltc_intensity;
                    light_color = col;
                }
                if ((light.type & 128) == 128)
                {
                    LightProperties param_47 = light;
                    vec3 param_48 = world;
                    float attenuation_2 = light_calculate_area_attenuation(param_47, param_48);
                    light_color *= attenuation_2;
                }
            }
            if ((light.type & 64) != 0)
            {
                float attenuation_3 = 0.0;
                vec4 projector_color_1 = vec4(0.0);
                LightProperties param_49 = light;
                vec4 param_50 = vFrustum;
                float param_51 = depth;
                float _3473 = volumetric_sample_shadow_spot(param_49, param_50, param_51, param_52, param_53);
                attenuation_3 = param_52;
                projector_color_1 = param_53;
                float volume_attenuation = _3473;
                outColor.w += (light.diffuse.w * volume_attenuation);
            }
            outLightColor += light_color;
        }
        if (true)
        {
            if (is_raytraced)
            {
                vec2 p = vTexcoord0 * _2708.render_lights_params.raytrace_scaling_factor;
                vec4 raytraceColor = texture(sRaytrace, p);
                vec4 _3508 = raytraceColor;
                vec3 _3510 = _3508.xyz * _2708.render_lights_params.raytrace_strength;
                raytraceColor.x = _3510.x;
                raytraceColor.y = _3510.y;
                raytraceColor.z = _3510.z;
                outLightColor += ((specularColor * raytraceColor.xyz) * (1.0 - roughness));
                outLightColor = mix(outLightColor, raytraceColor.xyz, vec3(raytraceColor.w));
            }
        }
    }
    outLightColor += base_emissive;
    if (is_background == false)
    {
        float rt_specular_occlusion = 1.0;
        vec2 vx_diffuse_specular_occlusion = vec2(1.0) - texelFetch(sVoxelOcclusion, screen_pos, 0).xy;
        float vx_specular_occlusion = vx_diffuse_specular_occlusion.y;
        if (is_raytraced)
        {
            vec4 raytraceColor_1 = texelFetch(sRaytrace, screen_pos, 0);
            uvec4 raytraceHitAttribute = texelFetch(sRaytraceHitInfo, screen_pos, 0);
            uint bounces = raytraceHitAttribute.x;
            if (bounces >= 2u)
            {
                rt_specular_occlusion = raytraceColor_1.w;
            }
        }
        float specular_occlusion = min(rt_specular_occlusion, vx_specular_occlusion);
        float diffuse_occlusion = 0.0;
        float ss_ao = max(texelFetch(sScreenSpaceOcclusion, screen_pos, 0).x, 0.0);
        float vx_ao = vx_diffuse_specular_occlusion.x;
        if (_3594.composite_setup.sso_strength > 0.0)
        {
            ss_ao = pow(ss_ao, _3594.composite_setup.sso_strength);
            vx_ao = pow(vx_ao, _3594.composite_setup.sso_strength);
            ss_ao = 1.0 - clamp((1.0 - ss_ao) * _3594.composite_setup.occlusion_strength, 0.0, 1.0);
            vx_ao = 1.0 - clamp((1.0 - vx_ao) * _3594.composite_setup.occlusion_strength, 0.0, 1.0);
            specular_occlusion = pow(specular_occlusion, _3594.composite_setup.sso_strength);
            specular_occlusion = 1.0 - clamp((1.0 - specular_occlusion) * _3594.composite_setup.occlusion_strength, 0.0, 1.0);
        }
        float ao = min(ss_ao, vx_ao);
        specular_occlusion = 1.0 - max(1.0 - specular_occlusion, (1.0 - ao) * _3594.composite_setup.occlusion_specular_from_diffuse);
        diffuse_occlusion = 1.0 - ao;
        specular_occlusion = 1.0 - specular_occlusion;
        vec3 param_54 = vNorm;
        vec3 param_55 = view;
        vec3 param_56 = materialInfo.diffuseColor * (1.0 - diffuse_occlusion);
        vec3 param_57 = materialInfo.specularColor * (1.0 - specular_occlusion);
        vec3 param_58 = specularEnvironmentR0;
        vec3 param_59 = specularEnvironmentR90;
        float param_60 = roughness;
        IBLOutput ibl_1 = ibl(param_54, param_55, param_56, param_57, param_58, param_59, param_60);
        vec4 _3676 = outColor;
        vec3 _3678 = _3676.xyz + ibl_1.color_raw;
        outColor.x = _3678.x;
        outColor.y = _3678.y;
        outColor.z = _3678.z;
        outLightColor += (ibl_1.color_weighted - ibl_1.color_raw);
    }
    vec4 _3693 = outColor;
    vec3 _3695 = _3693.xyz + outLightColor;
    outColor.x = _3695.x;
    outColor.y = _3695.y;
    outColor.z = _3695.z;
    if (is_background == false)
    {
        vec4 _3718 = outColor;
        vec3 _3720 = _3718.xyz * (((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz) + vec3(1.0));
        outColor.x = _3720.x;
        outColor.y = _3720.y;
        outColor.z = _3720.z;
        vec4 _3737 = outColor;
        vec3 _3739 = _3737.xyz + ((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz);
        outColor.x = _3739.x;
        outColor.y = _3739.y;
        outColor.z = _3739.z;
    }
    vec3 noisyColor = outColor.xyz - outLightColor;
}

 