#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleSnapshotParams
{
    int dest_buffer_offset;
    int source_buffer_size;
    int new_snapshot;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _29;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _46;

layout(set = 0, binding = 5, std140) uniform ParticleSnapshotParamsBuffer
{
    ParticleSnapshotParams snapshot_params;
} _87;

layout(set = 0, binding = 3, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 4, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

bool prt_is_alive(uint id)
{
    return _29.prt_states[id].life_time < _29.prt_states[id].life_span;
}

vec3 prt_get_position(uint id)
{
    return vec3(_46.prt_positions[(id * 3u) + 0u], _46.prt_positions[(id * 3u) + 1u], _46.prt_positions[(id * 3u) + 2u]);
}

float prt_get_generation_id(uint id)
{
    return _29.prt_states[id].generation_id;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    bool _92 = id < uint(_87.snapshot_params.source_buffer_size);
    bool _98;
    if (_92)
    {
        uint param = id;
        _98 = prt_is_alive(param);
    }
    else
    {
        _98 = _92;
    }
    if (_98)
    {
        uint param_1 = id;
        vec3 pos = prt_get_position(param_1);
        prt_position_snapshots.position[((id + uint(_87.snapshot_params.dest_buffer_offset)) * 3u) + 0u] = pos.x;
        prt_position_snapshots.position[((id + uint(_87.snapshot_params.dest_buffer_offset)) * 3u) + 1u] = pos.y;
        prt_position_snapshots.position[((id + uint(_87.snapshot_params.dest_buffer_offset)) * 3u) + 2u] = pos.z;
        uint param_2 = id;
        float generation_id = prt_get_generation_id(param_2);
        if (generation_id != prt_states_snapshots.states[id].generation_id)
        {
            prt_states_snapshots.states[id].generation_id = generation_id;
            prt_states_snapshots.states[id].segments = 0u;
        }
        else
        {
            if (_87.snapshot_params.new_snapshot != 0)
            {
                prt_states_snapshots.states[id].segments++;
            }
        }
    }
    else
    {
        prt_states_snapshots.states[id].segments = 0u;
    }
}

 