#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _391
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _382;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _400;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _391 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void material_evaluate(MaterialPropertiesGPU material, MaterialEval eval, MaterialEvalInput eval_input)
{
    float factor = eval_input.modifier_factor;
    float y = eval_input.local_coords.y + eval_input.local_coords.x;
    y = fract(y * 40.09999847412109375);
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _193 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _193.x;
    o.y = _193.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _389;
    _389.diffuse = materials.material_properties[_382.materialIndex].diffuse;
    _389.transparency = materials.material_properties[_382.materialIndex].transparency;
    _389.emissive = materials.material_properties[_382.materialIndex].emissive;
    _389.roughness = materials.material_properties[_382.materialIndex].roughness;
    _389.triplanar_factor = materials.material_properties[_382.materialIndex].triplanar_factor;
    _389.refraction = materials.material_properties[_382.materialIndex].refraction;
    _389.normal_factor = materials.material_properties[_382.materialIndex].normal_factor;
    _389.emissive_factor = materials.material_properties[_382.materialIndex].emissive_factor;
    _389.temporal_accumulation_factor = materials.material_properties[_382.materialIndex].temporal_accumulation_factor;
    _389.shadowmap_bias = materials.material_properties[_382.materialIndex].shadowmap_bias;
    _389.metalness = materials.material_properties[_382.materialIndex].metalness;
    _389.albedo_sampler = materials.material_properties[_382.materialIndex].albedo_sampler;
    _389.emissive_sampler = materials.material_properties[_382.materialIndex].emissive_sampler;
    _389.normal_sampler = materials.material_properties[_382.materialIndex].normal_sampler;
    _389.metalic_roughness_sampler = materials.material_properties[_382.materialIndex].metalic_roughness_sampler;
    _389.flags = materials.material_properties[_382.materialIndex].flags;
    _389._pad0 = materials.material_properties[_382.materialIndex]._pad0;
    _389._pad1 = materials.material_properties[_382.materialIndex]._pad1;
    MaterialPropertiesGPU material = _389;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _400.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _505 = material.normal_sampler >= 0;
    bool _512;
    if (_505)
    {
        _512 = material.normal_sampler < 16;
    }
    else
    {
        _512 = _505;
    }
    if (_512)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdxFine(worldPos);
            vec3 pos_dy = dFdyFine(worldPos);
            vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = mix(normal, n, vec3(material.normal_factor));
                n = normalize(n * transpose(tbn));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _400.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat33(param_14, param_15);
            mat4 m = _400.transform_params.mModelNormal;
            vec3 scale;
            scale.x = length(vec3(m[0].x, m[0].y, m[0].z));
            scale.y = length(vec3(m[1].x, m[1].y, m[1].z));
            scale.z = length(vec3(m[2].x, m[2].y, m[2].z));
            n_1 *= (vec3(1.0) / scale);
            n_1 = normalize(n_1);
            n_1 = normalize(mix(normal, n_1, vec3(material.normal_factor)));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_16 = normal;
    int param_17 = _382.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _400.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _400.transform_params.mModelInv;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _382.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_18 = material;
    MaterialEval param_19 = material_eval;
    MaterialEvalInput param_20 = eval_input;
    material_evaluate(param_18, param_19, param_20);
    material_eval = param_19;
    eval_input = param_20;
    if ((material_eval.flag_overrides & 2u) != 0u)
    {
        material_flag_overrides = material_eval.flag_overrides;
    }
    if (material_eval.is_discarded)
    {
        discard;
    }
    outAlbedo = material_eval.albedo * material_eval.albedo_texture;
    vec3 _830 = material_eval.emissive * material_eval.emissive_texture;
    outEmissive.x = _830.x;
    outEmissive.y = _830.y;
    outEmissive.z = _830.z;
    outEmissive.w = 0.0;
    float roughness = material_eval.roughness * material_eval.roughness_texture;
    float metalness = material_eval.metalness * material_eval.metalness_texture;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_382.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_382.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_21 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_21);
}

 