#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _441
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _432;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _450;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _441 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

vec4 getMaterialAlbedo(MaterialPropertiesGPU material, vec4 albedo, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return albedo;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

vec3 getMaterialEmissive(MaterialPropertiesGPU material, vec3 emissive, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return emissive;
}

float getMaterialRoughness(MaterialPropertiesGPU material, float roughness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return roughness;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _210 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _210.x;
    o.y = _210.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _439;
    _439.diffuse = materials.material_properties[_432.materialIndex].diffuse;
    _439.transparency = materials.material_properties[_432.materialIndex].transparency;
    _439.emissive = materials.material_properties[_432.materialIndex].emissive;
    _439.roughness = materials.material_properties[_432.materialIndex].roughness;
    _439.triplanar_factor = materials.material_properties[_432.materialIndex].triplanar_factor;
    _439.refraction = materials.material_properties[_432.materialIndex].refraction;
    _439.normal_factor = materials.material_properties[_432.materialIndex].normal_factor;
    _439.emissive_factor = materials.material_properties[_432.materialIndex].emissive_factor;
    _439.temporal_accumulation_factor = materials.material_properties[_432.materialIndex].temporal_accumulation_factor;
    _439.shadowmap_bias = materials.material_properties[_432.materialIndex].shadowmap_bias;
    _439.metalness = materials.material_properties[_432.materialIndex].metalness;
    _439.albedo_sampler = materials.material_properties[_432.materialIndex].albedo_sampler;
    _439.emissive_sampler = materials.material_properties[_432.materialIndex].emissive_sampler;
    _439.normal_sampler = materials.material_properties[_432.materialIndex].normal_sampler;
    _439.metalic_roughness_sampler = materials.material_properties[_432.materialIndex].metalic_roughness_sampler;
    _439.flags = materials.material_properties[_432.materialIndex].flags;
    _439._pad0 = materials.material_properties[_432.materialIndex]._pad0;
    _439._pad1 = materials.material_properties[_432.materialIndex]._pad1;
    MaterialPropertiesGPU material = _439;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _450.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _556 = material.normal_sampler >= 0;
    bool _563;
    if (_556)
    {
        _563 = material.normal_sampler < 16;
    }
    else
    {
        _563 = _556;
    }
    if (_563)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdxFine(worldPos);
            vec3 pos_dy = dFdyFine(worldPos);
            vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = mix(normal, n, vec3(material.normal_factor));
                n = normalize(n * transpose(tbn));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _450.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat33(param_14, param_15);
            mat4 m = _450.transform_params.mModelNormal;
            vec3 scale;
            scale.x = length(vec3(m[0].x, m[0].y, m[0].z));
            scale.y = length(vec3(m[1].x, m[1].y, m[1].z));
            scale.z = length(vec3(m[2].x, m[2].y, m[2].z));
            n_1 *= (vec3(1.0) / scale);
            n_1 = normalize(n_1);
            n_1 = normalize(mix(normal, n_1, vec3(material.normal_factor)));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_16 = normal;
    int param_17 = _432.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    float factor = 1.0;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _432.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    outAlbedo = vec4(material.diffuse, _432.colorDiffuse.w);
    MaterialPropertiesGPU param_18 = material;
    vec4 param_19 = outAlbedo;
    vec3 param_20 = worldPos;
    vec3 param_21 = vtx_input.vLocalPos;
    vec3 param_22 = vtx_input.vNorm;
    vec3 param_23 = vtx_input.vWorldNorm;
    outAlbedo = getMaterialAlbedo(param_18, param_19, param_20, param_21, param_22, param_23);
    bool _855 = material.albedo_sampler >= 0;
    bool _861;
    if (_855)
    {
        _861 = material.albedo_sampler < 16;
    }
    else
    {
        _861 = _855;
    }
    if (_861)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_24 = vtx_input.vLocalPos;
            vec3 param_25 = norm;
            vec3 param_26 = material.triplanar_factor;
            outAlbedo *= mapping_triplanar(material_textures[material.albedo_sampler], param_24, param_25, param_26);
        }
        else
        {
            outAlbedo *= texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    vec4 _896 = outAlbedo;
    vec3 _898 = _896.xyz * vtx_input.vColor.xyz;
    outAlbedo.x = _898.x;
    outAlbedo.y = _898.y;
    outAlbedo.z = _898.z;
    outEmissive = vec4(0.0);
    MaterialPropertiesGPU param_27 = material;
    vec3 param_28 = outEmissive.xyz;
    vec3 param_29 = worldPos;
    vec3 param_30 = vtx_input.vLocalPos;
    vec3 param_31 = vtx_input.vNorm;
    vec3 param_32 = vtx_input.vWorldNorm;
    vec3 _924 = getMaterialEmissive(param_27, param_28, param_29, param_30, param_31, param_32);
    outEmissive.x = _924.x;
    outEmissive.y = _924.y;
    outEmissive.z = _924.z;
    if (false)
    {
        bool _936 = material.emissive_sampler >= 0;
        bool _942;
        if (_936)
        {
            _942 = material.emissive_sampler < 16;
        }
        else
        {
            _942 = _936;
        }
        if (_942)
        {
            if ((material.flags & 1024u) != 0u)
            {
                vec3 param_33 = vtx_input.vLocalPos;
                vec3 param_34 = norm;
                vec3 param_35 = material.triplanar_factor;
                vec4 _964 = outEmissive;
                vec3 _966 = _964.xyz * mapping_triplanar(material_textures[material.emissive_sampler], param_33, param_34, param_35).xyz;
                outEmissive.x = _966.x;
                outEmissive.y = _966.y;
                outEmissive.z = _966.z;
            }
            else
            {
                vec4 _981 = outEmissive;
                vec3 _983 = _981.xyz * texture(material_textures[material.emissive_sampler], uv0).xyz;
                outEmissive.x = _983.x;
                outEmissive.y = _983.y;
                outEmissive.z = _983.z;
            }
        }
    }
    float roughness = material.roughness;
    MaterialPropertiesGPU param_36 = material;
    float param_37 = roughness;
    vec3 param_38 = worldPos;
    vec3 param_39 = vtx_input.vLocalPos;
    vec3 param_40 = vtx_input.vNorm;
    vec3 param_41 = vtx_input.vWorldNorm;
    roughness = getMaterialRoughness(param_36, param_37, param_38, param_39, param_40, param_41);
    bool _1012 = material.metalic_roughness_sampler >= 0;
    bool _1018;
    if (_1012)
    {
        _1018 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _1018 = _1012;
    }
    if (_1018)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_42 = vtx_input.vLocalPos;
            vec3 param_43 = norm;
            vec3 param_44 = material.triplanar_factor;
            roughness *= mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_42, param_43, param_44).y;
        }
        else
        {
            roughness *= texture(material_textures[material.metalic_roughness_sampler], uv0).y;
        }
    }
    float metalness = material.metalness;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_432.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_432.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_45 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_45);
}

 