#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 5, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _1066;

layout(set = 0, binding = 6, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1079;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1091;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1114;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1139;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1147;

layout(set = 0, binding = 7, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1181;

layout(set = 0, binding = 8, std140) uniform VM1
{
    InstanceModifierRandomizerV2_Params VM1_params;
} _1196;

layout(set = 0, binding = 9, std140) uniform VM2
{
    ModifierFactorClamp_Params VM2_params;
} _1222;

layout(set = 0, binding = 10, std140) uniform VM3
{
    InstanceModifierRandomizerV2_Params VM3_params;
} _1234;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _226 = hash(param);
    uint param_1 = v.z;
    uint _231 = hash(param_1);
    uint param_2 = (v.x ^ _226) ^ _231;
    uint _234 = hash(param_2);
    return _234;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _263 = floatConstruct(param_1);
    return _263;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _253 = hash(param);
    uint param_1 = _253;
    float _255 = floatConstruct(param_1);
    return _255;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_1066.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_1079.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _1091.instance_transform[(id * 3u) + 0u];
    instance.m1 = _1091.instance_transform[(id * 3u) + 1u];
    instance.m2 = _1091.instance_transform[(id * 3u) + 2u];
    vec2 _1121 = unpackHalf2x16(_1114.instance_color[(id * 2u) + 0u]);
    instance.c.x = _1121.x;
    instance.c.y = _1121.y;
    vec2 _1131 = unpackHalf2x16(_1114.instance_color[(id * 2u) + 1u]);
    instance.c.z = _1131.x;
    instance.c.w = _1131.y;
    instance.flipbook_card = _1139.instance_flipbook_card[id];
    instance.hash = _1147.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _1186;
    _1186.transform_local_to_gizmo = _1181.VM0_params.transform_local_to_gizmo;
    _1186.noise_domain_scale = _1181.VM0_params.noise_domain_scale;
    _1186.modifier_function = _1181.VM0_params.modifier_function;
    _1186.noise_domain_offset = _1181.VM0_params.noise_domain_offset;
    _1186.noise_value_scale = _1181.VM0_params.noise_value_scale;
    _1186.noise_value_offset = _1181.VM0_params.noise_value_offset;
    _1186.influence_scope = _1181.VM0_params.influence_scope;
    _1186._pad0 = _1181.VM0_params._pad0;
    _1186._pad1 = _1181.VM0_params._pad1;
    ModifierFactorNoise_Params param = _1186;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise(param, param_1, param_2);
    modifier_factor = param_1;
    InstanceModifierRandomizerV2_Params _1201;
    _1201.replace_previous_rotation_scale = _1196.VM1_params.replace_previous_rotation_scale;
    _1201.randomness_seed = _1196.VM1_params.randomness_seed;
    _1201.replace_previous_position = _1196.VM1_params.replace_previous_position;
    _1201.randomization_input = _1196.VM1_params.randomization_input;
    _1201.position_modifier_base = _1196.VM1_params.position_modifier_base;
    _1201.position_modifier_base_modifier_factor = _1196.VM1_params.position_modifier_base_modifier_factor;
    _1201.position_modifier_range = _1196.VM1_params.position_modifier_range;
    _1201.position_modifier_range_modifier_factor = _1196.VM1_params.position_modifier_range_modifier_factor;
    _1201.rotation_modifier_base = _1196.VM1_params.rotation_modifier_base;
    _1201.rotation_modifier_base_modifier_factor = _1196.VM1_params.rotation_modifier_base_modifier_factor;
    _1201.rotation_modifier_range = _1196.VM1_params.rotation_modifier_range;
    _1201.rotation_modifier_range_modifier_factor = _1196.VM1_params.rotation_modifier_range_modifier_factor;
    _1201.scale_modifier_base = _1196.VM1_params.scale_modifier_base;
    _1201.scale_modifier_base_modifier_factor = _1196.VM1_params.scale_modifier_base_modifier_factor;
    _1201.scale_modifier_range = _1196.VM1_params.scale_modifier_range;
    _1201.scale_modifier_range_modifier_factor = _1196.VM1_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_3 = _1201;
    ModifierFactor param_4 = modifier_factor;
    Instance param_5 = instance;
    uint param_6 = id;
    instance_modifier_randomizer_v2(param_3, param_4, param_5, param_6);
    modifier_factor = param_4;
    instance = param_5;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorClamp_Params _1227;
    _1227.clamp_min = _1222.VM2_params.clamp_min;
    _1227.clamp_max = _1222.VM2_params.clamp_max;
    _1227.clamp_min_enable = _1222.VM2_params.clamp_min_enable;
    _1227.clamp_max_enable = _1222.VM2_params.clamp_max_enable;
    ModifierFactorClamp_Params param_7 = _1227;
    ModifierFactor param_8 = modifier_factor;
    modifier_factor_clamp(param_7, param_8);
    modifier_factor = param_8;
    InstanceModifierRandomizerV2_Params _1238;
    _1238.replace_previous_rotation_scale = _1234.VM3_params.replace_previous_rotation_scale;
    _1238.randomness_seed = _1234.VM3_params.randomness_seed;
    _1238.replace_previous_position = _1234.VM3_params.replace_previous_position;
    _1238.randomization_input = _1234.VM3_params.randomization_input;
    _1238.position_modifier_base = _1234.VM3_params.position_modifier_base;
    _1238.position_modifier_base_modifier_factor = _1234.VM3_params.position_modifier_base_modifier_factor;
    _1238.position_modifier_range = _1234.VM3_params.position_modifier_range;
    _1238.position_modifier_range_modifier_factor = _1234.VM3_params.position_modifier_range_modifier_factor;
    _1238.rotation_modifier_base = _1234.VM3_params.rotation_modifier_base;
    _1238.rotation_modifier_base_modifier_factor = _1234.VM3_params.rotation_modifier_base_modifier_factor;
    _1238.rotation_modifier_range = _1234.VM3_params.rotation_modifier_range;
    _1238.rotation_modifier_range_modifier_factor = _1234.VM3_params.rotation_modifier_range_modifier_factor;
    _1238.scale_modifier_base = _1234.VM3_params.scale_modifier_base;
    _1238.scale_modifier_base_modifier_factor = _1234.VM3_params.scale_modifier_base_modifier_factor;
    _1238.scale_modifier_range = _1234.VM3_params.scale_modifier_range;
    _1238.scale_modifier_range_modifier_factor = _1234.VM3_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_9 = _1238;
    ModifierFactor param_10 = modifier_factor;
    Instance param_11 = instance;
    uint param_12 = id;
    instance_modifier_randomizer_v2(param_9, param_10, param_11, param_12);
    modifier_factor = param_10;
    instance = param_11;
    _1091.instance_transform[(id * 3u) + 0u] = instance.m0;
    _1091.instance_transform[(id * 3u) + 1u] = instance.m1;
    _1091.instance_transform[(id * 3u) + 2u] = instance.m2;
    _1114.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1114.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1139.instance_flipbook_card[id] = instance.flipbook_card;
}

 