#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct VertexModifierNoiseParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 noise_phase;
    vec3 noise_scale;
    int falloff_curve_idx;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int noise_relative_to_modifier;
    vec3 radius;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    int influence_scope;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _2422
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _2000;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2011;

layout(set = 0, binding = 10, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _2023;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2109;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2301;

layout(set = 0, binding = 11, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _2317;

layout(set = 0, binding = 12, std140) uniform VM0
{
    ModifierFactorQuantizePosition_Params VM0_params;
} _2330;

layout(set = 0, binding = 13, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _2345;

layout(set = 0, binding = 14, std140) uniform VM2
{
    VertexModifierDisplaceParams VM2_params;
} _2360;

layout(set = 0, binding = 15, std140) uniform VM3
{
    layout(row_major) ModifierFactorNoise_Params VM3_params;
} _2380;

layout(set = 0, binding = 16, std140) uniform VM4
{
    ModifierFactorRangeRemap_Params VM4_params;
} _2394;

layout(set = 0, binding = 17, std140) uniform VM5
{
    layout(row_major) VertexModifierNoiseParams VM5_params;
} _2407;

layout(set = 0, binding = 8, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2513;

layout(set = 0, binding = 18) uniform sampler2D s_Curves;

layout(location = 1) out _2422 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

mat4 mat_mul_affine(mat4 ma, mat4 mb)
{
    return ma * mb;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

float snoise_grad(vec3 v, inout vec3 gradient)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m4 = m2 * m2;
    vec4 pdotx = vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3));
    vec4 temp = (m2 * m) * pdotx;
    gradient = ((((x0 * temp.x) + (x1 * temp.y)) + (x2 * temp.z)) + (x3 * temp.w)) * (-8.0);
    gradient += ((((p0 * m4.x) + (p1 * m4.y)) + (p2 * m4.z)) + (p3 * m4.w));
    gradient *= 42.0;
    return 42.0 * dot(m4, pdotx);
}

void vertex_modifier_noise_apply(VertexModifierNoiseParams params, ModifierFactor modifier_factor, inout VertexInput vtx_input, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    mat4 mat_local_to_model = cs_transforms.mat_local_to_model;
    if (params.influence_scope == 1)
    {
        mat4 param = mat_local_to_model;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        mat_local_to_model = mat_mul_affine(param, param_1);
    }
    vec3 param_2 = vtx_input.pos;
    mat4 param_3 = (params.transform_parent_inv * params.transform_local_inv) * mat_local_to_model;
    vec3 influence_pos = vector_transform_by_mat43(param_2, param_3);
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_4 = noise_pos;
        mat4 param_5 = params.transform_local;
        noise_pos = vector_transform_by_mat43(param_4, param_5);
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_6 = params.falloff_curve_idx;
        float param_7 = influence;
        influence = clamp(curve_sample(param_6, param_7), 0.0, 1.0);
        influence *= modifier_factor.factor;
        vec3 ni = noise_pos * params.noise_scale;
        vec3 n1_grad = vec3(0.0);
        vec3 n2_grad = vec3(0.0);
        vec3 param_8 = (ni + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.01229999959468841552734375);
        vec3 param_9;
        float _1475 = snoise_grad(param_8, param_9);
        n1_grad = param_9;
        float n1 = _1475;
        vec3 param_10 = ((ni * 0.5) + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.02170000039041042327880859375);
        vec3 param_11;
        float _1493 = snoise_grad(param_10, param_11);
        n2_grad = param_11;
        float n2 = _1493;
        n1_grad *= params.noise_scale;
        n2_grad *= (params.noise_scale * 0.5);
        n2 *= 0.5;
        n2_grad *= 0.5;
        float d = 1.0;
        float n = (params.noise_value_base + n1) + n2;
        float n_dx = (((params.noise_value_base + n1) + (n1_grad.x * d)) + n2) + (n2_grad.x * d);
        float n_dy = (((params.noise_value_base + n1) + (n1_grad.y * d)) + n2) + (n2_grad.y * d);
        float n_dz = (((params.noise_value_base + n1) + (n1_grad.z * d)) + n2) + (n2_grad.z * d);
        if (params.noise_value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
            n_dz = abs(n_dz);
        }
        vec3 scale = params.scale;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_12 = modifier_position;
            mat4 param_13 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_12, param_13));
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + vec3(d, 0.0, 0.0)) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + vec3(0.0, d, 0.0)) + ((local_norm * n_dy) * scale);
        vec3 new_pos_dz = (base_pos + vec3(0.0, 0.0, d)) + ((local_norm * n_dz) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + vec3(d, 0.0, 0.0), new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + vec3(0.0, d, 0.0), new_pos_dy, vec3(influence));
        new_pos_dz = mix(base_pos + vec3(0.0, 0.0, d), new_pos_dz, vec3(influence));
        vec3 dx = new_pos_dx - new_pos;
        vec3 dy = new_pos_dy - new_pos;
        vec3 dz = new_pos_dz - new_pos;
        vec3 new_norm = vec3(1.0);
        bool _1694 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.y);
        bool _1704;
        if (_1694)
        {
            _1704 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.z);
        }
        else
        {
            _1704 = _1694;
        }
        if (_1704)
        {
            dy = normalize(dy);
            dz = normalize(dz);
            dx = cross(dy, dz);
        }
        else
        {
            bool _1721 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.x);
            bool _1731;
            if (_1721)
            {
                _1731 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.z);
            }
            else
            {
                _1731 = _1721;
            }
            if (_1731)
            {
                dx = normalize(dx);
                dz = normalize(dz);
                dy = cross(dz, dx);
            }
            else
            {
                dx = normalize(dx);
                dy = normalize(dy);
                dz = cross(dx, dy);
            }
        }
        new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    m[2].x = 0.0;
    m[2].y = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_2000.instance_params.stride > 0)
    {
        uint flipbook_card = _2011.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_2023.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_2023.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_2023.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_2023.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_2023.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_2000.instance_params.stride > 0)
    {
        vec4 inst_m0 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 0];
        vec4 inst_m1 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 1];
        vec4 inst_m2 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 2];
        vec3 _2140 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _2140.x;
        mat_instance_model[0].y = _2140.y;
        mat_instance_model[0].z = _2140.z;
        vec3 _2153 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _2153.x;
        mat_instance_model[1].y = _2153.y;
        mat_instance_model[1].z = _2153.z;
        vec3 _2166 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _2166.x;
        mat_instance_model[2].y = _2166.y;
        mat_instance_model[2].z = _2166.z;
        vec3 _2179 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _2179.x;
        mat_instance_model[3].y = _2179.y;
        mat_instance_model[3].z = _2179.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_2000.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _2301.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _2317.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _2317.transform_params.mModelInv;
    ModifierFactorQuantizePosition_Params _2335;
    _2335.quantization_step = _2330.VM0_params.quantization_step;
    _2335._pad0 = _2330.VM0_params._pad0;
    _2335.offset = _2330.VM0_params.offset;
    _2335.quantize_x = _2330.VM0_params.quantize_x;
    _2335.quantize_y = _2330.VM0_params.quantize_y;
    _2335.quantize_z = _2330.VM0_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_5 = _2335;
    ModifierFactor param_6 = modifier_factor;
    CoordinateSystemTrasforms param_7 = cs_transforms;
    modifier_factor_quantize_position(param_5, param_6, param_7);
    modifier_factor = param_6;
    ModifierFactorNoise_Params _2350;
    _2350.transform_local_to_gizmo = _2345.VM1_params.transform_local_to_gizmo;
    _2350.noise_domain_scale = _2345.VM1_params.noise_domain_scale;
    _2350.modifier_function = _2345.VM1_params.modifier_function;
    _2350.noise_domain_offset = _2345.VM1_params.noise_domain_offset;
    _2350.noise_value_scale = _2345.VM1_params.noise_value_scale;
    _2350.noise_value_offset = _2345.VM1_params.noise_value_offset;
    _2350.influence_scope = _2345.VM1_params.influence_scope;
    _2350._pad0 = _2345.VM1_params._pad0;
    _2350._pad1 = _2345.VM1_params._pad1;
    ModifierFactorNoise_Params param_8 = _2350;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_noise(param_8, param_9, param_10);
    modifier_factor = param_9;
    VertexModifierDisplaceParams _2365;
    _2365.displace_normal = _2360.VM2_params.displace_normal;
    _2365.displace_normal_modifier_factor = _2360.VM2_params.displace_normal_modifier_factor;
    _2365.displace_base = _2360.VM2_params.displace_base;
    _2365.displace_base_modifier_factor = _2360.VM2_params.displace_base_modifier_factor;
    _2365.influence_scope = _2360.VM2_params.influence_scope;
    VertexModifierDisplaceParams param_11 = _2365;
    ModifierFactor param_12 = modifier_factor;
    VertexInput param_13 = vtx_input;
    CoordinateSystemTrasforms param_14 = cs_transforms;
    vertex_modifier_displace_apply(param_11, param_12, param_13, param_14);
    modifier_factor = param_12;
    vtx_input = param_13;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorNoise_Params _2384;
    _2384.transform_local_to_gizmo = _2380.VM3_params.transform_local_to_gizmo;
    _2384.noise_domain_scale = _2380.VM3_params.noise_domain_scale;
    _2384.modifier_function = _2380.VM3_params.modifier_function;
    _2384.noise_domain_offset = _2380.VM3_params.noise_domain_offset;
    _2384.noise_value_scale = _2380.VM3_params.noise_value_scale;
    _2384.noise_value_offset = _2380.VM3_params.noise_value_offset;
    _2384.influence_scope = _2380.VM3_params.influence_scope;
    _2384._pad0 = _2380.VM3_params._pad0;
    _2384._pad1 = _2380.VM3_params._pad1;
    ModifierFactorNoise_Params param_15 = _2384;
    ModifierFactor param_16 = modifier_factor;
    CoordinateSystemTrasforms param_17 = cs_transforms;
    modifier_factor_noise(param_15, param_16, param_17);
    modifier_factor = param_16;
    ModifierFactorRangeRemap_Params _2399;
    _2399.input_min = _2394.VM4_params.input_min;
    _2399.input_max = _2394.VM4_params.input_max;
    _2399.output_min = _2394.VM4_params.output_min;
    _2399.output_max = _2394.VM4_params.output_max;
    _2399.min_out_of_bounds_mode = _2394.VM4_params.min_out_of_bounds_mode;
    _2399.max_out_of_bounds_mode = _2394.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_18 = _2399;
    ModifierFactor param_19 = modifier_factor;
    modifier_factor_range_remap(param_18, param_19);
    modifier_factor = param_19;
    VertexModifierNoiseParams _2412;
    _2412.transform_world_to_local = _2407.VM5_params.transform_world_to_local;
    _2412.transform_local_to_world = _2407.VM5_params.transform_local_to_world;
    _2412.transform_local = _2407.VM5_params.transform_local;
    _2412.transform_local_inv = _2407.VM5_params.transform_local_inv;
    _2412.transform_parent = _2407.VM5_params.transform_parent;
    _2412.transform_parent_inv = _2407.VM5_params.transform_parent_inv;
    _2412.noise_phase = _2407.VM5_params.noise_phase;
    _2412.noise_scale = _2407.VM5_params.noise_scale;
    _2412.falloff_curve_idx = _2407.VM5_params.falloff_curve_idx;
    _2412.scale = _2407.VM5_params.scale;
    _2412.falloff_inverse = _2407.VM5_params.falloff_inverse;
    _2412.position = _2407.VM5_params.position;
    _2412.noise_relative_to_modifier = _2407.VM5_params.noise_relative_to_modifier;
    _2412.radius = _2407.VM5_params.radius;
    _2412.displacement_mode = _2407.VM5_params.displacement_mode;
    _2412.noise_value_base = _2407.VM5_params.noise_value_base;
    _2412.noise_value_absolute = _2407.VM5_params.noise_value_absolute;
    _2412.influence_scope = _2407.VM5_params.influence_scope;
    VertexModifierNoiseParams param_20 = _2412;
    ModifierFactor param_21 = modifier_factor;
    VertexInput param_22 = vtx_input;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    vertex_modifier_noise_apply(param_20, param_21, param_22, param_23);
    modifier_factor = param_21;
    vtx_input = param_22;
    vtx_output.vLocalPos = vtx_input.pos;
    if (_2000.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 0];
        vec4 inst_m1_1 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 1];
        vec4 inst_m2_1 = _2109.instance_transform[(gl_InstanceIndex * _2000.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_24 = vtx_input.norm;
        mat4 param_25 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_24, param_25));
        vec2 _2519 = unpackHalf2x16(_2513.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2519.x;
        inst_c.y = _2519.y;
        vec2 _2529 = unpackHalf2x16(_2513.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2529.x;
        inst_c.w = _2529.y;
        vec4 _2535 = vtx_input.color;
        vec3 _2539 = _2535.xyz * inst_c.xyz;
        vtx_input.color.x = _2539.x;
        vtx_input.color.y = _2539.y;
        vtx_input.color.z = _2539.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vec3 param_26 = vtx_input.pos;
    mat4 param_27 = _2317.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_26, param_27);
    vec3 param_28 = vtx_input.norm;
    mat4 param_29 = _2317.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_28, param_29);
    vec3 param_30 = vPosModel;
    mat4 param_31 = _2317.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_30, param_31);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _2317.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_2317.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_2317.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_2317.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    vec3 param_32 = vtx_output.vCoords;
    mat4 param_33 = _2317.transform_params.mProjection;
    vec4 _2641 = vector_transform_by_mat_projection(param_32, param_33);
    gl_Position = _2641;
}

 