#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _35;

layout(set = 0, binding = 2, std430) buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 0, binding = 3) uniform usampler3D s_grid_marker;

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

uint rt_link_list_get_count(uint list_index)
{
    return _35.in_faces_list_tails_data[list_index];
}

void main()
{
    uint total = 0u;
    uint utilized = 0u;
    uvec3 p = gl_GlobalInvocationID * uvec3(2u);
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uint ccx = p.x + uint(ix);
                uint ccy = p.y + uint(iy);
                uint ccz = p.z + uint(iz);
                uint list_index = (ccx + (ccy * 256u)) + ((ccz * 256u) * 256u);
                ivec3 param = ivec3(p) + ivec3(ix, iy, iz);
                bool cell_used = rt_read_grid_marker_high_res(s_grid_marker, param);
                if (cell_used)
                {
                    utilized++;
                }
            }
        }
    }
    if (utilized == 0u)
    {
        return;
    }
    for (int iz_1 = 0; iz_1 < 2; iz_1++)
    {
        for (int iy_1 = 0; iy_1 < 2; iy_1++)
        {
            for (int ix_1 = 0; ix_1 < 2; ix_1++)
            {
                uint ccx_1 = p.x + uint(ix_1);
                uint ccy_1 = p.y + uint(iy_1);
                uint ccz_1 = p.z + uint(iz_1);
                uint list_index_1 = (ccx_1 + (ccy_1 * 256u)) + ((ccz_1 * 256u) * 256u);
                uint param_1 = list_index_1;
                uint count = rt_link_list_get_count(param_1);
                total += count;
            }
        }
    }
    uint _265 = atomicAdd(in_faces_list_data.buffer_counter, total + utilized);
    uint allocation = _265;
    for (int iz_2 = 0; iz_2 < 2; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 2; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 2; ix_2++)
            {
                uint ccx_2 = p.x + uint(ix_2);
                uint ccy_2 = p.y + uint(iy_2);
                uint ccz_2 = p.z + uint(iz_2);
                uint list_index_2 = (ccx_2 + (ccy_2 * 256u)) + ((ccz_2 * 256u) * 256u);
                uint param_2 = list_index_2;
                uint count_1 = rt_link_list_get_count(param_2);
                if (count_1 > 0u)
                {
                    _35.in_faces_list_tails_data[list_index_2] = allocation;
                    in_faces_list_data.node_buffer[allocation] = 0u;
                    allocation += (count_1 + 1u);
                }
            }
        }
    }
}

 