#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _109
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _100;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _118;

layout(location = 1) in _109 vtx_input;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void material_evaluate(MaterialPropertiesGPU material, MaterialEval eval, MaterialEvalInput eval_input)
{
    float factor = eval_input.modifier_factor;
    float y = eval_input.local_coords.y + eval_input.local_coords.x;
    y = fract(y * 40.09999847412109375);
}

void main()
{
    MaterialPropertiesGPU _107;
    _107.diffuse = materials.material_properties[_100.materialIndex].diffuse;
    _107.transparency = materials.material_properties[_100.materialIndex].transparency;
    _107.emissive = materials.material_properties[_100.materialIndex].emissive;
    _107.roughness = materials.material_properties[_100.materialIndex].roughness;
    _107.triplanar_factor = materials.material_properties[_100.materialIndex].triplanar_factor;
    _107.refraction = materials.material_properties[_100.materialIndex].refraction;
    _107.normal_factor = materials.material_properties[_100.materialIndex].normal_factor;
    _107.emissive_factor = materials.material_properties[_100.materialIndex].emissive_factor;
    _107.temporal_accumulation_factor = materials.material_properties[_100.materialIndex].temporal_accumulation_factor;
    _107.shadowmap_bias = materials.material_properties[_100.materialIndex].shadowmap_bias;
    _107.metalness = materials.material_properties[_100.materialIndex].metalness;
    _107.albedo_sampler = materials.material_properties[_100.materialIndex].albedo_sampler;
    _107.emissive_sampler = materials.material_properties[_100.materialIndex].emissive_sampler;
    _107.normal_sampler = materials.material_properties[_100.materialIndex].normal_sampler;
    _107.metalic_roughness_sampler = materials.material_properties[_100.materialIndex].metalic_roughness_sampler;
    _107.flags = materials.material_properties[_100.materialIndex].flags;
    _107._pad0 = materials.material_properties[_100.materialIndex]._pad0;
    _107._pad1 = materials.material_properties[_100.materialIndex]._pad1;
    MaterialPropertiesGPU material = _107;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _118.transform_params.vCameraPosition;
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _118.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _118.transform_params.mModelInv;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _100.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = 0.0;
    material_eval.metalness = 0.0;
    material_eval.is_discarded = false;
    material_eval.normal = vec3(0.0);
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    MaterialEvalInput eval_input;
    eval_input.uv0 = vtx_input.vUV0;
    eval_input.normal = vtx_input.vNorm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = material_eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate(param, param_1, param_2);
    material_eval = param_1;
    eval_input = param_2;
    if (material_eval.is_discarded)
    {
        discard;
    }
}

 