#version 450

struct PostprocessParams
{
    vec2 resolution;
    vec2 inv_resolution;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad2;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    PostprocessParams params;
} _32;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;

void main()
{
    outColor = texture(s_texture0, vTexcoord0);
    vec2 vTexcoord1 = vTexcoord0;
    vec2 vTexcoord2 = vTexcoord0;
    vec2 vTexcoord3 = vTexcoord0;
    if (_32.params.txt1_flip_y != 0)
    {
        vTexcoord1.y = 1.0 - vTexcoord1.y;
    }
    if (_32.params.txt2_flip_y != 0)
    {
        vTexcoord2.y = 1.0 - vTexcoord2.y;
    }
    if (_32.params.txt3_flip_y != 0)
    {
        vTexcoord3.y = 1.0 - vTexcoord3.y;
    }
    vec2 uv = vTexcoord1;
    uv *= (vec2(1.0) - uv.yx);
    float vig = (uv.x * uv.y) * _32.params.param1;
    vig = pow(vig, _32.params.param2);
    outColor *= vig;
}

 