#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    float min_face_size;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct InstanceModifierFactorToFlipbook_Params
{
    float scale;
    int num_cards;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _339;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _398;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _456;

layout(set = 0, binding = 11, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1564;

layout(set = 0, binding = 12, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistancePlane_Params VM0_params;
} _1812;

layout(set = 0, binding = 13, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1827;

layout(set = 0, binding = 14, std140) uniform VM2
{
    ModifierFactorRangeRemap_Params VM2_params;
} _1842;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1863;

layout(set = 0, binding = 15, std140) uniform VM3
{
    ModifierFactorClamp_Params VM3_params;
} _1916;

layout(set = 0, binding = 16, std140) uniform VM4
{
    InstanceModifierRandomizerV2_Params VM4_params;
} _1929;

layout(set = 0, binding = 17, std140) uniform VM5
{
    layout(row_major) ModifierFactorNoise_Params VM5_params;
} _1954;

layout(set = 0, binding = 18, std140) uniform VM6
{
    InstanceModifierRandomizerV2_Params VM6_params;
} _1967;

layout(set = 0, binding = 5, std430) buffer VM7
{
    InstanceModifierFactorToColor_Params VM7_params;
} _1984;

layout(set = 0, binding = 6, std430) buffer VM8
{
    InstanceModifierFactorToFlipbook_Params VM8_params;
} _2000;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2016;

layout(set = 0, binding = 8, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2039;

layout(set = 0, binding = 9, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2059;

layout(set = 0, binding = 10, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2067;

layout(set = 0, binding = 19) uniform sampler2D s_Curves;
layout(set = 0, binding = 20) uniform sampler2D s_Gradients;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _456.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _456.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _317 = hash(param);
    uint param_1 = _317;
    float _319 = floatConstruct(param_1);
    return _319;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _398.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _398.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _398.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_339.in_vtx_data[coord_offset + 0u], _339.in_vtx_data[coord_offset + 1u], _339.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_339.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    coords = vector_transform_by_mat43(param, param_1);
    if (modifier_params.influence_scope == 1)
    {
        vec3 param_2 = coords;
        mat4 param_3 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param_2, param_3);
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _290 = hash(param);
    uint param_1 = v.z;
    uint _295 = hash(param_1);
    uint param_2 = (v.x ^ _290) ^ _295;
    uint _298 = hash(param_2);
    return _298;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _327 = floatConstruct(param_1);
    return _327;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _1509 = instance.c;
        vec3 _1515 = mix(_1509.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _1515.x;
        instance.c.y = _1515.y;
        instance.c.z = _1515.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _1529 = instance.c;
        vec3 _1531 = _1529.xyz + c;
        instance.c.x = _1531.x;
        instance.c.y = _1531.y;
        instance.c.z = _1531.z;
    }
}

void instance_modifier_factor_to_flipbook(InstanceModifierFactorToFlipbook_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    float c = modifier_params.scale * modifier_factor.factor;
    uint card = uint(c) % uint(modifier_params.num_cards);
    instance.flipbook_card = card;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _1569;
    _1569.seed = _1564.instancing_generator_params.seed;
    _1569.transformed_data_location_idx = _1564.instancing_generator_params.transformed_data_location_idx;
    _1569.transformed_data_location_num = _1564.instancing_generator_params.transformed_data_location_num;
    _1569.surface_distance = _1564.instancing_generator_params.surface_distance;
    _1569.instance_scale = _1564.instancing_generator_params.instance_scale;
    _1569.alpha_to_modifier_factor = _1564.instancing_generator_params.alpha_to_modifier_factor;
    _1569.min_face_size = _1564.instancing_generator_params.min_face_size;
    InstancingGeneratorParams param = _1569;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _1575;
    _1575.seed = _1564.instancing_generator_params.seed;
    _1575.transformed_data_location_idx = _1564.instancing_generator_params.transformed_data_location_idx;
    _1575.transformed_data_location_num = _1564.instancing_generator_params.transformed_data_location_num;
    _1575.surface_distance = _1564.instancing_generator_params.surface_distance;
    _1575.instance_scale = _1564.instancing_generator_params.instance_scale;
    _1575.alpha_to_modifier_factor = _1564.instancing_generator_params.alpha_to_modifier_factor;
    _1575.min_face_size = _1564.instancing_generator_params.min_face_size;
    InstancingGeneratorParams param_1 = _1575;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _1564.instancing_generator_params.min_face_size;
    vec3 bc;
    float _1786;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    for (int i = 0; i < 4; i++)
    {
        float fid = float(id);
        float fid_seed = (((fid * 0.0131700001657009124755859375) + float(_1564.instancing_generator_params.seed)) + float(i)) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_2));
        face_idx += first_face_idx;
        uint param_3 = face_idx;
        RTFace rt_face = rt_get_face(param_3);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_4 = p0_idx;
        vec3 p0 = rt_get_vertex(param_4);
        uint param_5 = p1_idx;
        vec3 p1 = rt_get_vertex(param_5);
        uint param_6 = p2_idx;
        vec3 p2 = rt_get_vertex(param_6);
        float face_size = length(cross(p0 - p1, p0 - p2));
        if (face_size < face_min_size_threshold)
        {
            continue;
        }
        uint param_7 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_7);
        uint param_8 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_8);
        uint param_9 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_9);
        float param_10 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_10);
        float param_11 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_11);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        vec3 nx = normalize(p0 - p2);
        vec3 ny = normalize(p0 - p1);
        vec3 nz = normalize(cross(nx, ny));
        ny = cross(nz, nx);
        pos -= (nz * _1564.instancing_generator_params.surface_distance);
        nx *= _1564.instancing_generator_params.instance_scale.x;
        ny *= _1564.instancing_generator_params.instance_scale.y;
        nz *= _1564.instancing_generator_params.instance_scale.z;
        ModifierFactor modifier_factor = modifier_factor_defaults();
        if (_1564.instancing_generator_params.alpha_to_modifier_factor != 0)
        {
            _1786 = col.w;
        }
        else
        {
            _1786 = 1.0;
        }
        modifier_factor.factor = _1786;
        modifier_factor.hash = floatBitsToUint(fid_seed);
        modifier_factor.id = id;
        modifier_factor.position = pos;
        modifier_factor.is_spawned = true;
        cs_transforms.mat_local_to_model = mat_identity();
        cs_transforms.mat_local_to_instance = mat_identity();
        cs_transforms.mat_local_to_model_inv = mat_identity();
        ModifierFactorDistancePlane_Params _1817;
        _1817.transform_local_to_gizmo = _1812.VM0_params.transform_local_to_gizmo;
        _1817.falloff_curve_idx = _1812.VM0_params.falloff_curve_idx;
        _1817.falloff_inverse = _1812.VM0_params.falloff_inverse;
        _1817.domain_mirror = _1812.VM0_params.domain_mirror;
        _1817.domain_repeat = _1812.VM0_params.domain_repeat;
        _1817.influence_scope = _1812.VM0_params.influence_scope;
        _1817.modifier_function = _1812.VM0_params.modifier_function;
        ModifierFactorDistancePlane_Params param_12 = _1817;
        ModifierFactor param_13 = modifier_factor;
        CoordinateSystemTrasforms param_14 = cs_transforms;
        modifier_factor_distance_plane(param_12, param_13, param_14);
        modifier_factor = param_13;
        ModifierFactorNoise_Params _1832;
        _1832.transform_local_to_gizmo = _1827.VM1_params.transform_local_to_gizmo;
        _1832.noise_domain_scale = _1827.VM1_params.noise_domain_scale;
        _1832.modifier_function = _1827.VM1_params.modifier_function;
        _1832.noise_domain_offset = _1827.VM1_params.noise_domain_offset;
        _1832.noise_value_scale = _1827.VM1_params.noise_value_scale;
        _1832.noise_value_offset = _1827.VM1_params.noise_value_offset;
        _1832.influence_scope = _1827.VM1_params.influence_scope;
        _1832._pad0 = _1827.VM1_params._pad0;
        _1832._pad1 = _1827.VM1_params._pad1;
        ModifierFactorNoise_Params param_15 = _1832;
        ModifierFactor param_16 = modifier_factor;
        CoordinateSystemTrasforms param_17 = cs_transforms;
        modifier_factor_noise(param_15, param_16, param_17);
        modifier_factor = param_16;
        ModifierFactorRangeRemap_Params _1847;
        _1847.input_min = _1842.VM2_params.input_min;
        _1847.input_max = _1842.VM2_params.input_max;
        _1847.output_min = _1842.VM2_params.output_min;
        _1847.output_max = _1842.VM2_params.output_max;
        _1847.min_out_of_bounds_mode = _1842.VM2_params.min_out_of_bounds_mode;
        _1847.max_out_of_bounds_mode = _1842.VM2_params.max_out_of_bounds_mode;
        ModifierFactorRangeRemap_Params param_18 = _1847;
        ModifierFactor param_19 = modifier_factor;
        modifier_factor_range_remap(param_18, param_19);
        modifier_factor = param_19;
        if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
        {
            continue;
        }
        int _1866 = atomicAdd(_1863.instance_params.instance_count, 1);
        uint instance_id = uint(_1866);
        if (instance_id >= uint(_1863.instance_params.buffer_capacity))
        {
            return;
        }
        instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
        instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
        instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
        instance.hash = modifier_factor.hash;
        instance.c = vec4(1.0);
        instance.flipbook_card = 0u;
        ModifierFactorClamp_Params _1921;
        _1921.clamp_min = _1916.VM3_params.clamp_min;
        _1921.clamp_max = _1916.VM3_params.clamp_max;
        _1921.clamp_min_enable = _1916.VM3_params.clamp_min_enable;
        _1921.clamp_max_enable = _1916.VM3_params.clamp_max_enable;
        ModifierFactorClamp_Params param_20 = _1921;
        ModifierFactor param_21 = modifier_factor;
        modifier_factor_clamp(param_20, param_21);
        modifier_factor = param_21;
        InstanceModifierRandomizerV2_Params _1934;
        _1934.replace_previous_rotation_scale = _1929.VM4_params.replace_previous_rotation_scale;
        _1934.randomness_seed = _1929.VM4_params.randomness_seed;
        _1934.replace_previous_position = _1929.VM4_params.replace_previous_position;
        _1934.randomization_input = _1929.VM4_params.randomization_input;
        _1934.position_modifier_base = _1929.VM4_params.position_modifier_base;
        _1934.position_modifier_base_modifier_factor = _1929.VM4_params.position_modifier_base_modifier_factor;
        _1934.position_modifier_range = _1929.VM4_params.position_modifier_range;
        _1934.position_modifier_range_modifier_factor = _1929.VM4_params.position_modifier_range_modifier_factor;
        _1934.rotation_modifier_base = _1929.VM4_params.rotation_modifier_base;
        _1934.rotation_modifier_base_modifier_factor = _1929.VM4_params.rotation_modifier_base_modifier_factor;
        _1934.rotation_modifier_range = _1929.VM4_params.rotation_modifier_range;
        _1934.rotation_modifier_range_modifier_factor = _1929.VM4_params.rotation_modifier_range_modifier_factor;
        _1934.scale_modifier_base = _1929.VM4_params.scale_modifier_base;
        _1934.scale_modifier_base_modifier_factor = _1929.VM4_params.scale_modifier_base_modifier_factor;
        _1934.scale_modifier_range = _1929.VM4_params.scale_modifier_range;
        _1934.scale_modifier_range_modifier_factor = _1929.VM4_params.scale_modifier_range_modifier_factor;
        InstanceModifierRandomizerV2_Params param_22 = _1934;
        ModifierFactor param_23 = modifier_factor;
        Instance param_24 = instance;
        uint param_25 = id;
        instance_modifier_randomizer_v2(param_22, param_23, param_24, param_25);
        modifier_factor = param_23;
        instance = param_24;
        modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        ModifierFactorNoise_Params _1958;
        _1958.transform_local_to_gizmo = _1954.VM5_params.transform_local_to_gizmo;
        _1958.noise_domain_scale = _1954.VM5_params.noise_domain_scale;
        _1958.modifier_function = _1954.VM5_params.modifier_function;
        _1958.noise_domain_offset = _1954.VM5_params.noise_domain_offset;
        _1958.noise_value_scale = _1954.VM5_params.noise_value_scale;
        _1958.noise_value_offset = _1954.VM5_params.noise_value_offset;
        _1958.influence_scope = _1954.VM5_params.influence_scope;
        _1958._pad0 = _1954.VM5_params._pad0;
        _1958._pad1 = _1954.VM5_params._pad1;
        ModifierFactorNoise_Params param_26 = _1958;
        ModifierFactor param_27 = modifier_factor;
        CoordinateSystemTrasforms param_28 = cs_transforms;
        modifier_factor_noise(param_26, param_27, param_28);
        modifier_factor = param_27;
        InstanceModifierRandomizerV2_Params _1971;
        _1971.replace_previous_rotation_scale = _1967.VM6_params.replace_previous_rotation_scale;
        _1971.randomness_seed = _1967.VM6_params.randomness_seed;
        _1971.replace_previous_position = _1967.VM6_params.replace_previous_position;
        _1971.randomization_input = _1967.VM6_params.randomization_input;
        _1971.position_modifier_base = _1967.VM6_params.position_modifier_base;
        _1971.position_modifier_base_modifier_factor = _1967.VM6_params.position_modifier_base_modifier_factor;
        _1971.position_modifier_range = _1967.VM6_params.position_modifier_range;
        _1971.position_modifier_range_modifier_factor = _1967.VM6_params.position_modifier_range_modifier_factor;
        _1971.rotation_modifier_base = _1967.VM6_params.rotation_modifier_base;
        _1971.rotation_modifier_base_modifier_factor = _1967.VM6_params.rotation_modifier_base_modifier_factor;
        _1971.rotation_modifier_range = _1967.VM6_params.rotation_modifier_range;
        _1971.rotation_modifier_range_modifier_factor = _1967.VM6_params.rotation_modifier_range_modifier_factor;
        _1971.scale_modifier_base = _1967.VM6_params.scale_modifier_base;
        _1971.scale_modifier_base_modifier_factor = _1967.VM6_params.scale_modifier_base_modifier_factor;
        _1971.scale_modifier_range = _1967.VM6_params.scale_modifier_range;
        _1971.scale_modifier_range_modifier_factor = _1967.VM6_params.scale_modifier_range_modifier_factor;
        InstanceModifierRandomizerV2_Params param_29 = _1971;
        ModifierFactor param_30 = modifier_factor;
        Instance param_31 = instance;
        uint param_32 = id;
        instance_modifier_randomizer_v2(param_29, param_30, param_31, param_32);
        modifier_factor = param_30;
        instance = param_31;
        InstanceModifierFactorToColor_Params _1989;
        _1989.color = _1984.VM7_params.color;
        _1989.use_gradient = _1984.VM7_params.use_gradient;
        _1989.color_gradient_idx = _1984.VM7_params.color_gradient_idx;
        _1989.mixing_mode = _1984.VM7_params.mixing_mode;
        InstanceModifierFactorToColor_Params param_33 = _1989;
        ModifierFactor param_34 = modifier_factor;
        Instance param_35 = instance;
        instance_modifier_factor_to_color(param_33, param_34, param_35);
        modifier_factor = param_34;
        instance = param_35;
        InstanceModifierFactorToFlipbook_Params _2005;
        _2005.scale = _2000.VM8_params.scale;
        _2005.num_cards = _2000.VM8_params.num_cards;
        InstanceModifierFactorToFlipbook_Params param_36 = _2005;
        ModifierFactor param_37 = modifier_factor;
        Instance param_38 = instance;
        instance_modifier_factor_to_flipbook(param_36, param_37, param_38);
        modifier_factor = param_37;
        instance = param_38;
        _2016.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
        _2016.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
        _2016.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
        _2039.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
        _2039.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
        _2059.instance_hash[instance_id] = instance.hash;
        _2067.instance_flipbook_card[instance_id] = instance.flipbook_card;
        return;
    }
}

 