#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _1237
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1359;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1373;

layout(set = 1, binding = 4, std140) uniform VM1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM1_params;
} _1706;

layout(set = 1, binding = 5, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _1721;

layout(set = 1, binding = 6, std140) uniform VM3
{
    ModifierFactorQuantizePosition_Params VM3_params;
} _1734;

layout(set = 1, binding = 7, std140) uniform VM4
{
    layout(row_major) ModifierFactorNoise_Params VM4_params;
} _1749;

layout(set = 1, binding = 8) uniform sampler2D s_Curves;
layout(set = 1, binding = 9) uniform sampler2D material_textures[64];

layout(location = 1) in _1237 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _1213 = material.albedo_sampler >= 0;
    bool _1220;
    if (_1213)
    {
        _1220 = material.albedo_sampler < 16;
    }
    else
    {
        _1220 = _1213;
    }
    if (_1220)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _1263 = material.emissive_sampler >= 0;
    bool _1269;
    if (_1263)
    {
        _1269 = material.emissive_sampler < 16;
    }
    else
    {
        _1269 = _1263;
    }
    if (_1269)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
    bool _1304 = material.metalic_roughness_sampler >= 0;
    bool _1310;
    if (_1304)
    {
        _1310 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _1310 = _1304;
    }
    if (_1310)
    {
        vec2 metalic_roughness = vec2(1.0);
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_6 = vtx_input.vLocalPos;
            vec3 param_7 = norm;
            vec3 param_8 = material.triplanar_factor;
            metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_6, param_7, param_8).xy;
        }
        else
        {
            metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).xy;
        }
        material_eval.metalness_texture = clamp(metalic_roughness.x, 0.0, 1.0);
        material_eval.roughness_texture = clamp(metalic_roughness.y, 0.0, 1.0);
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
    if (eval_input.modifier_factor < 0.100000001490116119384765625)
    {
        eval.is_discarded = true;
    }
    float r = length(eval_input.world_coords);
    float f = fract(r * 0.100000001490116119384765625);
    if (f > 0.5)
    {
        eval.flag_overrides = 3u;
    }
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _273 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _273.x;
    o.y = _273.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _1366;
    _1366.diffuse = materials.material_properties[_1359.materialIndex].diffuse;
    _1366.transparency = materials.material_properties[_1359.materialIndex].transparency;
    _1366.emissive = materials.material_properties[_1359.materialIndex].emissive;
    _1366.roughness = materials.material_properties[_1359.materialIndex].roughness;
    _1366.triplanar_factor = materials.material_properties[_1359.materialIndex].triplanar_factor;
    _1366.refraction = materials.material_properties[_1359.materialIndex].refraction;
    _1366.normal_factor = materials.material_properties[_1359.materialIndex].normal_factor;
    _1366.emissive_factor = materials.material_properties[_1359.materialIndex].emissive_factor;
    _1366.temporal_accumulation_factor = materials.material_properties[_1359.materialIndex].temporal_accumulation_factor;
    _1366.shadowmap_bias = materials.material_properties[_1359.materialIndex].shadowmap_bias;
    _1366.metalness = materials.material_properties[_1359.materialIndex].metalness;
    _1366.albedo_sampler = materials.material_properties[_1359.materialIndex].albedo_sampler;
    _1366.emissive_sampler = materials.material_properties[_1359.materialIndex].emissive_sampler;
    _1366.normal_sampler = materials.material_properties[_1359.materialIndex].normal_sampler;
    _1366.metalic_roughness_sampler = materials.material_properties[_1359.materialIndex].metalic_roughness_sampler;
    _1366.flags = materials.material_properties[_1359.materialIndex].flags;
    _1366._pad0 = materials.material_properties[_1359.materialIndex]._pad0;
    _1366._pad1 = materials.material_properties[_1359.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1366;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _1373.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _1476 = material.normal_sampler >= 0;
    bool _1482;
    if (_1476)
    {
        _1482 = material.normal_sampler < 16;
    }
    else
    {
        _1482 = _1476;
    }
    if (_1482)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdxFine(worldPos);
            vec3 pos_dy = dFdyFine(worldPos);
            vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = mix(normal, n, vec3(material.normal_factor));
                n = normalize(n * transpose(tbn));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _1373.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat33(param_14, param_15);
            mat4 m = _1373.transform_params.mModelNormal;
            vec3 scale;
            scale.x = length(vec3(m[0].x, m[0].y, m[0].z));
            scale.y = length(vec3(m[1].x, m[1].y, m[1].z));
            scale.z = length(vec3(m[2].x, m[2].y, m[2].z));
            n_1 *= (vec3(1.0) / scale);
            n_1 = normalize(n_1);
            n_1 = normalize(mix(normal, n_1, vec3(material.normal_factor)));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_16 = normal;
    int param_17 = _1359.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1373.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1373.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _1711;
    _1711.transform_local_to_gizmo = _1706.VM1_params.transform_local_to_gizmo;
    _1711.falloff_curve_idx = _1706.VM1_params.falloff_curve_idx;
    _1711.falloff_inverse = _1706.VM1_params.falloff_inverse;
    _1711.domain_repeat_x = _1706.VM1_params.domain_repeat_x;
    _1711.domain_repeat_y = _1706.VM1_params.domain_repeat_y;
    _1711.domain_repeat_z = _1706.VM1_params.domain_repeat_z;
    _1711.influence_scope = _1706.VM1_params.influence_scope;
    _1711.modifier_function = _1706.VM1_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_18 = _1711;
    ModifierFactor param_19 = modifier_factor;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_distance_radial(param_18, param_19, param_20);
    modifier_factor = param_19;
    ModifierFactorMulAdd_Params _1726;
    _1726.multiply_value = _1721.VM2_params.multiply_value;
    _1726.add_value = _1721.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_21 = _1726;
    ModifierFactor param_22 = modifier_factor;
    modifier_factor_mul_add(param_21, param_22);
    modifier_factor = param_22;
    ModifierFactorQuantizePosition_Params _1739;
    _1739.quantization_step = _1734.VM3_params.quantization_step;
    _1739._pad0 = _1734.VM3_params._pad0;
    _1739.offset = _1734.VM3_params.offset;
    _1739.quantize_x = _1734.VM3_params.quantize_x;
    _1739.quantize_y = _1734.VM3_params.quantize_y;
    _1739.quantize_z = _1734.VM3_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_23 = _1739;
    ModifierFactor param_24 = modifier_factor;
    CoordinateSystemTrasforms param_25 = cs_transforms;
    modifier_factor_quantize_position(param_23, param_24, param_25);
    modifier_factor = param_24;
    ModifierFactorNoise_Params _1754;
    _1754.transform_local_to_gizmo = _1749.VM4_params.transform_local_to_gizmo;
    _1754.noise_domain_scale = _1749.VM4_params.noise_domain_scale;
    _1754.modifier_function = _1749.VM4_params.modifier_function;
    _1754.noise_domain_offset = _1749.VM4_params.noise_domain_offset;
    _1754.noise_value_scale = _1749.VM4_params.noise_value_scale;
    _1754.noise_value_offset = _1749.VM4_params.noise_value_offset;
    _1754.influence_scope = _1749.VM4_params.influence_scope;
    _1754._pad0 = _1749.VM4_params._pad0;
    _1754._pad1 = _1749.VM4_params._pad1;
    ModifierFactorNoise_Params param_26 = _1754;
    ModifierFactor param_27 = modifier_factor;
    CoordinateSystemTrasforms param_28 = cs_transforms;
    modifier_factor_noise(param_26, param_27, param_28);
    modifier_factor = param_27;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _1359.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_29 = material;
    MaterialEval param_30 = material_eval;
    MaterialEvalInput param_31 = eval_input;
    material_evaluate(param_29, param_30, param_31);
    material_eval = param_30;
    eval_input = param_31;
    if ((material_eval.flag_overrides & 2u) != 0u)
    {
        material_flag_overrides = material_eval.flag_overrides;
    }
    if (material_eval.is_discarded)
    {
        discard;
    }
    outAlbedo = material_eval.albedo * material_eval.albedo_texture;
    vec3 _1847 = material_eval.emissive * material_eval.emissive_texture;
    outEmissive.x = _1847.x;
    outEmissive.y = _1847.y;
    outEmissive.z = _1847.z;
    outEmissive.w = 0.0;
    float roughness = material_eval.roughness * material_eval.roughness_texture;
    float metalness = material_eval.metalness * material_eval.metalness_texture;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_1359.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_1359.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_32 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_32);
}

 