#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct VXFogParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    float scattering_factor;
    float sampling_mip;
    float trace_step;
    int filter_step;
    vec3 noise_offset;
    float _pad0;
    vec3 tint_color;
    float noise_base;
    float noise_strength;
    float accumulation_factor;
};

const uvec2 _550[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _150;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std140) uniform VoxelFogParams
{
    VXFogParams voxel_lighting_setup;
} _367;

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _682;

layout(set = 0, binding = 8) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 5, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 11) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 6, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 13) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 14) uniform sampler2D sTargetPrevious;
layout(set = 0, binding = 7, rgba16f) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

float linearizeDepth(float d)
{
    return _150.dispatch_setup.near_far_plane.z / ((_150.dispatch_setup.near_far_plane.y + _150.dispatch_setup.near_far_plane.x) - (d * _150.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_150.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

float noise_fast(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return (mix(rg.x, rg.y, f.z) * 2.0) - 1.0;
}

vec4 evaluate_fog(vec3 ro, vec3 rd, inout float t, float max_t, vec2 hash, int frame, vec3 noise_offset)
{
    vec3 grid_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 grid_size = in_bbox_data.grid_size_voxelize.xyz;
    int grid_res = 256;
    vec4 occlusion = vec4(0.0);
    vec3 ird;
    for (int i = 0; i < 16; i++)
    {
        vec3 p = ro + (rd * t);
        float noise_scale = 2.0;
        vec3 noise_p = (p + noise_offset) * noise_scale;
        vec3 param = noise_p * 0.0024999999441206455230712890625;
        float n1 = 0.5 + noise_fast(param);
        vec3 param_1 = ((noise_p * 0.0024999999441206455230712890625) * 0.5) + vec3(0.1240999996662139892578125);
        float n2 = 0.5 + noise_fast(param_1);
        vec3 param_2 = ((noise_p * 0.0024999999441206455230712890625) * 0.25) + vec3(0.1240999996662139892578125);
        float n3 = 0.5 + noise_fast(param_2);
        vec2 _334 = (fract((hash + vec2(1.61803400516510009765625 * float(i))) + vec2(float(frame))) * 2.0) - vec2(1.0);
        ird.x = _334.x;
        ird.y = _334.y;
        ird.z = (1.0 - ird.x) - ird.y;
        ird = normalize(ird);
        vec4 r_occlusion = vec4(0.0);
        for (int j = 0; j < 2; j++)
        {
            vec3 ip = p + (((ird * (float(j) + (hash.x * _367.voxel_lighting_setup.scattering_factor))) * _367.voxel_lighting_setup.scattering_factor) * 0.5);
            vec3 grid_p = (ip - grid_origin) / grid_size;
            vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
            bool _396 = all(greaterThanEqual(sample_p, vec3(0.0)));
            bool _403;
            if (_396)
            {
                _403 = all(lessThan(sample_p, vec3(1.0)));
            }
            else
            {
                _403 = _396;
            }
            if (_403)
            {
                float go = textureLod(s_voxel_occupancy_filtered, sample_p, _367.voxel_lighting_setup.sampling_mip).x;
                vec3 gc = textureLod(s_voxel_colors_filtered, sample_p, _367.voxel_lighting_setup.sampling_mip).xyz;
                r_occlusion.w += (go * 0.5);
                vec4 _436 = r_occlusion;
                vec3 _438 = _436.xyz + (gc * (1.0 - go));
                r_occlusion.x = _438.x;
                r_occlusion.y = _438.y;
                r_occlusion.z = _438.z;
            }
        }
        float f = _367.voxel_lighting_setup.noise_base + (_367.voxel_lighting_setup.noise_strength * (((n1 * 0.100000001490116119384765625) + ((n2 * 0.100000001490116119384765625) * 0.25)) + (n3 * 0.120999999344348907470703125)));
        occlusion += ((r_occlusion * f) * 10.0);
        occlusion += (vec4(_367.voxel_lighting_setup.tint_color, 1.0) * ((f * 0.100000001490116119384765625) * _367.voxel_lighting_setup.noise_strength));
        t += _367.voxel_lighting_setup.trace_step;
        if (t >= max_t)
        {
            break;
        }
    }
    return occlusion;
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_150.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec3 view_direction;
    float param_7;
    float param_8;
    uint param_9;
    vec3 view_direction_prev;
    for (int i = 0; i < 4; i++)
    {
        ivec2 pos = ivec2((pixel_pos * uvec2(2u)) + _550[i]);
        ivec2 noise_pos = pos & ivec2(127);
        uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
        uint param = encoded_normal_material;
        int materialId = decode_material(param);
        bool is_background = (materialId & 1) == 1;
        if (is_background)
        {
        }
        view_direction.x = (-_150.dispatch_setup.camera_projection_params.z) + ((_150.dispatch_setup.camera_projection_params.x * float(pos.x)) * _150.dispatch_setup.inv_resolution.x);
        view_direction.y = (-_150.dispatch_setup.camera_projection_params.w) + ((_150.dispatch_setup.camera_projection_params.y * float(pos.y)) * _150.dispatch_setup.inv_resolution.y);
        view_direction.z = 1.0;
        view_direction.y = -view_direction.y;
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
        uint param_1 = encoded_normal_material_1;
        vec3 vNorm = decode_normal(param_1);
        uint param_2 = encoded_normal_material_1;
        int materialId_1 = decode_material(param_2);
        float param_3 = texelFetch(sTextureDepth, pos, 0).x;
        float depth = linearizeDepth(param_3);
        vec3 param_4 = view_direction;
        float param_5 = depth;
        vec3 world = positionFromDepth(param_4, param_5);
        uvec2 param_6 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
        decode_metalness_roughness_material(param_6, param_7, param_8, param_9);
        float metalness = param_7;
        float roughness = param_8;
        uint material = param_9;
        vec3 dir = world - _150.dispatch_setup.camera_position;
        float max_t = length(dir);
        dir /= vec3(max_t);
        int frame = _682.globals.monotonic;
        vec2 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, frame & 15), 0).xy;
        vec3 ro = _150.dispatch_setup.camera_position;
        vec3 rd = dir;
        float t1 = 0.0 + ((fract(0.5 + (hash.x * 2.0)) * _367.voxel_lighting_setup.trace_step) * 3.0);
        float t2 = 0.0 + ((fract(0.5 + (hash.y * 2.0)) * _367.voxel_lighting_setup.trace_step) * 3.0);
        vec3 param_10 = ro;
        vec3 param_11 = rd;
        float param_12 = t1;
        float param_13 = max_t;
        vec2 param_14 = hash;
        int param_15 = frame;
        vec3 param_16 = _367.voxel_lighting_setup.noise_offset;
        vec4 _747 = evaluate_fog(param_10, param_11, param_12, param_13, param_14, param_15, param_16);
        vec4 occlusion = _747;
        if (true)
        {
            vec4 view_prev = vec4(world, 1.0);
            view_prev = _150.dispatch_setup.mat_view_previous * view_prev;
            view_prev = _150.dispatch_setup.mat_projection * view_prev;
            vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
            proj_prev.y = 1.0 - proj_prev.y;
            vec2 screen_prev = proj_prev.xy;
            bool _784 = screen_prev.x >= 0.0;
            bool _790;
            if (_784)
            {
                _790 = screen_prev.y >= 0.0;
            }
            else
            {
                _790 = _784;
            }
            bool _796;
            if (_790)
            {
                _796 = screen_prev.x < 1.0;
            }
            else
            {
                _796 = _790;
            }
            bool _802;
            if (_796)
            {
                _802 = screen_prev.y < 1.0;
            }
            else
            {
                _802 = _796;
            }
            if (_802)
            {
                view_direction_prev.x = (-_150.dispatch_setup.camera_projection_params.z) + (_150.dispatch_setup.camera_projection_params.x * screen_prev.x);
                view_direction_prev.y = (-_150.dispatch_setup.camera_projection_params.w) + (_150.dispatch_setup.camera_projection_params.y * screen_prev.y);
                view_direction_prev.z = 1.0;
                view_direction_prev.y = -view_direction_prev.y;
                float param_17 = texelFetch(sTextureDepthPrevious, ivec2((proj_prev.xy * _150.dispatch_setup.resolution) + vec2(0.5)), 0).x;
                float depth_prev = linearizeDepth(param_17);
                vec3 param_18 = view_direction_prev;
                float param_19 = depth_prev;
                vec3 world_prev = positionFromDepthPrevious(param_18, param_19);
                float tolerance = _367.voxel_lighting_setup.reprojection_tolerance;
                if ((length(world - world_prev) <= tolerance) || is_background)
                {
                    vec4 occlusion_prev = textureLod(sTargetPrevious, proj_prev.xy + (_150.dispatch_setup.inv_resolution * 0.5), 0.0);
                    float f = 0.0;
                    occlusion = mix(occlusion_prev, occlusion, vec4(_367.voxel_lighting_setup.accumulation_factor));
                }
                else
                {
                    int additional_samples = 2;
                    for (int nfi = 0; nfi < additional_samples; nfi++)
                    {
                        frame++;
                        vec2 hash_1 = fract(texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xy + vec2(float(frame) * 1.61803400516510009765625));
                        float t = 0.0 + ((hash_1.y * _367.voxel_lighting_setup.trace_step) * 3.0);
                        vec3 param_20 = ro;
                        vec3 param_21 = rd;
                        float param_22 = t;
                        float param_23 = max_t;
                        vec2 param_24 = hash_1;
                        int param_25 = frame;
                        vec3 param_26 = _367.voxel_lighting_setup.noise_offset;
                        vec4 _936 = evaluate_fog(param_20, param_21, param_22, param_23, param_24, param_25, param_26);
                        occlusion += _936;
                    }
                    occlusion /= vec4(float(1 + additional_samples));
                    occlusion.w = clamp(occlusion.w, 0.0, 1.0);
                }
            }
        }
        if (false)
        {
            vec3 hash_2 = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
            occlusion.x = hash_2.x;
            occlusion.y = hash_2.y;
            occlusion.z = hash_2.z;
            occlusion.w = hash_2.x;
        }
        imageStore(imTarget, pos, clamp(occlusion, vec4(0.0), vec4(1.0)));
    }
}

 