#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1190;

layout(set = 0, binding = 7, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1207;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 8, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _1422;

layout(set = 0, binding = 9, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1437;

layout(set = 0, binding = 10, std140) uniform VM2
{
    InstanceModifierRandomizerV2_Params VM2_params;
} _1497;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1553;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1575;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1596;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1604;

layout(set = 0, binding = 11) uniform sampler2D s_Curves;
layout(set = 0, binding = 12) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 13) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _117 = v;
    float _121 = v.w;
    vec3 _124 = (_117.xyz * _121) * 128.0;
    v.x = _124.x;
    v.y = _124.y;
    v.z = _124.z;
    return v.xyz * v.xyz;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _257 = hash(param);
    uint param_1 = v.z;
    uint _262 = hash(param_1);
    uint param_2 = (v.x ^ _257) ^ _262;
    uint _265 = hash(param_2);
    return _265;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _294 = floatConstruct(param_1);
    return _294;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _284 = hash(param);
    uint param_1 = _284;
    float _286 = floatConstruct(param_1);
    return _286;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_1190.instance_params.instance_count >= _1190.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_1207.instancing_generator_params.resolution.x * _1207.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_1207.instancing_generator_params.resolution.x * _1207.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _1207.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _1207.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_1207.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _1207.instancing_generator_params.bbox_position;
        instancing_bbox_size = _1207.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_1207.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _1293 = source_voxel_position.x < 0.0;
    bool _1300;
    if (!_1293)
    {
        _1300 = source_voxel_position.y < 0.0;
    }
    else
    {
        _1300 = _1293;
    }
    bool _1307;
    if (!_1300)
    {
        _1307 = source_voxel_position.z < 0.0;
    }
    else
    {
        _1307 = _1300;
    }
    bool _1314;
    if (!_1307)
    {
        _1314 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _1314 = _1307;
    }
    bool _1321;
    if (!_1314)
    {
        _1321 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _1321 = _1314;
    }
    bool _1328;
    if (!_1321)
    {
        _1328 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _1328 = _1321;
    }
    if (_1328)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _1207.instancing_generator_params.color_lod);
    vec3 _1344 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _1344;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _1207.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _1207.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    voxel_occupancy -= _1207.instancing_generator_params.occupancy_threshold;
    vec3 instance_scale = _1207.instancing_generator_params.instance_scale_base + (_1207.instancing_generator_params.instance_scale_factor * (0.25 + (0.75 * voxel_occupancy)));
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorDistanceRadial_Params _1427;
    _1427.transform_local_to_gizmo = _1422.VM0_params.transform_local_to_gizmo;
    _1427.falloff_curve_idx = _1422.VM0_params.falloff_curve_idx;
    _1427.falloff_inverse = _1422.VM0_params.falloff_inverse;
    _1427.domain_repeat_x = _1422.VM0_params.domain_repeat_x;
    _1427.domain_repeat_y = _1422.VM0_params.domain_repeat_y;
    _1427.domain_repeat_z = _1422.VM0_params.domain_repeat_z;
    _1427.influence_scope = _1422.VM0_params.influence_scope;
    _1427.modifier_function = _1422.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_1 = _1427;
    ModifierFactor param_2 = modifier_factor;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    modifier_factor_distance_radial(param_1, param_2, param_3);
    modifier_factor = param_2;
    ModifierFactorNoise_Params _1442;
    _1442.transform_local_to_gizmo = _1437.VM1_params.transform_local_to_gizmo;
    _1442.noise_domain_scale = _1437.VM1_params.noise_domain_scale;
    _1442.modifier_function = _1437.VM1_params.modifier_function;
    _1442.noise_domain_offset = _1437.VM1_params.noise_domain_offset;
    _1442.noise_value_scale = _1437.VM1_params.noise_value_scale;
    _1442.noise_value_offset = _1437.VM1_params.noise_value_offset;
    _1442.influence_scope = _1437.VM1_params.influence_scope;
    _1442._pad0 = _1437.VM1_params._pad0;
    _1442._pad1 = _1437.VM1_params._pad1;
    ModifierFactorNoise_Params param_4 = _1442;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_noise(param_4, param_5, param_6);
    modifier_factor = param_5;
    if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
    {
        return;
    }
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(voxel_color, 1.0);
    instance.flipbook_card = 0u;
    InstanceModifierRandomizerV2_Params _1502;
    _1502.replace_previous_rotation_scale = _1497.VM2_params.replace_previous_rotation_scale;
    _1502.randomness_seed = _1497.VM2_params.randomness_seed;
    _1502.replace_previous_position = _1497.VM2_params.replace_previous_position;
    _1502.randomization_input = _1497.VM2_params.randomization_input;
    _1502.position_modifier_base = _1497.VM2_params.position_modifier_base;
    _1502.position_modifier_base_modifier_factor = _1497.VM2_params.position_modifier_base_modifier_factor;
    _1502.position_modifier_range = _1497.VM2_params.position_modifier_range;
    _1502.position_modifier_range_modifier_factor = _1497.VM2_params.position_modifier_range_modifier_factor;
    _1502.rotation_modifier_base = _1497.VM2_params.rotation_modifier_base;
    _1502.rotation_modifier_base_modifier_factor = _1497.VM2_params.rotation_modifier_base_modifier_factor;
    _1502.rotation_modifier_range = _1497.VM2_params.rotation_modifier_range;
    _1502.rotation_modifier_range_modifier_factor = _1497.VM2_params.rotation_modifier_range_modifier_factor;
    _1502.scale_modifier_base = _1497.VM2_params.scale_modifier_base;
    _1502.scale_modifier_base_modifier_factor = _1497.VM2_params.scale_modifier_base_modifier_factor;
    _1502.scale_modifier_range = _1497.VM2_params.scale_modifier_range;
    _1502.scale_modifier_range_modifier_factor = _1497.VM2_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_7 = _1502;
    ModifierFactor param_8 = modifier_factor;
    Instance param_9 = instance;
    uint param_10 = id;
    instance_modifier_randomizer_v2(param_7, param_8, param_9, param_10);
    modifier_factor = param_8;
    instance = param_9;
    bool _1516 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _1525;
    if (!_1516)
    {
        _1525 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1525 = _1516;
    }
    bool _1534;
    if (!_1525)
    {
        _1534 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1534 = _1525;
    }
    if (_1534)
    {
        return;
    }
    int _1540 = atomicAdd(_1190.instance_params.instance_count, 1);
    uint instance_id = uint(_1540);
    if (instance_id >= uint(_1190.instance_params.buffer_capacity))
    {
        return;
    }
    _1553.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _1553.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _1553.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _1575.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1575.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1596.instance_hash[instance_id] = instance.hash;
    _1604.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 