#version 450

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct _282
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 8, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _186;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _198;

layout(set = 0, binding = 9, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _210;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _298;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _379;

layout(set = 0, binding = 10, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _420;

layout(location = 1) out _282 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    m[2].x = 0.0;
    m[2].y = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_186.instance_params.stride > 0)
    {
        uint flipbook_card = _198.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_210.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_210.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_210.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_210.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_210.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    vtx_output.vLocalPos = vtx_input.pos;
    if (_186.instance_params.stride > 0)
    {
        vec4 inst_m0 = _298.instance_transform[(gl_InstanceIndex * _186.instance_params.stride) + 0];
        vec4 inst_m1 = _298.instance_transform[(gl_InstanceIndex * _186.instance_params.stride) + 1];
        vec4 inst_m2 = _298.instance_transform[(gl_InstanceIndex * _186.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_4 = vtx_input.norm;
        mat4 param_5 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_4, param_5));
        vec2 _385 = unpackHalf2x16(_379.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _385.x;
        inst_c.y = _385.y;
        vec2 _395 = unpackHalf2x16(_379.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _395.x;
        inst_c.w = _395.y;
        vec4 _401 = vtx_input.color;
        vec3 _405 = _401.xyz * inst_c.xyz;
        vtx_input.color.x = _405.x;
        vtx_input.color.y = _405.y;
        vtx_input.color.z = _405.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vec3 param_6 = vtx_input.pos;
    mat4 param_7 = _420.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_6, param_7);
    vec3 param_8 = vtx_input.norm;
    mat4 param_9 = _420.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_8, param_9);
    vec3 param_10 = vPosModel;
    mat4 param_11 = _420.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_10, param_11);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _420.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_420.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_420.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_420.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    vec3 param_12 = vtx_output.vCoords;
    mat4 param_13 = _420.transform_params.mProjection;
    vec4 _515 = vector_transform_by_mat_projection(param_12, param_13);
    gl_Position = _515;
}

 