#version 450
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct FetchMaterialParams
{
    uvec2 screen_pos;
    uint material_id;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) coherent buffer FetchMaterialParamsBuffer
{
    FetchMaterialParams params;
} _95;

layout(set = 0, binding = 2, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

void main()
{
    ivec2 pos = ivec2(_95.params.screen_pos);
    uvec4 param = imageLoad(imMetalnessRoughnessMaterialTags, pos);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
    _95.params.material_id = metalness_roughness_material_tags.material_index;
}

 