#version 450
#extension GL_EXT_debug_printf : require
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleStatisticsParams
{
    uint live_particles;
    uint spawned_particles;
    uint counter;
    uint total_particles;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _37;

layout(set = 0, binding = 2, std430) buffer ParticleStatisticsParamsBuffer
{
    ParticleStatisticsParams statistics_params;
} _73;

ParticleState prt_get_state(uint id)
{
    ParticleState _43;
    _43.life_time = _37.prt_states[id].life_time;
    _43.life_span = _37.prt_states[id].life_span;
    _43.generation_id = _37.prt_states[id].generation_id;
    _43.color = _37.prt_states[id].color;
    ParticleState _42 = _43;
    return _42;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.state = prt_get_state(param);
    ParticleState param_1 = p.state;
    if (prt_is_alive(param_1))
    {
        uint _77 = atomicAdd(_73.statistics_params.live_particles, 1u);
    }
    uint _80 = atomicAdd(_73.statistics_params.total_particles, 1u);
    uint _84 = atomicAdd(_73.statistics_params.counter, 1u);
    uint cntr = _84;
    if (cntr == 299999u)
    {
        debugPrintfEXT("live:%d total:%d\n", _73.statistics_params.live_particles, _73.statistics_params.total_particles);
    }
}

 