#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _214
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _336;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _350;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _214 vtx_input;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _190 = material.albedo_sampler >= 0;
    bool _197;
    if (_190)
    {
        _197 = material.albedo_sampler < 16;
    }
    else
    {
        _197 = _190;
    }
    if (_197)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _240 = material.emissive_sampler >= 0;
    bool _246;
    if (_240)
    {
        _246 = material.emissive_sampler < 16;
    }
    else
    {
        _246 = _240;
    }
    if (_246)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
    bool _281 = material.metalic_roughness_sampler >= 0;
    bool _287;
    if (_281)
    {
        _287 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _287 = _281;
    }
    if (_287)
    {
        vec2 metalic_roughness = vec2(1.0);
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_6 = vtx_input.vLocalPos;
            vec3 param_7 = norm;
            vec3 param_8 = material.triplanar_factor;
            metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_6, param_7, param_8).xy;
        }
        else
        {
            metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).xy;
        }
        material_eval.metalness_texture = clamp(metalic_roughness.x, 0.0, 1.0);
        material_eval.roughness_texture = clamp(metalic_roughness.y, 0.0, 1.0);
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
    if (eval_input.modifier_factor < 0.100000001490116119384765625)
    {
        eval.is_discarded = true;
    }
}

void main()
{
    MaterialPropertiesGPU _343;
    _343.diffuse = materials.material_properties[_336.materialIndex].diffuse;
    _343.transparency = materials.material_properties[_336.materialIndex].transparency;
    _343.emissive = materials.material_properties[_336.materialIndex].emissive;
    _343.roughness = materials.material_properties[_336.materialIndex].roughness;
    _343.triplanar_factor = materials.material_properties[_336.materialIndex].triplanar_factor;
    _343.refraction = materials.material_properties[_336.materialIndex].refraction;
    _343.normal_factor = materials.material_properties[_336.materialIndex].normal_factor;
    _343.emissive_factor = materials.material_properties[_336.materialIndex].emissive_factor;
    _343.temporal_accumulation_factor = materials.material_properties[_336.materialIndex].temporal_accumulation_factor;
    _343.shadowmap_bias = materials.material_properties[_336.materialIndex].shadowmap_bias;
    _343.metalness = materials.material_properties[_336.materialIndex].metalness;
    _343.albedo_sampler = materials.material_properties[_336.materialIndex].albedo_sampler;
    _343.emissive_sampler = materials.material_properties[_336.materialIndex].emissive_sampler;
    _343.normal_sampler = materials.material_properties[_336.materialIndex].normal_sampler;
    _343.metalic_roughness_sampler = materials.material_properties[_336.materialIndex].metalic_roughness_sampler;
    _343.flags = materials.material_properties[_336.materialIndex].flags;
    _343._pad0 = materials.material_properties[_336.materialIndex]._pad0;
    _343._pad1 = materials.material_properties[_336.materialIndex]._pad1;
    MaterialPropertiesGPU material = _343;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _350.transform_params.vCameraPosition;
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _350.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _350.transform_params.mModelInv;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _336.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = 0.0;
    material_eval.metalness = 0.0;
    material_eval.is_discarded = false;
    material_eval.normal = vec3(0.0);
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    MaterialEvalInput eval_input;
    eval_input.uv0 = vtx_input.vUV0;
    eval_input.normal = vtx_input.vNorm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = material_eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate(param, param_1, param_2);
    material_eval = param_1;
    eval_input = param_2;
    if (material_eval.is_discarded)
    {
        discard;
    }
}

 