
var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support


var images = {};
var bpm=120;
var beat = 60/bpm;
var tick= beat/8;
var pattern = 8*beat;
var fftImage = new Image();
var cScaler = 0.0012;
var spiralHeight = 127.979;

Demo.prototype.init = function()
{
	
	Sync.addSync(
	[
		  { "name":"upfade1", "type":"rocket" }
		 ,{ "name":"downfade1", "type":"rocket" }
		 ,{ "name":"upfade2", "type":"rocket" }
		 ,{ "name":"downfade2", "type":"rocket" }
		 ,{ "name":"insanity", "type":"rocket" }	
		 ,{ "name":"fbo2alpha", "type":"rocket" }
		 ,{ "name":"mengerrotate", "type":"rocket" }
		 ,{ "name":"mengerrotate2", "type":"rocket" }
		 ,{ "name":"mengerrotate3", "type":"rocket" }
		 ,{ "name":"mengerspeed", "type":"rocket" }
		 ,{ "name":"mengersteps", "type":"rocket" }
		 ,{ "name":"mengerdivisor", "type":"rocket" }
		 ,{ "name":"dollarBGScale", "type":"rocket" }
		 ,{ "name":"explosion", "type":"rocket" }
		 ,{ "name":"mangle", "type":"rocket" }
		 ,{ "name":"farjangle", "type":"rocket" }
		 ,{ "name":"chainangle", "type":"rocket" }
		 ,{ "name":"glowmultiplier", "type":"rocket" }
		 ,{ "name":"endX", "type":"rocket" }
		 ,{ "name":"endY", "type":"rocket" }
		 ,{ "name":"manEndCol", "type":"rocket" }
		 ,{ "name":"manEndRot", "type":"rocket" }
	]);
	
    var start = 0;
    var duration = 60*20;

	
	this.createFBO(0,999,"fbo0");
	this.createFBO(1001,1999,"fbo1");
	this.createFBO(2001,2999,"fbo2");
	this.createFBO(10000,20000,"fboPost");
	
	this.generateImages(32.0);
	this.dollarBG(44,16,0);
	this.dollarBG(60,16,1000);
	this.generateCapitalism(60.0);
	
	this.mengerBG(80,34.5);
	this.farjanScene(73,10);
	this.man();
	this.manEnd(82.5);	
	this.farjanIntersection(80.5);
	this.allseeing(80.5,2,0.0,.6);
	this.blood(98.5,1.2,965,540);
	this.chain1(98.5,50,0.0);
	this.blood(102.5,1.2,965,540);
	this.chain2(102.5,50,0.0);
	this.blood(106.5,1.2,965,540);
	this.chain3(106.5,50,0.0);
	this.blood(110.5,1.2,965,540);	
	this.chain4(110.5,50,0.0);
	this.generateBlood(114.5);
	this.spirals(114.5,32);
	this.allseeingEnd(114.5,30,.75,.4);
	this.blood(127,1.5,1000,480);
	this.blood(127,1.5,1050,560);
	this.blood(127,1.5,850,430);
	for(k=0;k<2;k++)
	{
		for(i=0;i<4;i++)
		{
			this.missile(44+i*pattern,beat, 1520*Math.random()+200, 400+Math.random()*500, true);
			this.missile(44+i*pattern+beat*1.5,beat, 1520*Math.random()+200, 400+Math.random()*500, true);
			this.missile(44+i*pattern+beat*3.0,beat, 1520*Math.random()+200, 400+Math.random()*500, true);
		} 
	}

	this.loader.addAnimation([
    {
         "start": 0, "duration":200
        ,"layer": 52800, "image": ["data/tex_vignette.png"]
		,"scale":[{"x":1.5,"y":1.5}]
		,"position":[{"x":960,"y":540}]
		,"color":[{"r":255, "g":255,"b":255,"a":155}]
	}]);
	
	this.loader.addAnimation([
    {
         "start": 0, "duration":4
        ,"layer": 2800, "image": ["data/white.png"]
		,"scale":[{"x":18.5,"y":18.5}]
		,"position":[{"x":960,"y":540}]
		,"color":[{"r":0, "g":0,"b":0,"a":255}
		,{"duration":4,"a":0}]
	}]);
	
	this.loader.addAnimation([
    {
         "start": 0, "duration":32
        ,"layer": 100, "image": ["data/white.png"]
		,"scale":[{"x":18.5,"y":18.5}]
		,"position":[{"x":960,"y":540}]
		,"angle":[{"degreesZ":-5.0}]
		,"shader":{
			"name":"cube_bg.fs",
			"variable":
			[
				{"name":"timeMultiplier","type":"float","value":[1.0]},
				{"name":"invert","type":"float","value":[0.0]}
			]
		}
	}]);
	this.loader.addAnimation([
    {
         "start": 32, "duration":32
        ,"layer": 1100, "image": ["data/white.png"]
		,"scale":[{"x":18.5,"y":18.5}]
		,"position":[{"x":960,"y":540}]
		,"angle":[{"degreesZ":-5.0}]
		,"shader":{
			"name":"cube_bg.fs",
			"variable":
			[
				{"name":"timeMultiplier","type":"float","value":[4.0]},
				{"name":"invert","type":"float","value":[1.0]}
			]
		}
	}]);
	

	
	this.loader.addAnimation([{
         "start": 16, "duration":17
        ,"layer": 500, "image": ["data/tex_eye.png"]
		,"object":"obj_eyecubes.obj"
		,"scale":[{"uniform3d":.5}]
		,"position":[{"x":0,"y":-37,"z":-5}
			,{"duration":17,"y":15.5}]
		,"angle": [{"degreesY":"{return 15.0*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": 16, "duration":17
        ,"layer": 500, "image": ["data/tex_eye.png"]
		,"object":"obj_eyecubes.obj"
		,"scale":[{"uniform3d":.75}]
		,"position":[{"x":-5,"y":-60,"z":-15}
			,{"duration":17,"y":15.5}]
		,"angle": [{"degreesY":"{return 180.0-15*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);


	this.loader.addAnimation([{
         "start": 16, "duration":17
        ,"layer": 500, "image": ["data/tex_eye.png"]
		,"object":"obj_eyecubes.obj"
		,"scale":[{"uniform3d":.75}]
		,"position":[{"x":5,"y":-60,"z":-15}
			,{"duration":17,"y":15.5}]
		,"angle": [{"degreesY":"{return 90.0+15*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);	
	
	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"image": ["fbo0.color.fbo"]
		,"layer": 10100
		,"position":[{"x":getScreenWidth()*.5,"y":getScreenHeight()*.5}]
		,"shader":{
			"fader":0.5, 
			"name":"updownfader.fs",
			"variable":
			[
				{"name":"upfadeval","type":"float","value":["{return Sync.getSyncValue('upfade2');}"]},
				{"name":"downfadeval","type":"float","value":["{return Sync.getSyncValue('downfade2');}"]}
			]
			}
	}]);
		
		this.loader.addAnimation ([
		{
		 "start": 0, "duration": 8888
		,"image": ["fbo1.color.fbo"]
		,"layer": 11000
		,"position":[{"x":getScreenWidth()*.5,"y":getScreenHeight()*.5}]
		,"shader":{
			"fader":0.5, 
			"name":"updownfader.fs",
			"variable":
			[
				{"name":"upfadeval","type":"float","value":["{return Sync.getSyncValue('upfade1');}"]},
				{"name":"downfadeval","type":"float","value":["{return Sync.getSyncValue('downfade1');}"]}
			]
			}
		}]);
		
		this.loader.addAnimation ([
		{
		 "start": 0, "duration": 8888
		,"image": ["fbo2.color.fbo"]
		,"color":[{"a":"{return Sync.getSyncValue('fbo2alpha');}"}]
		,"layer": 12000
		,"scale":[{"uniform3d":1.0}
		,{"duration":76,"uniform3d":1.0}
		,{"duration":6.5,"uniform3d":1.75}
		,{"duration":0,"uniform3d":1.0}]
		,"position":[{"x":getScreenWidth()*.5,"y":getScreenHeight()*.5}
		,{"duration":76,"y":getScreenHeight()*.5}
		,{"duration":6.5,"y":getScreenHeight()*(550/720)}
		,{"duration":0,"y":getScreenHeight()*.5}]
	}]);
	
	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"image": ["fboPost.color.fbo"]
		,"layer": 32000
		,"scale":[{"uniform3d":1.0}]
		,"position":[{"x":"{return (getScreenWidth()*.5)+(Math.random()*Sync.getSyncValue('explosion'))-0.5*Sync.getSyncValue('explosion');}","y":"{return (getScreenHeight()*.5)+(Math.random()*Sync.getSyncValue('explosion'))-0.5*Sync.getSyncValue('explosion');}",}]
		,"shader":{
			"fader":0.5, 
			"name":"hackglow.fs",
			"variable":
			[
				{"name":"multiplier","type":"float","value":["{return Sync.getSyncValue('glowmultiplier');}"]}
			]
			}
	}]);
	
}


Demo.prototype.spirals = function (startTime, duration)
{

	this.loader.addAnimation ([{
		 "start": startTime, "duration": duration
		,"image": ["data/tex_scanline.png"]
		,"scale":[{"uniform3d":5.5}]
		,"layer": 101
		,"color":[{"r":0,"g":0,"b":0,"a":75}]

	}]);
	
	this.loader.addAnimation ([{
		 "start": startTime, "duration": duration
		,"image": ["data/tex_skulls.png"]
		,"scale":[{"uniform3d":2.5}]
		,"layer": 100
		,"shader":{
			"name":"starfield.fs",
			"variable":
			[

			]
		}
	}]);
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":3.0}]
	    ,"position":[{"x":0,"y":"{return -100+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-55}]	
		,"angle": [{"degreesY":"{return 180+25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":3.0}]
	    ,"position":[{"x":0,"y":"{return -100+-255.958+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-55}]	
		,"angle": [{"degreesY":"{return 180+25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":3.0}]
	    ,"position":[{"x":0,"y":"{return -100+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-65}]	
		,"angle": [{"degreesY":"{return 25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":3.0}]
	    ,"position":[{"x":0,"y":"{return -100+-255.958+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-65}]	
		,"angle": [{"degreesY":"{return 25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":2.0}]
	    ,"position":[{"x":55,"y":"{return -100+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-130}]	
		,"angle": [{"degreesY":"{return -25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":2.0}]
	    ,"position":[{"x":55,"y":"{return -100+-255.958+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-130}]	
		,"angle": [{"degreesY":"{return -25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);

		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":2.0}]
	    ,"position":[{"x":-55,"y":"{return -100+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-130}]	
		,"angle": [{"degreesY":"{return 25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_spiral.png"]
		,"object":"obj_spiral.obj"
		,"scale":[{"uniform3d":2.0}]
	    ,"position":[{"x":-55,"y":"{return -100+-255.958+255.958*(0.125*getSceneTimeFromStart()%1.0);}","z":-130}]	
		,"angle": [{"degreesY":"{return 25*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"uvscroll.fs",
			"variable":
			[
				{"name":"time","type":"float","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
}

Demo.prototype.createFBO = function (startLayer, endLayer, name)
{
   	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": startLayer
		,"fbo":{"name":name,"action":"begin","storeDepth":true}
	}
	]);
	
	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": endLayer,"fbo":{"name":name,"action":"unbind"}
	}
	]);
	
}

Demo.prototype.missile = function (startTime, duration, posX, posY, explo)
{
	 
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 12100,
		"image": ["data/tex_missile.png"]
		,"scale":[{"uniform3d":8.25}
		,{"duration":duration, "uniform3d":1.25}]
		,"position":[{"x":posX,"y":-120}
		,{"duration":duration, "y":posY}]
		,"color":[{"r":255,"g":0,"b":0,"a":255}]
	}]);
	if(explo)
	{
		this.explosion(startTime+duration,2.0,posX,posY);
	}
}

Demo.prototype.explosion = function(startTime, duration, positionX, positionY)
{
	var randomScaler=722.0;
	for(ie=0;ie<25;ie++)
	{
		this.loader.addAnimation([
				{
				"start": startTime, "duration": duration
				,"layer": 12100
				,"image": ["data/tex_explosion.png"]
						,"angle":[{"degreesZ":Math.random()*360}]
				,"position": [{"x":positionX,"y":positionY,}
				,{"duration":duration,"x":positionX-randomScaler+Math.random()*randomScaler*2.0,"y":positionY-randomScaler+Math.random()*randomScaler*2.0}]
				,"scale":[{"uniform3d":1.8}
				,{"duration":duration, "uniform3d":0.0}]
				,"color":[{"r":255,"g":0,"b":0,"a":255}]
		}]);
	}
}

Demo.prototype.generateBlood = function(startTime)
{
	var bloodSyncs = [8,20,32]
	for(k=0;k<3;k++)
	{
		for(i=0;i<bloodSyncs.length;i++)
		{
			this.blood(startTime+k*pattern+bloodSyncs[i]*tick,2.0,1000,480);		
		}
	}
}

Demo.prototype.blood = function(startTime, duration, positionX, positionY)
{

	var randomScaler=722.0;
	for(ie=0;ie<35;ie++)
	{
		this.loader.addAnimation([
				{
				"start": startTime, "duration": duration
				,"layer": 12100
				,"image": ["data/tex_blood.png"]
				,"angle":[{"degreesZ":Math.random()*360}]
				,"position": [{"x":positionX,"y":positionY,}
				,{"duration":duration,"x":positionX-randomScaler+Math.random()*randomScaler*2.0,"y":positionY-randomScaler*.75+Math.random()*randomScaler*1.5}]	
				,"scale":[{"uniform3d":0.75}
				,{"duration":duration, "uniform3d":0.0}]
				,"color":[{"r":255,"g":255,"b":255,"a":255}]
		}]);
	}
}

Demo.prototype.dollarBG = function(startTime, duration, layer)
{
		this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": layer+500, "image": ["data/tex_dollar.png"]

		,"scale":[{"uniform3d":"{return 1.75+Sync.getSyncValue('dollarBGScale');}"}]
		,"position":[{"x":960,"y":540,"z":0}]

		,"shader":{
			"name":"glitch.fs",
			"variable":
			[
				
				{"name":"amt","type":"float","value":["{return Sync.getSyncValue('insanity');}"]},
				{"name":"scrollspeed","type":"float","value":[1.0]},
			]
		}
	}]);
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": layer+300, "image": ["data/tex_dollar.png"]

		,"scale":[{"uniform3d":2.75}]
		,"position":[{"x":960,"y":540,"z":0}]

		,"shader":{
			"name":"glitch.fs",
			"variable":
			[
				
				{"name":"amt","type":"float","value":["{return Sync.getSyncValue('insanity');}"]},
				{"name":"scrollspeed","type":"float","value":[1.0]},
			]
		}
	}]);
	
}

Demo.prototype.mengerBG = function(startTime, duration)
{
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":duration
        ,"layer": 100, "image": ["data/white.png"]
		,"scale":[{"x":18.5,"y":18.5}]
		,"position":[{"x":960,"y":540}]
		,"angle":[{"degreesZ":-5.0}]
		,"shader":{
			"name":"menger_bg.fs",
			"variable":
			[
				{"name":"timeMultiplier","type":"float","value":[1.0]},
				{"name":"invert","type":"float","value":[0.0]},
				{"name":"rotation","type":"float","value":["{return Sync.getSyncValue('mengerrotate');}"]},
				{"name":"rotation2","type":"float","value":["{return Sync.getSyncValue('mengerrotate2');}"]},
				{"name":"rotation3","type":"float","value":["{return Sync.getSyncValue('mengerrotate3');}"]},
				{"name":"speed","type":"float","value":["{return Sync.getSyncValue('mengerspeed');}"]},
				{"name":"MAX_STEPS","type":"float","value":["{return Sync.getSyncValue('mengersteps');}"]},
				{"name":"mengerdivisor","type":"float","value":["{return Sync.getSyncValue('mengerdivisor');}"]}
			]
		}
	}]);
}

Demo.prototype.farjanScene = function(startTime, duration)
{
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":3.0
        ,"layer": 098, "image": ["data/white.png"]
		
		,"scale":[{"x":20.0,"y":20.0}]
		,"position":[{"x":960,"y":540}]

		,"shader":{
			"name":"clouds.fs",
			"variable":
			[
				{"name":"timeMultiplier","type":"float","value":[1.0]},
				{"name":"invert","type":"float","value":[0.0]}
			]
		}
	}]);

	this.loader.addAnimation([
    {
         "start": startTime+3.0, "duration":duration-5.5
        ,"layer": 2098, "image": ["data/white.png"]
	
		,"scale":[{"x":20.0,"y":20.0}]
		,"position":[{"x":960,"y":540}]
		,"shader":{
			"name":"clouds.fs",
			"variable":
			[
				{"name":"timeMultiplier","type":"float","value":[1.0]},
				{"name":"invert","type":"float","value":[0.0]}
			]
		}
	}]);
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":duration-2.5
        ,"layer": 2100, "image": ["data/tex_wave.png"]
		,"scale":[{"x":4.5,"y":4.5}]
		,"position":[{"x":960,"y":-420}
		,{"duration":4.75, "y":-120}]
		,"color":[{"r":0,"g":255,"b":255,"a":255}]
		,"shader":{
			"name":"wavescroll.fs",
		}
	}]);
	
	this.loader.addAnimation([
    {
         "start": startTime+3, "duration":duration-5.5
        ,"layer": 2099, "image": ["data/tex_boat.png"]
		,"scale":[{"x":1.0,"y":1.0}]
		,"angle":[{"degreesZ":"{return 5.0*Math.sin(2*getSceneTimeFromStart());}"}]
		,"position":[{"x":-175,"y":"{return 160+25.0*Math.sin(4*getSceneTimeFromStart());}"}
		,{"duration":4.65, "x":960,"y":"{return 230+25.0*Math.sin(4*getSceneTimeFromStart());}"}]
		,"color":[{"r":255,"g":0,"b":0,"a":255}]

	}]);
}

Demo.prototype.man = function()
{
	
	this.loader.addAnimation([{
         "start": 0, "duration":80.5
        ,"layer": 2300, "image": ["data/tex_man.png"]
		,"scale":[{"uniform3d":0.75}
		,{"duration":75, "uniform3d":0.75}
		,{"duration":1, "uniform3d":0.15}]
		,"position":[{"x":960,"y":"{return 540+8*Math.sin(5*getSceneTimeFromStart());}", "z":1}
		,{"duration":75, "y":"{return 540+3*Math.sin(1.5+5*getSceneTimeFromStart());}"}
		,{"duration":1, "y":"{return 831+3*Math.sin(1.5+5*getSceneTimeFromStart());}"}
		,{"duration":4.75, "y":"{return 240;}"}]
		,"angle":[{"degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":75, "degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":1, "degreesZ":"{return 5.0*Math.sin(2*getSceneTimeFromStart());}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}
		,{"duration":32,"r":255,"g":255,"b":255}
		,{"duration":0,"r":0,"g":0,"b":0}]
		
	}]);

	this.loader.addAnimation([{
         "start": 0, "duration":80.5
        ,"layer": 2250, "image": ["data/tex_man.png"]
		,"scale":[{"uniform3d":0.75}
		,{"duration":75, "uniform3d":0.75}
		,{"duration":1, "uniform3d":0.25}]
		,"position":[{"x":960,"y":"{return 531+3*Math.sin(1.5+5*getSceneTimeFromStart());}", "z":1}
		,{"duration":75, "y":"{return 531+3*Math.sin(1.5+5*getSceneTimeFromStart());}"}
		,{"duration":1, "y":"{return 822+3*Math.sin(1.5+5*getSceneTimeFromStart());}"}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}
		,{"duration":32,"r":0,"g":0,"b":0}
		,{"duration":0,"r":255,"g":255,"b":255}
		,{"duration":43,"a":255}
		,{"duration":1,"a":0}]
		,"angle":[{"degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":75, "degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":1, "degreesZ":"{return 5.0*Math.sin(2*getSceneTimeFromStart());}"}]

	}]);
}
	
Demo.prototype.allseeing = function(startTime, duration, yPos, scale)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_allseeing.png"]
		,"object":"obj_allseeing.obj"
		,"position":[{"x":0,"y":yPos,"z":-1}]
		,"scale":[{"uniform3d":scale}]
		,"angle": [{"degreesY":"{return -20*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
}

Demo.prototype.allseeingEnd = function(startTime, duration, yPos, scale)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_allseeing.png"]
		,"object":"obj_allseeing.obj"
		,"position":[{"x":0,"y":"{return .73+0.05*Math.sin(3*getSceneTimeFromStart());}","z":-1}]
		,"scale":[{"uniform3d":scale}]
		,"angle": [{"degreesY":"{return -20*getSceneTimeFromStart();}","degreesZ":0,"degreesX":0}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
	
	this.loader.addAnimation([
    {
         "start": startTime+13, "duration":32
        ,"layer": 2800, "image": ["data/white.png"]
		,"scale":[{"x":18.5,"y":18.5}]
		,"position":[{"x":960,"y":540}]
		,"color":[{"r":255, "g":0,"b":0,"a":0}
		,{"duration":5,"a":255}]
	}]);
	
	this.createText(startTime+19.5,22.8,"FALL OF MAN",5.0,250);
	this.createText(startTime+21.5,22.8,"A tragedy in three parts",3.0,0);
	this.createText(startTime+23.5,22.8,"JUMALAUTA 2024",5.0,-330);
	

}

Demo.prototype.chain1 = function(startTime, duration,yPos)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_chain.png"]
		,"object":"obj_chain.obj"
		,"position":[{"chainScaler":cScaler,"x":"{return 0.1+Sync.getSyncValue('endX')*animation.chainScaler;}","y":"{return 0.0+Sync.getSyncValue('endY')*animation.chainScaler;}","z":0}]
		,"scale":[{"uniform3d":0.050}]
		,"angle": [{"degreesX":45.0,"degreesY":"{return 45*Sync.getSyncValue('chainangle');}","degreesZ":"{return 45*getSceneTimeFromStart();}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
}

Demo.prototype.chain2 = function(startTime, duration,yPos)
{
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_chain.png"]
		,"object":"obj_chain.obj"
		,"position":[{"chainScaler":cScaler,"x":"{return 0.1+Sync.getSyncValue('endX')*animation.chainScaler;}","y":"{return 0.0+Sync.getSyncValue('endY')*animation.chainScaler;}","z":0}]
		,"scale":[{"uniform3d":0.050}]
		,"angle": [{"degreesX":-45,"degreesY":"{return -45*Sync.getSyncValue('chainangle');}","degreesZ":"{return 45*getSceneTimeFromStart();}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
}

Demo.prototype.chain3 = function(startTime, duration,yPos)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 200, "image": ["data/tex_chain.png"]
		,"object":"obj_chain.obj"
		,"position":[{"chainScaler":cScaler,"x":"{return 0.1+Sync.getSyncValue('endX')*animation.chainScaler;}","y":"{return 0.0+Sync.getSyncValue('endY')*animation.chainScaler;}","z":0}]
		,"scale":[{"uniform3d":0.050}]
		,"angle": [{"degreesX":45.0,"degreesY":"{return 270+45*Sync.getSyncValue('chainangle');}","degreesZ":"{return -45*getSceneTimeFromStart();}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
}

Demo.prototype.chain4 = function(startTime, duration,yPos)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":duration
        ,"layer": 2400, "image": ["data/tex_chain.png"]
		,"object":"obj_chain.obj"
		,"position":[{"chainScaler":cScaler,"x":"{return 0.1+Sync.getSyncValue('endX')*animation.chainScaler;}","y":"{return 0.0+Sync.getSyncValue('endY')*animation.chainScaler;}","z":0}]
		,"scale":[{"uniform3d":0.050}]
		,"angle": [{"degreesX":-45,"degreesY":"{return 90-45*Sync.getSyncValue('chainangle');}","degreesZ":"{return 45*getSceneTimeFromStart();}"}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]	
	}]);
}

Demo.prototype.generateImages = function(startTime)
{
	var imageSyncs = [0,4,8,10,14,16,20,24]
	var imageNames = ["tex_ak.png", "tex_choppa.png", "tex_mp5.png", "tex_tank.png", "tex_grenade.png", "tex_launcher.png", "tex_carrier.png", "tex_bomb.png"]
	var imageScales = [1.3,         1.25,              0.85,           1.0,            0.6,               1.0,                1.25,               0.9]
	var prevRandom=100;
	for(k=0;k<6;k++)
	{
		for(i=0;i<imageSyncs.length;i++)
		{
			var randomImage = Math.floor(Math.random()*imageNames.length);
			
			if(randomImage==prevRandom)
			{
				randomImage++;
			}
			if(randomImage>=imageNames.length)
			{
				randomImage=0;
			}
			
			this.image(startTime+k*pattern*.5+imageSyncs[i]*tick, imageNames[randomImage], 1700,imageScales[randomImage],10.5);
			
			prevRandom=randomImage;
					
		}
	}
}

Demo.prototype.generateCapitalism = function(startTime)
{
	var imageSyncs2 = [0,8,16,24,32,40,48,56];
	var imageSyncs3 = [0,8,16,24,32,40,48,56];
	var imageNames = ["tex_tv.png", "tex_washingmachine.png", "tex_computer.png", "tex_phone.png", "tex_car.png", "tex_hamburger.png", "tex_hifi.png"];
	var imageScales = [0.81,         0.65,                      0.85,               0.9,             1.1,           0.8,                1.25]	
	var prevRandom=100;
	for(k=0;k<3;k++)
	{
		for(i=0;i<imageSyncs2.length;i++)
		{			
			var randomImage = Math.floor(Math.random()*imageNames.length);
			
			if(randomImage==prevRandom)
			{
				randomImage++;
			}
			if(randomImage>=imageNames.length)
			{
				randomImage=0;
			}
				
			this.imageCapitalism(startTime+k*pattern+imageSyncs2[i]*tick, imageNames[randomImage],1700, imageScales[randomImage], 45);
			
			prevRandom=randomImage;
		}
	}
	
	for(i=0;i<imageSyncs3.length;i++)
	{
			var randomImage = Math.floor(Math.random()*imageNames.length);
			
			if(randomImage==prevRandom)
			{
				randomImage++;
			}
			if(randomImage>=imageNames.length)
			{
				randomImage=0;
			}

		this.imageCapitalism(startTime+k*pattern+imageSyncs3[i]*tick, imageNames[randomImage],1700, imageScales[randomImage],45);
		
			prevRandom=randomImage;
	}
		
}

Demo.prototype.image = function(startTime, imageName, layer, scale, angleRandom)
{
	var posX=300+(1920-600)*Math.random();
	var invertX = 1;
	if(posX<(1920/2))
	{
		invertX=-1;
	}
	this.loader.addAnimation([
    {
         "start": startTime, "duration":1.0
        ,"layer": layer, "image": ["data/" + imageName]
		,"angle":[{"degreesZ":Math.random()*angleRandom*2-angleRandom}]
		,"position":[{"x":posX,"y":-256}
		,{"duration":1.0, "y":1280+256}]
		,"scale":[{"x":1.5*invertX*scale,"y":1.5*scale}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}]
	}]);
}

Demo.prototype.imageCapitalism = function(startTime, imageName, layer, scale)
{
	var posX=300+(1920-600)*Math.random();
	var invertX = 1;
	if(posX<(1920/2))
	{
		invertX=-1;
	}
	var randoScale = .9+Math.random()*.1;
	var randoAngle = Math.random()*40*2-40;
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":1.0
        ,"layer": layer, "image": ["data/" + imageName]
		,"angle":[{"rAngle":randoAngle, "degreesZ":"{return animation.rAngle+12.0*Math.sin(2*getSceneTimeFromStart());}"}]
		,"position":[{"x":posX,"y":-256}
		,{"duration":1.0, "y":1280+256}]
		,"scale":[{"x":1.5*invertX*scale*randoScale,"y":1.5*scale*randoScale}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
	}]);
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":1.0
        ,"layer": layer-1, "image": ["data/" + imageName]
		,"angle":[{"rAngle":randoAngle, "degreesZ":"{return animation.rAngle+12.0*Math.sin(2*getSceneTimeFromStart());}"}]
		,"position":[{"x":posX,"y":-256}
		,{"duration":1.0, "y":1280+256}]
		,"scale":[{"x":1.1*1.5*invertX*scale*randoScale,"y":1.1*1.5*scale*randoScale}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}]
	}]);
	
}

Demo.prototype.manEnd = function(startTime)
{
	
	this.loader.addAnimation([{
         "start": startTime, "duration":44.5
        ,"layer": 2300, "image": ["data/tex_man.png"]
		,"scale":[{"uniform3d":0.75}]
		,"angle":[{"degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":26.0, "degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":1.0, "degreesZ":"{return Sync.getSyncValue('manEndRot');}"}]
		,"position":[{"x":"{return Sync.getSyncValue('endX')+960;}","y":"{return Sync.getSyncValue('endY')+540;}", "z":1}]
		,"color":[{"r":"{return Sync.getSyncValue('manEndCol');}","g":"{return Sync.getSyncValue('manEndCol');}","b":"{return Sync.getSyncValue('manEndCol');}","a":255}]
	}]);

	this.loader.addAnimation([{
         "start": startTime, "duration":44.5
        ,"layer": 2250, "image": ["data/tex_man.png"]
		,"scale":[{"uniform3d":0.75}
		,{"duration":75, "uniform3d":0.75}
		,{"duration":1, "uniform3d":0.25}]
		,"position":[{"x":"{return Sync.getSyncValue('endX')+960;}","y":"{return Sync.getSyncValue('endY')+531+3*Math.sin(1.5+5*getSceneTimeFromStart());}", "z":1}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
		,"angle":[{"degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":26.0, "degreesZ":"{return 2.0*Math.sin(6*getSceneTimeFromStart());}"}
		,{"duration":1.0, "degreesZ":"{return Sync.getSyncValue('manEndRot');}"}]
	}]);
}
Demo.prototype.farjanIntersection = function(startTime)
{
	this.loader.addAnimation([
    {
         "start": startTime, "duration":2.0
        ,"layer": 2300, "image": ["data/tex_man_outline.png"]
		,"position":[{"x":960,"y":370}]
		,"angle":[{"degreesZ":"{return Sync.getSyncValue('mangle');}"}]
		,"scale":[{"uniform3d":.8}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
	}]);
	
	this.loader.addAnimation([
    {
         "start": startTime, "duration":2.0
        ,"layer": 2300, "image": ["data/tex_boat_outline.png"]
		,"position":[{"x":960,"y":370}]
		,"angle":[{"degreesZ":"{return Sync.getSyncValue('farjangle');}"}]
		,"scale":[{"uniform3d":1.8}]
		,"color":[{"r":255,"g":255,"b":255,"a":255}]
	}]);
	
		this.loader.addAnimation([
    {
         "start": startTime, "duration":2.0
        ,"layer": 2098, "image": ["data/white.png"]
		,"scale":[{"x":20.0,"y":30.0}]
		,"position":[{"x":960,"y":340}]
		,"shader":{
			"name":"starfield.fs",
			"variable":
			[

			]
		}
	}]);
}

Demo.prototype.createText = function (startTime, duration, textString, scale,yPos)
{
	   	this.loader.addAnimation([{
		"start": startTime, "duration": duration ,"layer": 2850,			
		"text":
		{
			"string":textString
			,"name":"font.ttf"
		}
		,"scale":[{"uniform3d":scale}]
		,"position":[{"x":960,"y":540+yPos,"z":1}		]
		,"angle":[{"degreesZ":0}]
		,"color":[{"r":0,"g":0,"b":0}]
	}]);
}