uniform float iTime;
uniform int numStars; /* 90 */


void main()
{
    vec2 iResolution = vec2(1920., 1080.);
    vec2 uv = gl_TexCoord[0].xy; // fragCoord / iResolution.xy;
    uv = uv * 2.0 - 1.0;  // Normalize to [-1, 1]
    uv.x *= iResolution.x / iResolution.y;  // Adjust for aspect ratio

    float time = iTime;

    vec3 color = vec3(.1, 0., .1);
    
    // Loop through multiple "layers" of stars
    for (int i = 0; i < numStars; i++) {
        // Generate a random star position
        vec2 starPos = vec2(fract(sin(float(i) * 78.233) * 43758.5453),
                            fract(sin(float(i) * 12.9898) * 43758.5453));

        // Move stars outward from the center over time
        starPos = starPos * 2.0 - 1.0;  // Center stars in [-1, 1]
        
        float speed = 0.3 + mod(float(i), 5.0) * 0.1;  // Different speeds for depth
        
        // Calculate star's position with outward motion
        vec2 starUV = starPos + normalize(starPos) * time * speed;

        // Wrap around to keep stars inside the view
        starUV = mod(starUV + 1.0, 2.0) - 1.0;

        float size = 0.008 / length(uv - starUV);  // Star size based on distance

        color += vec3(1.0) * size;  // Add star color to final color
    }

    gl_FragColor = vec4(color, 1.0);
}
