#version 130

#define PI 3.14159265359

uniform float iTime;  // Time
uniform float r = 0.15;
uniform float b = 0.15;

uniform float originalRed = 0.25;
uniform float originalGreen = 0.;
uniform float originalBlue = 0.25;

// Function to generate smooth noise
float smoothNoise(vec2 uv) {
    return fract(sin(dot(uv, vec2(12.9898, 78.233))) * 43758.5453);
}

// Function to generate Perlin-like noise
float perlinNoise(vec2 uv) {
    vec2 i = floor(uv);
    vec2 f = fract(uv);
    f = f * f * (3.0 - 2.0 * f);  // Smooth interpolation
    
    float a = smoothNoise(i);
    float b = smoothNoise(i + vec2(1.0, 0.0));
    float c = smoothNoise(i + vec2(0.0, 1.0));
    float d = smoothNoise(i + vec2(1.0, 1.0));
    
    return mix(mix(a, b, f.x), mix(c, d, f.x), f.y);
}

void main() {

    vec2 iResolution = vec2(1920., 1080.);

    vec2 uv = gl_TexCoord[0].xy;  // Normalize coordinates to [0,1]
    uv.x *= iResolution.x / iResolution.y;  // Maintain aspect ratio
    
    // Apply a slow-moving shift over time for the background
    vec2 move = vec2(0.4 * iTime, 0.45 * iTime);  // Slow movement
    float noiseValue = perlinNoise(uv * 6.0 + move);  // Scale and move noise

    // Create a dark ambient color, slightly varying based on noise
    vec3 ambientColor = vec3(originalRed, originalGreen, originalBlue) + noiseValue * vec3(r, 0.0, b);
    
    gl_FragColor = vec4(ambientColor, 1.0);
}
