#ifndef VERTEX_MODIFIER_UV_H
#define VERTEX_MODIFIER_UV_H

#include <shaders/materials/noise/noise3Dgrad.glsl>
#include <shaders/materials/commons_curves.glsl>

struct VertexModifierUVParams
{
	mat4 transform;
	bool override;
	int  override_mode;
};

void vertex_modifier_uv_apply(VertexModifierUVParams params, in out VertexInput vtx_input)
{
	vec2 uv = vtx_input.uv0;
	if (params.override)
	{
		if (params.override_mode == 0)	// planes
			uv = vtx_input.pos.xy;
		if (params.override_mode == 1)
			uv = vtx_input.pos.yz;
		if (params.override_mode == 2)
			uv = vtx_input.pos.xz;
		if (params.override_mode == 3)  // radial
		{
			uv.x = length(vtx_input.pos.xyz);
			//uv.y = fract(atan(vtx_input.pos.z, vtx_input.pos.y));
			uv.y = 0.0;
		}
	}

	// compiler will optimize this
	uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
	vtx_input.uv0 = uv;
}


#endif