#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _416
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    float transparency;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
    uint primitiveID;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _407;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _425;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _416 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

uint octahedral_32(inout vec3 nor, uint sh)
{
    nor /= vec3((abs(nor.x) + abs(nor.y)) + abs(nor.z));
    float t = max(-nor.z, 0.0);
    float _145;
    if (nor.x > 0.0)
    {
        _145 = t;
    }
    else
    {
        _145 = -t;
    }
    nor.x += _145;
    float _160;
    if (nor.y > 0.0)
    {
        _160 = t;
    }
    else
    {
        _160 = -t;
    }
    nor.y += _160;
    vec2 v = (nor.xy * 0.5) + vec2(0.5);
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(floor((v * float(mu)) + vec2(0.5)));
    return (d.y << sh) | d.x;
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint param_1 = 15u;
    uint _208 = octahedral_32(param, param_1);
    uint normal_material = _208;
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec4 getMaterialAlbedo(MaterialPropertiesGPU material, vec4 albedo, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return albedo;
}

vec3 getMaterialEmissive(MaterialPropertiesGPU material, vec3 emissive, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return emissive;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

float getMaterialRoughness(MaterialPropertiesGPU material, float roughness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return roughness;
}

float getMaterialMetalness(MaterialPropertiesGPU material, float metalness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return metalness;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _255 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _255.x;
    o.y = _255.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _414;
    _414.diffuse = materials.material_properties[_407.materialIndex].diffuse;
    _414.transparency = materials.material_properties[_407.materialIndex].transparency;
    _414.emissive = materials.material_properties[_407.materialIndex].emissive;
    _414.roughness = materials.material_properties[_407.materialIndex].roughness;
    _414.triplanar_factor = materials.material_properties[_407.materialIndex].triplanar_factor;
    _414.refraction = materials.material_properties[_407.materialIndex].refraction;
    _414.normal_factor = materials.material_properties[_407.materialIndex].normal_factor;
    _414.emissive_factor = materials.material_properties[_407.materialIndex].emissive_factor;
    _414.temporal_accumulation_factor = materials.material_properties[_407.materialIndex].temporal_accumulation_factor;
    _414.shadowmap_bias = materials.material_properties[_407.materialIndex].shadowmap_bias;
    _414.metalness = materials.material_properties[_407.materialIndex].metalness;
    _414.albedo_sampler = materials.material_properties[_407.materialIndex].albedo_sampler;
    _414.emissive_sampler = materials.material_properties[_407.materialIndex].emissive_sampler;
    _414.normal_sampler = materials.material_properties[_407.materialIndex].normal_sampler;
    _414.metalic_roughness_sampler = materials.material_properties[_407.materialIndex].metalic_roughness_sampler;
    _414.flags = materials.material_properties[_407.materialIndex].flags;
    _414._pad0 = materials.material_properties[_407.materialIndex]._pad0;
    _414._pad1 = materials.material_properties[_407.materialIndex]._pad1;
    MaterialPropertiesGPU material = _414;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _425.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_11 = normal;
    int param_12 = _407.materialId;
    outNormalMaterial = encode_normal_material(param_11, param_12);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _425.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _425.transform_params.mModelInv;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _407.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.transparency = material.transparency;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    eval_input.primitiveID = uint(gl_PrimitiveID);
    outAlbedo = vec4(material.diffuse, _407.colorDiffuse.w);
    MaterialPropertiesGPU param_13 = material;
    vec4 param_14 = outAlbedo;
    vec3 param_15 = worldPos;
    vec3 param_16 = vtx_input.vLocalPos;
    vec3 param_17 = vtx_input.vNorm;
    vec3 param_18 = vtx_input.vWorldNorm;
    outAlbedo = getMaterialAlbedo(param_13, param_14, param_15, param_16, param_17, param_18);
    vec4 _635 = outAlbedo;
    vec3 _637 = _635.xyz * vtx_input.vColor.xyz;
    outAlbedo.x = _637.x;
    outAlbedo.y = _637.y;
    outAlbedo.z = _637.z;
    outEmissive = vec4(0.0);
    outEmissive.w = material.transparency;
    MaterialPropertiesGPU param_19 = material;
    vec3 param_20 = outEmissive.xyz;
    vec3 param_21 = worldPos;
    vec3 param_22 = vtx_input.vLocalPos;
    vec3 param_23 = vtx_input.vNorm;
    vec3 param_24 = vtx_input.vWorldNorm;
    vec3 _666 = getMaterialEmissive(param_19, param_20, param_21, param_22, param_23, param_24);
    outEmissive.x = _666.x;
    outEmissive.y = _666.y;
    outEmissive.z = _666.z;
    bool _675 = material.emissive_sampler >= 0;
    bool _682;
    if (_675)
    {
        _682 = material.emissive_sampler < 16;
    }
    else
    {
        _682 = _675;
    }
    if (_682)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_25 = vtx_input.vLocalPos;
            vec3 param_26 = norm;
            vec3 param_27 = material.triplanar_factor;
            vec4 _709 = outEmissive;
            vec3 _711 = _709.xyz * mapping_triplanar(material_textures[material.emissive_sampler], param_25, param_26, param_27).xyz;
            outEmissive.x = _711.x;
            outEmissive.y = _711.y;
            outEmissive.z = _711.z;
        }
        else
        {
            vec4 _726 = outEmissive;
            vec3 _728 = _726.xyz * texture(material_textures[material.emissive_sampler], uv0).xyz;
            outEmissive.x = _728.x;
            outEmissive.y = _728.y;
            outEmissive.z = _728.z;
        }
    }
    float roughness = material.roughness;
    MaterialPropertiesGPU param_28 = material;
    float param_29 = roughness;
    vec3 param_30 = worldPos;
    vec3 param_31 = vtx_input.vLocalPos;
    vec3 param_32 = vtx_input.vNorm;
    vec3 param_33 = vtx_input.vWorldNorm;
    roughness = getMaterialRoughness(param_28, param_29, param_30, param_31, param_32, param_33);
    float metalness = material.metalness;
    MaterialPropertiesGPU param_34 = material;
    float param_35 = metalness;
    vec3 param_36 = worldPos;
    vec3 param_37 = vtx_input.vLocalPos;
    vec3 param_38 = vtx_input.vNorm;
    vec3 param_39 = vtx_input.vWorldNorm;
    metalness = getMaterialMetalness(param_34, param_35, param_36, param_37, param_38, param_39);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_407.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_407.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_40 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_40);
}

 