#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstancedMeshParams
{
    float scale;
    int merged_clones;
    int base_verts_num;
    int materialIndex;
    int lights_num;
};

struct _473
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _134;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _158;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 4, std140) uniform InstancedMeshParamsBuffer
{
    InstancedMeshParams instanced_mesh_params;
} _434;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _508;

layout(set = 0, binding = 6, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 0, binding = 7) uniform sampler2DShadow LightShadowmapCmpSamplers[16];

layout(location = 0) out uint instanceID;
layout(location = 1) out _473 vtx_output;

vec3 prt_get_position(uint id)
{
    return vec3(_158.prt_positions[(id * 3u) + 0u], _158.prt_positions[(id * 3u) + 1u], _158.prt_positions[(id * 3u) + 2u]);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _134.prt_states[id].color;
    vec3 _184 = color_convert_uint_to_float3(param);
    c.x = _184.x;
    c.y = _184.y;
    c.z = _184.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _151;
    _151.life_time = _134.prt_states[id].life_time;
    _151.life_span = _134.prt_states[id].life_span;
    _151.generation_id = _134.prt_states[id].generation_id;
    _151.color = _134.prt_states[id].color;
    ParticleState _150 = _151;
    return _150;
}

bool prt_is_alive(uint id)
{
    return _134.prt_states[id].life_time < _134.prt_states[id].life_span;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _207 = coords.x < (-coords.w);
    bool _216;
    if (!_207)
    {
        _216 = coords.x > coords.w;
    }
    else
    {
        _216 = _207;
    }
    bool _226;
    if (!_216)
    {
        _226 = coords.y < (-coords.w);
    }
    else
    {
        _226 = _216;
    }
    bool _235;
    if (!_226)
    {
        _235 = coords.y > coords.w;
    }
    else
    {
        _235 = _226;
    }
    bool _242;
    if (!_235)
    {
        _242 = coords.z < 0.0;
    }
    else
    {
        _242 = _235;
    }
    if (_242)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _246 = coords;
    float _252 = coords.w;
    vec2 _254 = (_246.xy * vec2(0.5)) + (vec2(0.5) * _252);
    coords.x = _254.x;
    coords.y = _254.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _285 = -sampling_r;
    float y = _285;
    int iy = 0;
    for (;;)
    {
        if (iy < samples)
        {
            float _297 = -sampling_r;
            float x = _297;
            int ix = 0;
            for (;;)
            {
                if (ix < samples)
                {
                    vec4 _323 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
                    vec4 _326 = _323;
                    _326.z = _323.w;
                    float shadow = textureProjLod(smpl, vec4(_326.xy, _323.z, _326.z), 0.0);
                    fact += shadow;
                    ix++;
                    x += ((2.0 * sampling_r) / float(samples - 1));
                    continue;
                }
                else
                {
                    break;
                }
            }
            iy++;
            y += ((2.0 * sampling_r) / float(samples - 1));
            continue;
        }
        else
        {
            break;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _387 = falloff > cutoff;
    bool _394;
    if (_387)
    {
        _394 = light_distance < light.range;
    }
    else
    {
        _394 = _387;
    }
    if (_394)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    MaterialPropertiesGPU _441;
    _441.diffuse = materials.material_properties[_434.instanced_mesh_params.materialIndex].diffuse;
    _441.transparency = materials.material_properties[_434.instanced_mesh_params.materialIndex].transparency;
    _441.emissive = materials.material_properties[_434.instanced_mesh_params.materialIndex].emissive;
    _441.roughness = materials.material_properties[_434.instanced_mesh_params.materialIndex].roughness;
    _441.triplanar_factor = materials.material_properties[_434.instanced_mesh_params.materialIndex].triplanar_factor;
    _441.refraction = materials.material_properties[_434.instanced_mesh_params.materialIndex].refraction;
    _441.normal_factor = materials.material_properties[_434.instanced_mesh_params.materialIndex].normal_factor;
    _441.emissive_factor = materials.material_properties[_434.instanced_mesh_params.materialIndex].emissive_factor;
    _441.temporal_accumulation_factor = materials.material_properties[_434.instanced_mesh_params.materialIndex].temporal_accumulation_factor;
    _441.shadowmap_bias = materials.material_properties[_434.instanced_mesh_params.materialIndex].shadowmap_bias;
    _441.metalness = materials.material_properties[_434.instanced_mesh_params.materialIndex].metalness;
    _441.albedo_sampler = materials.material_properties[_434.instanced_mesh_params.materialIndex].albedo_sampler;
    _441.emissive_sampler = materials.material_properties[_434.instanced_mesh_params.materialIndex].emissive_sampler;
    _441.normal_sampler = materials.material_properties[_434.instanced_mesh_params.materialIndex].normal_sampler;
    _441.metalic_roughness_sampler = materials.material_properties[_434.instanced_mesh_params.materialIndex].metalic_roughness_sampler;
    _441.flags = materials.material_properties[_434.instanced_mesh_params.materialIndex].flags;
    _441._pad0 = materials.material_properties[_434.instanced_mesh_params.materialIndex]._pad0;
    _441._pad1 = materials.material_properties[_434.instanced_mesh_params.materialIndex]._pad1;
    MaterialPropertiesGPU material = _441;
    int instance_idx = (gl_InstanceIndex * _434.instanced_mesh_params.merged_clones) + (gl_VertexIndex / _434.instanced_mesh_params.base_verts_num);
    int quad_vidx = gl_VertexIndex & 3;
    vec3 quad_coords;
    quad_coords.x = ((quad_vidx == 1) || (quad_vidx == 2)) ? (-0.5) : 0.5;
    quad_coords.y = ((quad_vidx == 0) || (quad_vidx == 1)) ? 0.5 : (-0.5);
    quad_coords.z = 0.0;
    vtx_output.vUV0 = vec2((quad_coords + vec3(0.5)).xy);
    uint param = uint(instance_idx);
    vec3 vInstPosition = prt_get_position(param);
    uint param_1 = uint(instance_idx);
    vec4 vInstColor = prt_get_color(param_1);
    uint param_2 = uint(instance_idx);
    ParticleState vState = prt_get_state(param_2);
    float quad_scale = _434.instanced_mesh_params.scale;
    quad_coords = vec3(dot(quad_coords, _508.transform_params.mModelView[0].xyz), dot(quad_coords, _508.transform_params.mModelView[1].xyz), dot(quad_coords, _508.transform_params.mModelView[2].xyz));
    vInstPosition += (quad_coords * quad_scale);
    vec3 pos = vInstPosition;
    uint param_3 = uint(instance_idx);
    if (!prt_is_alive(param_3))
    {
        pos = vec3(0.0);
    }
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_4 = vPos1;
    mat4 param_5 = _508.transform_params.mModelView;
    vec3 _551 = vector_transform_by_mat43(param_4, param_5);
    vec3 vPos = _551;
    vec3 param_6 = vPos1;
    mat4 param_7 = _508.transform_params.mModel;
    vec3 _558 = vector_transform_by_mat43(param_6, param_7);
    vtx_output.vWorldPos = _558;
    vtx_output.vNorm = vec3(0.0, 0.0, 1.0);
    vtx_output.vWorldNorm = vec3(0.0, 0.0, 1.0);
    gl_Position = _508.transform_params.mProjection * vec4(vPos, 1.0);
    vec3 light_color = vec3(0.0);
    float param_9;
    int light_idx = 0;
    for (;;)
    {
        if (light_idx < _434.instanced_mesh_params.lights_num)
        {
            LightProperties _602;
            _602.diffuse = lights.light_properties[light_idx].diffuse;
            _602.direction = lights.light_properties[light_idx].direction;
            _602.position = lights.light_properties[light_idx].position;
            _602.up = lights.light_properties[light_idx].up;
            _602.right = lights.light_properties[light_idx].right;
            _602.dimensions = lights.light_properties[light_idx].dimensions;
            _602.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
            _602.intensity = lights.light_properties[light_idx].intensity;
            _602.range = lights.light_properties[light_idx].range;
            _602.cutoff = lights.light_properties[light_idx].cutoff;
            _602.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _602.is_area = lights.light_properties[light_idx].is_area;
            _602.type = lights.light_properties[light_idx].type;
            _602.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _602.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _602.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
            _602.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _602.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _602.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _602.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _602.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _602.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _602.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _602.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _602.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _602.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _602.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _602.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _602.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _602.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _602.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _602.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _602.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _602;
            vec4 projector_color = vec4(0.0);
            vec3 world = vtx_output.vWorldPos;
            float shadow = 0.0;
            bool calculate_shadows = (light.type & 8) != 0;
            if (((light.type & 3) != 0) && calculate_shadows)
            {
                float penumbra_scaling_factor = 0.5;
                vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                float in_frustum = 0.0;
                vec4 param_8 = vShadowCoords;
                int param_10 = 3;
                float param_11 = 9.9999997473787516355514526367188e-05;
                float _648 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_8, param_9, param_10, param_11);
                in_frustum = param_9;
                shadow = _648;
            }
            shadow = 1.0 - shadow;
            if ((light.type & 130) == 130)
            {
                LightProperties param_12 = light;
                vec3 param_13 = world;
                float attenuation = light_calculate_spot_attenuation(param_12, param_13);
                shadow *= attenuation;
            }
            light_color += ((light.diffuse.xyz * sqrt(light.intensity)) * shadow);
            light_idx++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec4 _683 = vInstColor;
    vec3 _685 = _683.xyz * light_color;
    vInstColor.x = _685.x;
    vInstColor.y = _685.y;
    vInstColor.z = _685.z;
    vec4 _694 = vInstColor;
    vec3 _696 = _694.xyz * material.diffuse;
    vInstColor.x = _696.x;
    vInstColor.y = _696.y;
    vInstColor.z = _696.z;
    vec4 _708 = vInstColor;
    vec3 _710 = _708.xyz + (material.emissive * material.emissive_factor);
    vInstColor.x = _710.x;
    vInstColor.y = _710.y;
    vInstColor.z = _710.z;
    float life_time_factor = min(1.0, vState.life_time / vState.life_span);
    life_time_factor = 1.0 - sin((life_time_factor * 3.1415927410125732421875) * 0.5);
    vec4 _734 = vInstColor;
    vec3 _736 = _734.xyz * (1.0 - pow(life_time_factor, 4.0));
    vInstColor.x = _736.x;
    vInstColor.y = _736.y;
    vInstColor.z = _736.z;
    vtx_output.vCoords = vPos;
    vtx_output.vColor = vec4(vInstColor);
}

 