#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GPUHashMapInsertResult
{
    uint slot;
    bool duplicate;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometrySubdivideParams
{
    uint max_faces_num;
    uint surfaces_num;
    uint surface_idx;
    uint attribute_mask;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer EdgeHashMapKeysBuffer
{
    GPUHashMapHeader header;
    uint64_t keys[];
} edge_hashmap;

layout(set = 0, binding = 5, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _137;

layout(set = 0, binding = 2, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 6, std140) uniform GeometrySubdivideParamsBuffer
{
    GeometrySubdivideParams geometry_subdivide_params;
} _189;

layout(set = 0, binding = 3, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _334;

layout(set = 0, binding = 4, std430) buffer EdgeHashMapValuesBuffer
{
    uint values[];
} edge_hashmap_values;

uint get_idx(inout uint idx)
{
    idx += _137.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

float evaluate_modifier_factor_for_edge(uint srf_face_idx, uint i0, uint i1)
{
    return 1.0;
}

uint64_t build_edge_key(uint a, uint b)
{
    if (a < b)
    {
        return (uint64_t(a) << 32) | uint64_t(b);
    }
    else
    {
        return (uint64_t(b) << 32) | uint64_t(a);
    }
}

uint64_t GPUHashMapHash64(inout uint64_t h)
{
    h ^= (h >> 33);
    h *= 18397679294719823053ul;
    h ^= (h >> 33);
    h *= 14181476777654086739ul;
    h ^= (h >> 33);
    return h;
}

GPUHashMapInsertResult edge_hashmap_insert(uint64_t key)
{
    GPUHashMapInsertResult res;
    res.slot = 4294967295u;
    res.duplicate = false;
    uint64_t param = key;
    uint64_t _74 = GPUHashMapHash64(param);
    uint64_t hash = _74;
    uint slot = uint(hash & uint64_t(edge_hashmap.header.capacity - 1u));
    for (;;)
    {
        if (true)
        {
            uint64_t _103 = atomicCompSwap(edge_hashmap.keys[slot], 18446744073709551615ul, key);
            uint64_t prev = _103;
            if ((prev == 18446744073709551615ul) || (prev == key))
            {
                res.slot = slot;
                res.duplicate = prev == key;
                return res;
            }
            slot = (slot + 1u) & (edge_hashmap.header.capacity - 1u);
            continue;
        }
        else
        {
            break;
        }
    }
    return res;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = _189.geometry_subdivide_params.surface_idx;
    uint src_faces_num = _137.input_geometry_information.faces_num_per_surface[surface_idx];
    GPUHashMapInsertResult ires0;
    GPUHashMapInsertResult ires1;
    GPUHashMapInsertResult ires2;
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _214 = get_idx(param);
            uint i0 = _214;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _220 = get_idx(param_1);
            uint i1 = _220;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _227 = get_idx(param_2);
            uint i2 = _227;
            uint param_3 = src_face_idx;
            uint param_4 = i0;
            uint param_5 = i1;
            bool se0 = evaluate_modifier_factor_for_edge(param_3, param_4, param_5) > 9.9999997473787516355514526367188e-05;
            uint param_6 = src_face_idx;
            uint param_7 = i1;
            uint param_8 = i2;
            bool se1 = evaluate_modifier_factor_for_edge(param_6, param_7, param_8) > 9.9999997473787516355514526367188e-05;
            uint param_9 = src_face_idx;
            uint param_10 = i2;
            uint param_11 = i0;
            bool se2 = evaluate_modifier_factor_for_edge(param_9, param_10, param_11) > 9.9999997473787516355514526367188e-05;
            if ((se0 || se1) || se2)
            {
                uint param_12 = i0;
                uint param_13 = i1;
                uint64_t edge0 = build_edge_key(param_12, param_13);
                uint param_14 = i1;
                uint param_15 = i2;
                uint64_t edge1 = build_edge_key(param_14, param_15);
                uint param_16 = i2;
                uint param_17 = i0;
                uint64_t edge2 = build_edge_key(param_16, param_17);
                ires0.duplicate = true;
                ires1.duplicate = true;
                ires2.duplicate = true;
                uint added_vertices = 0u;
                if (se0)
                {
                    uint64_t param_18 = edge0;
                    GPUHashMapInsertResult _293 = edge_hashmap_insert(param_18);
                    ires0 = _293;
                    if (ires0.duplicate == false)
                    {
                        added_vertices++;
                    }
                }
                if (se1)
                {
                    uint64_t param_19 = edge1;
                    GPUHashMapInsertResult _306 = edge_hashmap_insert(param_19);
                    ires1 = _306;
                    if (ires1.duplicate == false)
                    {
                        added_vertices++;
                    }
                }
                if (se2)
                {
                    uint64_t param_20 = edge2;
                    GPUHashMapInsertResult _319 = edge_hashmap_insert(param_20);
                    ires2 = _319;
                    if (ires2.duplicate == false)
                    {
                        added_vertices++;
                    }
                }
                if (added_vertices > 0u)
                {
                    uint _337 = atomicAdd(_334.output_geometry_information.vtx_num, added_vertices);
                    uint base_new_vtx = _337;
                    bool _344;
                    if (se0)
                    {
                        _344 = ires0.duplicate == false;
                    }
                    else
                    {
                        _344 = se0;
                    }
                    if (_344)
                    {
                        uint _353 = base_new_vtx;
                        base_new_vtx = _353 + uint(1);
                        edge_hashmap_values.values[ires0.slot] = _353;
                    }
                    bool _362;
                    if (se1)
                    {
                        _362 = ires1.duplicate == false;
                    }
                    else
                    {
                        _362 = se1;
                    }
                    if (_362)
                    {
                        uint _367 = base_new_vtx;
                        base_new_vtx = _367 + uint(1);
                        edge_hashmap_values.values[ires1.slot] = _367;
                    }
                    bool _376;
                    if (se2)
                    {
                        _376 = ires2.duplicate == false;
                    }
                    else
                    {
                        _376 = se2;
                    }
                    if (_376)
                    {
                        uint _381 = base_new_vtx;
                        base_new_vtx = _381 + uint(1);
                        edge_hashmap_values.values[ires2.slot] = _381;
                    }
                }
            }
            uint added_faces = 1u;
            added_faces += uint(int(se0));
            added_faces += uint(int(se1));
            added_faces += uint(int(se2));
            uint _403 = atomicAdd(_334.output_geometry_information.faces_num_per_surface[surface_idx], added_faces);
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
}

 