#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct PostDepthOfFieldParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float far_plane;
    float debug_blur_size;
    float focus_depth;
    float focus_range;
    float adaptation_speed;
    int auto_focus;
    float auto_focus_area;
    int auto_focus_points;
    float auto_focus_bias;
    float ts;
    int _pad1;
    int _pad2;
};

struct PostDepthOfFieldDynamicParams
{
    float focus_depth;
    float focus_range;
    int initialized;
    int _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 2, std140) uniform PostDepthOfFieldParamsBuffer
{
    PostDepthOfFieldParams dof_params;
} _19;

layout(set = 0, binding = 1, std430) buffer PostDepthOfFieldDynamicParamsBuffer
{
    PostDepthOfFieldDynamicParams dof_dynamic_params;
} _55;

layout(set = 0, binding = 3) uniform sampler2D sDepth;

float linearizeDepth(float d)
{
    return _19.dof_params.near_far_plane.z / ((_19.dof_params.near_far_plane.y + _19.dof_params.near_far_plane.x) - (d * _19.dof_params.near_far_plane.w));
}

void main()
{
    bool _48 = _19.dof_params.auto_focus == 0;
    bool _61;
    if (!_48)
    {
        _61 = _55.dof_dynamic_params.initialized == 0;
    }
    else
    {
        _61 = _48;
    }
    if (_61)
    {
        _55.dof_dynamic_params.initialized = 1;
        _55.dof_dynamic_params.focus_depth = _19.dof_params.focus_depth;
        _55.dof_dynamic_params.focus_range = _19.dof_params.focus_range;
        return;
    }
    vec2 sp_center = vec2(float(_19.dof_params.auto_focus_points)) * 0.5;
    float min_depth = 1.0;
    float max_depth = 0.0;
    int iy = 0;
    for (;;)
    {
        if (iy < _19.dof_params.auto_focus_points)
        {
            int ix = 0;
            for (;;)
            {
                if (ix < _19.dof_params.auto_focus_points)
                {
                    vec2 sp = vec2(0.5) + (((vec2(float(ix), float(iy)) - sp_center) / vec2(float(_19.dof_params.auto_focus_points), float(_19.dof_params.auto_focus_points))) * _19.dof_params.auto_focus_area);
                    float depth = texelFetch(sDepth, ivec2(_19.dof_params.resolution * sp), 0).x;
                    min_depth = min(min_depth, depth);
                    max_depth = max(max_depth, depth);
                    ix++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iy++;
            continue;
        }
        else
        {
            break;
        }
    }
    float focus_depth = mix(min_depth, max_depth, _19.dof_params.auto_focus_bias);
    float param = focus_depth;
    focus_depth = linearizeDepth(param);
    float adaptation = min(1.0, _19.dof_params.ts * _19.dof_params.adaptation_speed);
    _55.dof_dynamic_params.focus_depth = 1.0 / mix(1.0 / _55.dof_dynamic_params.focus_depth, 1.0 / focus_depth, adaptation);
    if (isnan(_55.dof_dynamic_params.focus_depth))
    {
        _55.dof_dynamic_params.focus_depth = 0.0;
    }
    _55.dof_dynamic_params.focus_range = _19.dof_params.focus_range;
}

 