#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _270;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 13, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _383;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 14, std140) uniform VM0
{
    ModifierFactorQuantizePosition_Params VM0_params;
} _1164;

layout(set = 0, binding = 15, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1179;

layout(set = 0, binding = 16, std140) uniform VM2
{
    ModifierFactorClamp_Params VM2_params;
} _1194;

layout(set = 0, binding = 17, std140) uniform VM3
{
    ModifierFactorCurveTransfer_Params VM3_params;
} _1207;

layout(set = 0, binding = 18, std140) uniform VM4
{
    VertexModifierDisplaceParams VM4_params;
} _1220;

layout(set = 0, binding = 19, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _1251;

layout(set = 0, binding = 12, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

layout(set = 0, binding = 20) uniform sampler2D s_Curves;

uint get_idx(inout uint idx)
{
    idx += _383.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _270.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _383.input_geometry_information.attributes[0].stride;
    idx += _383.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _383.input_geometry_information.attributes[1].stride;
    idx += _383.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _383.input_geometry_information.attributes[2].stride;
    idx += _383.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

uint get_custom0(inout uint idx)
{
    idx *= _383.input_geometry_information.attributes[6].stride;
    idx += _383.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _954 = vector_transform_by_mat43(param, param_1);
        coords = _954;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _961 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _961;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

VertexInput apply_vertex_modifier_for_vtx(uint i0, inout VertexInput vtx_input, out float factor)
{
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_383.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param = i0;
        uint _1136 = get_custom0(param);
        modifier_factor.custom0 = _1136;
    }
    if ((_383.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = i0;
        vec3 _1146 = get_albedo(param_1);
        modifier_factor.color.x = _1146.x;
        modifier_factor.color.y = _1146.y;
        modifier_factor.color.z = _1146.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorQuantizePosition_Params _1169;
    _1169.quantization_step = _1164.VM0_params.quantization_step;
    _1169._pad0 = _1164.VM0_params._pad0;
    _1169.offset = _1164.VM0_params.offset;
    _1169.quantize_x = _1164.VM0_params.quantize_x;
    _1169.quantize_y = _1164.VM0_params.quantize_y;
    _1169.quantize_z = _1164.VM0_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_2 = _1169;
    ModifierFactor param_3 = modifier_factor;
    CoordinateSystemTrasforms param_4 = cs_transforms;
    modifier_factor_quantize_position(param_2, param_3, param_4);
    modifier_factor = param_3;
    ModifierFactorNoise_Params _1184;
    _1184.transform_local_to_gizmo = _1179.VM1_params.transform_local_to_gizmo;
    _1184.noise_domain_scale = _1179.VM1_params.noise_domain_scale;
    _1184.modifier_function = _1179.VM1_params.modifier_function;
    _1184.noise_domain_offset = _1179.VM1_params.noise_domain_offset;
    _1184.noise_value_scale = _1179.VM1_params.noise_value_scale;
    _1184.noise_value_offset = _1179.VM1_params.noise_value_offset;
    _1184.influence_scope = _1179.VM1_params.influence_scope;
    _1184._pad0 = _1179.VM1_params._pad0;
    _1184._pad1 = _1179.VM1_params._pad1;
    ModifierFactorNoise_Params param_5 = _1184;
    ModifierFactor param_6 = modifier_factor;
    CoordinateSystemTrasforms param_7 = cs_transforms;
    modifier_factor_noise_default(param_5, param_6, param_7);
    modifier_factor = param_6;
    ModifierFactorClamp_Params _1199;
    _1199.clamp_min = _1194.VM2_params.clamp_min;
    _1199.clamp_max = _1194.VM2_params.clamp_max;
    _1199.clamp_min_enable = _1194.VM2_params.clamp_min_enable;
    _1199.clamp_max_enable = _1194.VM2_params.clamp_max_enable;
    ModifierFactorClamp_Params param_8 = _1199;
    ModifierFactor param_9 = modifier_factor;
    modifier_factor_clamp(param_8, param_9);
    modifier_factor = param_9;
    ModifierFactorCurveTransfer_Params _1212;
    _1212.curve_idx = _1207.VM3_params.curve_idx;
    _1212.input_range_min = _1207.VM3_params.input_range_min;
    _1212.input_range_max = _1207.VM3_params.input_range_max;
    _1212.amplitude = _1207.VM3_params.amplitude;
    _1212.base = _1207.VM3_params.base;
    ModifierFactorCurveTransfer_Params param_10 = _1212;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_curve_transfer(param_10, param_11);
    modifier_factor = param_11;
    VertexModifierDisplaceParams _1225;
    _1225.displace_normal = _1220.VM4_params.displace_normal;
    _1225.displace_normal_modifier_factor = _1220.VM4_params.displace_normal_modifier_factor;
    _1225.displace_base = _1220.VM4_params.displace_base;
    _1225.displace_base_modifier_factor = _1220.VM4_params.displace_base_modifier_factor;
    _1225.influence_scope = _1220.VM4_params.influence_scope;
    VertexModifierDisplaceParams param_12 = _1225;
    ModifierFactor param_13 = modifier_factor;
    VertexInput param_14 = vtx_input;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    vertex_modifier_displace_apply(param_12, param_13, param_14, param_15);
    modifier_factor = param_13;
    vtx_input = param_14;
    factor = modifier_factor.factor;
    return vtx_input;
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _270.output_geometry_information.attributes[0].stride;
    idx += _270.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _270.output_geometry_information.attributes[1].stride;
    idx += _270.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _270.output_geometry_information.attributes[2].stride;
    idx += _270.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _270.output_geometry_information.attributes[6].stride;
    idx += _270.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_1251.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _383.input_geometry_information.faces_num_per_surface[surface_idx];
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _1275 = get_idx(param);
            uint i0 = _1275;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _1281 = get_idx(param_1);
            uint i1 = _1281;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _1287 = get_idx(param_2);
            uint i2 = _1287;
            uint dst_face_idx = src_face_idx;
            uint param_3 = (dst_face_idx * 3u) + 0u;
            uint param_4 = i0;
            put_idx(param_3, param_4);
            uint param_5 = (dst_face_idx * 3u) + 1u;
            uint param_6 = i1;
            put_idx(param_5, param_6);
            uint param_7 = (dst_face_idx * 3u) + 2u;
            uint param_8 = i2;
            put_idx(param_7, param_8);
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    _270.output_geometry_information.faces_num_per_surface[surface_idx] = src_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num = _383.input_geometry_information.vtx_num;
        VertexInput vtx_input;
        float param_15;
        uint src_vtx_idx = thread_idx;
        for (;;)
        {
            if (src_vtx_idx < src_vtx_num)
            {
                uint i0_1 = src_vtx_idx;
                uint i0_remapped = vtx_copy_flag_data.data[i0_1];
                bool i0_copy = i0_remapped != 0u;
                i0_remapped--;
                if (i0_copy)
                {
                    uint param_9 = i0_1;
                    vec3 _1355 = get_coords(param_9);
                    vec3 v0_coords = _1355;
                    vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                    if ((_383.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_10 = i0_1;
                        vec3 _1366 = get_normal(param_10);
                        v0_normal = _1366;
                    }
                    vec3 v0_albedo = vec3(1.0);
                    if ((_383.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_11 = i0_1;
                        vec3 _1377 = get_albedo(param_11);
                        v0_albedo = _1377;
                    }
                    uint v0_custom0 = 0u;
                    if ((_383.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_12 = i0_1;
                        uint _1387 = get_custom0(param_12);
                        v0_custom0 = _1387;
                    }
                    vtx_input.pos = v0_coords;
                    vtx_input.norm = v0_normal;
                    vtx_input.color.x = v0_albedo.x;
                    vtx_input.color.y = v0_albedo.y;
                    vtx_input.color.z = v0_albedo.z;
                    uint param_13 = i0_1;
                    VertexInput param_14 = vtx_input;
                    VertexInput _1406 = apply_vertex_modifier_for_vtx(param_13, param_14, param_15);
                    float modifier_factor = param_15;
                    vtx_input = _1406;
                    if (_1251.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                    {
                        v0_custom0 = floatBitsToUint(modifier_factor);
                    }
                    uint param_16 = i0_remapped;
                    vec3 param_17 = vtx_input.pos;
                    put_coords(param_16, param_17);
                    if ((_270.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_18 = i0_remapped;
                        vec3 param_19 = vtx_input.norm;
                        put_normal(param_18, param_19);
                    }
                    if ((_270.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_20 = i0_remapped;
                        vec3 param_21 = v0_albedo;
                        put_albedo(param_20, param_21);
                    }
                    if ((_270.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_22 = i0_remapped;
                        uint param_23 = v0_custom0;
                        put_custom0(param_22, param_23);
                    }
                }
                src_vtx_idx += 131072u;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 