#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct Cone
{
    float cosa;
    float h;
    vec3 c;
    vec3 v;
};

struct Ray
{
    vec3 o;
    vec3 d;
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    vec2 frustum_shift;
    vec2 resolution;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float _pad0;
    float _pad1;
    float _pad2;
    vec2 taa_jitter;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _709;

layout(set = 1, binding = 2, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _1096;

layout(set = 1, binding = 3, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _2669;

layout(set = 1, binding = 4, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 5, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _3571;

layout(set = 1, binding = 7) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 8) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 24) uniform sampler2D s_LTC2;
layout(set = 1, binding = 25) uniform sampler2D sAlbedo;
layout(set = 1, binding = 26) uniform usampler2D sNormalMaterial;
layout(set = 1, binding = 27) uniform sampler2D sDepth;
layout(set = 1, binding = 28) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 29) uniform sampler2D sEmissive;
layout(set = 1, binding = 30) uniform sampler2D LightShadowmapSamplers[16];
layout(set = 1, binding = 46) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 62) uniform sampler2D s_LTC1;
layout(set = 1, binding = 63) uniform sampler2D sRaytrace;
layout(set = 1, binding = 64) uniform sampler2D sIBL;

layout(location = 0) out vec4 outColor;
layout(location = 1) in vec4 vFrustum;
layout(location = 0) in vec2 vTexcoord0;
bool twoSided;
bool clipless;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _324;
    if (nor.x > 0.0)
    {
        _324 = -t;
    }
    else
    {
        _324 = t;
    }
    nor.x += _324;
    float _339;
    if (nor.y > 0.0)
    {
        _339 = -t;
    }
    else
    {
        _339 = t;
    }
    nor.y += _339;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _1096.basic_params.camera_near_far_plane.z / ((_1096.basic_params.camera_near_far_plane.y + _1096.basic_params.camera_near_far_plane.x) - (d * _1096.basic_params.camera_near_far_plane.w));
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_2669.render_lights_params.frustum_shift * _2669.render_lights_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_1096.basic_params.camera_projection_params.z) + ((_1096.basic_params.camera_projection_params.x * vd_pos.x) / _2669.render_lights_params.resolution.x);
    view_direction.y = (-_1096.basic_params.camera_projection_params.w) + ((_1096.basic_params.camera_projection_params.y * vd_pos.y) / _2669.render_lights_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

bool inside_light_cone(vec3 p0, vec3 p, float angle, float height)
{
    float hsquared = height * height;
    float cosangle = angle;
    float cDistance = dot(p, p);
    bool _1335 = cDistance <= hsquared;
    bool _1346;
    if (_1335)
    {
        _1346 = dot(p0, p) >= (sqrt(cDistance) * cosangle);
    }
    else
    {
        _1346 = _1335;
    }
    return _1346;
}

bool intersect_cone(Cone s, Ray r, out float v)
{
    v = 0.0;
    vec3 param = s.v;
    vec3 param_1 = r.o - s.c;
    float param_2 = s.cosa;
    float param_3 = s.h;
    if (inside_light_cone(param, param_1, param_2, param_3))
    {
        return true;
    }
    vec3 co = r.o - s.c;
    float a = (dot(r.d, s.v) * dot(r.d, s.v)) - (s.cosa * s.cosa);
    float b = 2.0 * ((dot(r.d, s.v) * dot(co, s.v)) - ((dot(r.d, co) * s.cosa) * s.cosa));
    float c = (dot(co, s.v) * dot(co, s.v)) - ((dot(co, co) * s.cosa) * s.cosa);
    float det = (b * b) - ((4.0 * a) * c);
    if (det < 0.0)
    {
        return false;
    }
    det = sqrt(det);
    float t1 = ((-b) - det) / (2.0 * a);
    float t2 = ((-b) + det) / (2.0 * a);
    float t = t1;
    bool _1472 = t < 0.0;
    bool _1482;
    if (!_1472)
    {
        _1482 = (t2 > 0.0) && (t2 < t);
    }
    else
    {
        _1482 = _1472;
    }
    if (_1482)
    {
        t = t2;
    }
    if (t < 0.0)
    {
        return false;
    }
    vec3 cp = (r.o + (r.d * t)) - s.c;
    float h = dot(cp, s.v);
    if (h < 0.0)
    {
        cp = (r.o + (r.d * max(t1, t2))) - s.c;
        h = dot(cp, s.v);
        if (h < 0.0)
        {
            return false;
        }
    }
    if (h < s.h)
    {
        return true;
    }
    cp = (r.o + (r.d * max(t1, t2))) - s.c;
    h = dot(cp, s.v);
    bool _1556 = h > 0.0;
    bool _1563;
    if (_1556)
    {
        _1563 = h < s.h;
    }
    else
    {
        _1563 = _1556;
    }
    if (_1563)
    {
        return true;
    }
    return false;
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1042 = angularInfo.NdotL > 0.0;
    bool _1049;
    if (!_1042)
    {
        _1049 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1049 = _1042;
    }
    if (_1049)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _806 = falloff > cutoff;
    bool _813;
    if (_806)
    {
        _813 = light_distance < light.range;
    }
    else
    {
        _813 = _806;
    }
    if (_813)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

float light_calculate_point_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0;
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

float AvgBlockersDepthToPenumbra(float light_size, float z_shadowMapView, float avgBlockersDepth)
{
    float penumbra = (light_size * (z_shadowMapView - avgBlockersDepth)) / avgBlockersDepth;
    return penumbra;
}

float PenumbraFromOccluderSearch(sampler2D smpl, float light_size, vec2 hash, vec4 coords, float sampling_range, int samplesCount, float shadowmap_bias)
{
    float avgBlockersDepth = 0.0;
    float blockersCount = 0.0;
    float penumbraFilterMaxSize = sampling_range;
    bool _453 = coords.x < (-coords.w);
    bool _462;
    if (!_453)
    {
        _462 = coords.x > coords.w;
    }
    else
    {
        _462 = _453;
    }
    bool _472;
    if (!_462)
    {
        _472 = coords.y < (-coords.w);
    }
    else
    {
        _472 = _462;
    }
    bool _481;
    if (!_472)
    {
        _481 = coords.y > coords.w;
    }
    else
    {
        _481 = _472;
    }
    bool _488;
    if (!_481)
    {
        _488 = coords.z < 0.0;
    }
    else
    {
        _488 = _481;
    }
    if (_488)
    {
        return 0.0;
    }
    vec2 shadowMapUV = ((coords.xy / vec2(coords.w)) * 0.5) + vec2(0.5);
    shadowMapUV.y = 1.0 - shadowMapUV.y;
    float z_shadowMapView = coords.z / coords.w;
    int i = 0;
    SPIRV_CROSS_LOOP
    for (;;)
    {
        if (i < samplesCount)
        {
            vec2 sampleUV = fract(hash + vec2(float(i) * 1.61803400516510009765625)) - vec2(0.5);
            sampleUV = shadowMapUV + (sampleUV * penumbraFilterMaxSize);
            vec4 sampleDepth = textureGather(smpl, sampleUV);
            if (sampleDepth.x < z_shadowMapView)
            {
                avgBlockersDepth += sampleDepth.x;
                blockersCount += 1.0;
            }
            if (sampleDepth.y < z_shadowMapView)
            {
                avgBlockersDepth += sampleDepth.y;
                blockersCount += 1.0;
            }
            if (sampleDepth.z < z_shadowMapView)
            {
                avgBlockersDepth += sampleDepth.z;
                blockersCount += 1.0;
            }
            if (sampleDepth.w < z_shadowMapView)
            {
                avgBlockersDepth += sampleDepth.w;
                blockersCount += 1.0;
            }
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    if (blockersCount > 0.0)
    {
        avgBlockersDepth /= blockersCount;
        float param = light_size;
        float param_1 = z_shadowMapView;
        float param_2 = avgBlockersDepth;
        return AvgBlockersDepthToPenumbra(param, param_1, param_2);
    }
    else
    {
        return 0.0;
    }
}

float sampleShadowPCFNoiseOffset(sampler2DShadow smpl, inout vec4 coords, ivec2 noise_offset, out float in_frustum, int samples, float sampling_range, float shadowmap_bias)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _622 = coords.x < (-coords.w);
    bool _631;
    if (!_622)
    {
        _631 = coords.x > coords.w;
    }
    else
    {
        _631 = _622;
    }
    bool _641;
    if (!_631)
    {
        _641 = coords.y < (-coords.w);
    }
    else
    {
        _641 = _631;
    }
    bool _650;
    if (!_641)
    {
        _650 = coords.y > coords.w;
    }
    else
    {
        _650 = _641;
    }
    bool _657;
    if (!_650)
    {
        _657 = coords.z < 0.0;
    }
    else
    {
        _657 = _650;
    }
    if (_657)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _661 = coords;
    float _666 = coords.w;
    vec2 _668 = (_661.xy * vec2(0.5)) + (vec2(0.5) * _666);
    coords.x = _668.x;
    coords.y = _668.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    float bias = shadowmap_bias;
    float bias2 = 0.300000011920928955078125;
    int taken_samples = 0;
    int h_samples = samples;
    vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_offset & ivec2(127), _709.globals.monotonic & 15), 0).xyz;
    int n = 0;
    SPIRV_CROSS_LOOP
    for (;;)
    {
        if (n < h_samples)
        {
            vec2 xy = fract(hash.xy + vec2(float(n) * 1.61803400516510009765625)) - vec2(0.5);
            vec4 jittered_coords = coords + vec4((xy.x * sampling_range) * coords.w, (xy.y * sampling_range) * coords.w, bias, 0.0);
            vec4 _763 = jittered_coords;
            vec4 _766 = _763;
            _766.z = _763.w;
            float shadow = textureProjLod(smpl, vec4(_766.xy, _763.z, _766.z), 0.0);
            fact += shadow;
            taken_samples++;
            n++;
            continue;
        }
        else
        {
            break;
        }
    }
    return fact * (1.0 / float(h_samples));
}

vec4 sampleProjectorTexture(sampler2D smpl, inout vec4 coords)
{
    vec4 color = vec4(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _1204 = coords.x < (-coords.w);
    bool _1213;
    if (!_1204)
    {
        _1213 = coords.x > coords.w;
    }
    else
    {
        _1213 = _1204;
    }
    bool _1223;
    if (!_1213)
    {
        _1223 = coords.y < (-coords.w);
    }
    else
    {
        _1223 = _1213;
    }
    bool _1232;
    if (!_1223)
    {
        _1232 = coords.y > coords.w;
    }
    else
    {
        _1232 = _1223;
    }
    if (_1232)
    {
        return color;
    }
    vec4 _1237 = coords;
    float _1241 = coords.w;
    vec2 _1243 = (_1237.xy * vec2(0.5)) + (vec2(0.5) * _1241);
    coords.x = _1243.x;
    coords.y = _1243.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w));
    return color;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right;
    rect.diry = light.up;
    rect.center = light.position;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1811;
    if (x > 0.0)
    {
        _1811 = v;
    }
    else
    {
        _1811 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1811;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate(vec3 N, vec3 V, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = texture(s_LTC2, uv).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _2572;
        if (twoSided_1)
        {
            _2572 = abs(sum);
        }
        else
        {
            _2572 = max(0.0, sum);
        }
        sum = _2572;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

float vol_rand(vec2 n)
{
    return fract(sin(dot(n, vec2(12.98980045318603515625, 4.141399860382080078125))) * 43758.546875);
}

float vol_noise(vec2 n)
{
    vec2 b = floor(n);
    vec2 f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
    vec2 param = b;
    vec2 param_1 = b + vec2(1.0, 0.0);
    vec2 param_2 = b + vec2(0.0, 1.0);
    vec2 param_3 = b + vec2(1.0);
    return mix(mix(vol_rand(param), vol_rand(param_1), f.x), mix(vol_rand(param_2), vol_rand(param_3), f.x), f.y);
}

float sampleShadowDist(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, inout vec4 projector_color, inout float shadow_dist)
{
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 0.0;
    }
    bool _1130 = coords.x < (-coords.w);
    bool _1139;
    if (!_1130)
    {
        _1139 = coords.x > coords.w;
    }
    else
    {
        _1139 = _1130;
    }
    bool _1149;
    if (!_1139)
    {
        _1149 = coords.y < (-coords.w);
    }
    else
    {
        _1149 = _1139;
    }
    bool _1158;
    if (!_1149)
    {
        _1158 = coords.y > coords.w;
    }
    else
    {
        _1158 = _1149;
    }
    if (_1158)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _1162 = coords;
    float _1166 = coords.w;
    vec2 _1168 = (_1162.xy * vec2(0.5)) + (vec2(0.5) * _1166);
    coords.x = _1168.x;
    coords.y = _1168.y;
    vec3 samp = coords.xyz / vec3(coords.w);
    vec4 _1182 = coords;
    vec4 _1185 = _1182;
    _1185.z = _1182.w;
    float shadow = textureProj(smpl, vec4(_1185.xy, _1182.z, _1185.z));
    projector_color = vec4(0.0);
    shadow_dist = 0.0;
    return shadow;
}

float calculate_shadow_dist_for_position(LightProperties light, vec3 world, float depth, out vec4 cascadeColor, inout vec4 projector_color, out float shadow_dist)
{
    vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
    cascadeColor = vec4(1.0, 0.100000001490116119384765625, 0.100000001490116119384765625, 1.0);
    vec4 param = vShadowCoords;
    float param_1;
    vec4 param_2;
    float param_3;
    float _1310 = sampleShadowDist(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param, param_1, param_2, param_3);
    float in_frustum = param_1;
    projector_color = param_2;
    shadow_dist = param_3;
    float shadow = _1310;
    shadow *= in_frustum;
    projector_color *= in_frustum;
    return shadow;
}

float volumetric_sample_shadow_spot(LightProperties light, vec3 frustum, float max_depth, inout float attenuation, inout vec4 projector_color)
{
    float fact = 0.0;
    float depth_dir = 0.100000001490116119384765625;
    float depth_pos = 0.0;
    attenuation = 0.0;
    vec2 param = gl_FragCoord.xy + vec2(_709.globals.global_time);
    depth_pos += ((depth_dir * vol_noise(param)) * 2.5);
    int i = 0;
    vec4 param_6;
    vec4 param_7;
    float param_8;
    for (;;)
    {
        if (i < 256)
        {
            vec3 param_1 = frustum;
            float param_2 = depth_pos;
            vec3 ray_world = positionFromDepth(param_1, param_2);
            float lf = 0.0;
            float falloff = dot(light.direction, normalize(ray_world - light.position));
            if (falloff > light.cutoff)
            {
                float sample_attenuation = 1.0 - ((1.0 - falloff) / (1.0 - light.cutoff));
                sample_attenuation *= (1.0 - clamp(length(light.position - ray_world) / light.range, 0.0, 1.0));
                sample_attenuation = pow(sample_attenuation, 3.0);
                LightProperties param_3 = light;
                vec3 param_4 = ray_world;
                float param_5 = depth_pos;
                float _1704 = calculate_shadow_dist_for_position(param_3, param_4, param_5, param_6, param_7, param_8);
                vec4 cascade_color = param_6;
                vec4 projector = param_7;
                float shadow_dist = param_8;
                float shadow_value = _1704;
                lf = sample_attenuation * shadow_value;
                attenuation += sample_attenuation;
                vec4 _1721 = projector_color;
                vec3 _1723 = _1721.xyz + ((projector.xyz * (1.0 - shadow_value)) * sample_attenuation);
                projector_color.x = _1723.x;
                projector_color.y = _1723.y;
                projector_color.z = _1723.z;
            }
            fact += lf;
            depth_dir *= 1.0099999904632568359375;
            depth_pos += depth_dir;
            if (depth_pos > max_depth)
            {
                break;
            }
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec4 _1750 = projector_color;
    vec3 _1753 = _1750.xyz / vec3(float(i + 1));
    projector_color.x = _1753.x;
    projector_color.y = _1753.y;
    projector_color.z = _1753.z;
    return (attenuation - fact) / float(i + 1);
}

void main()
{
    twoSided = false;
    clipless = false;
    ivec2 screen_pos = ivec2(gl_FragCoord.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 _2738 = decode_normal(param);
    vec3 vNorm = _2738;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec2 param_3 = vec2(screen_pos);
    vec3 view_direction = get_view_direction(param_3);
    vec3 param_4 = view_direction;
    float param_5 = depth;
    vec3 world = (_1096.basic_params.mModel * vec4(positionFromDepth(param_4, param_5), 1.0)).xyz;
    outColor = vec4(0.0);
    uvec4 param_6 = texelFetch(sMetalnessRoughnessMaterialTags, screen_pos, 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        outColor = base_color;
        outColor.w = 0.0;
        return;
    }
    vec3 base_emissive = texelFetch(sEmissive, screen_pos, 0).xyz * materials.material_properties[material].emissive;
    bool is_background = (materialId & 1) == 1;
    bool is_raytraced = (material_flags & 1u) != 0u;
    bool is_particle = (material_flags & 8192u) != 0u;
    if (is_particle == false)
    {
    }
    else
    {
        outColor = base_color;
        outColor.w = 0.0;
        base_color.x = materials.material_properties[material].diffuse.x;
        base_color.y = materials.material_properties[material].diffuse.y;
        base_color.z = materials.material_properties[material].diffuse.z;
    }
    if (false)
    {
        if (is_raytraced)
        {
            float color_magnitude = length(base_color.xyz);
            if (color_magnitude > 1.0)
            {
                vec3 emissive_from_base_color = base_color.xyz - (base_color.xyz / vec3(color_magnitude));
                vec4 _2890 = base_color;
                vec3 _2892 = _2890.xyz - emissive_from_base_color;
                base_color.x = _2892.x;
                base_color.y = _2892.y;
                base_color.z = _2892.z;
                base_emissive += emissive_from_base_color;
            }
            vec3 param_7 = base_color.xyz;
            vec3 _2905 = saturate(param_7);
            base_color.x = _2905.x;
            base_color.y = _2905.y;
            base_color.z = _2905.z;
        }
    }
    vec3 f0 = vec3(0.039999999105930328369140625);
    vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
    float alphaRoughness = roughness * roughness;
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    vec3 view = normalize(_1096.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    if (is_particle == false)
    {
        float param_10;
        int _3199;
        float param_27;
        LTCRect param_33;
        vec3 param_35[4];
        float param_53;
        vec4 param_54;
        int light_idx = 0;
        for (;;)
        {
            if (light_idx < _2669.render_lights_params.lights_num)
            {
                LightProperties _2993;
                _2993.diffuse = lights.light_properties[light_idx].diffuse;
                _2993.direction = lights.light_properties[light_idx].direction;
                _2993.position = lights.light_properties[light_idx].position;
                _2993.up = lights.light_properties[light_idx].up;
                _2993.right = lights.light_properties[light_idx].right;
                _2993.dimensions = lights.light_properties[light_idx].dimensions;
                _2993.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
                _2993.intensity = lights.light_properties[light_idx].intensity;
                _2993.range = lights.light_properties[light_idx].range;
                _2993.cutoff = lights.light_properties[light_idx].cutoff;
                _2993.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
                _2993.is_area = lights.light_properties[light_idx].is_area;
                _2993.type = lights.light_properties[light_idx].type;
                _2993.projector_sampler = lights.light_properties[light_idx].projector_sampler;
                _2993.projector_intensity = lights.light_properties[light_idx].projector_intensity;
                _2993.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
                _2993.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
                _2993.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
                _2993.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
                _2993.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
                _2993.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
                _2993.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
                _2993.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
                _2993.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
                _2993.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
                _2993.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
                _2993.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
                _2993.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
                _2993.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
                _2993.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
                _2993.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
                _2993.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
                _2993.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
                LightProperties light = _2993;
                if ((light.lighting_exclusion_tags & metalness_roughness_material_tags.component_tags) != 0u)
                {
                    int _3500 = light_idx;
                    light_idx = _3500 + 1;
                    continue;
                }
                vec3 light_color = vec3(0.0);
                if ((light.type & 2) != 0)
                {
                    if ((light.type & 64) != 0)
                    {
                        Cone cone = Cone(light.cutoff * 1.0, light.range * 1.5, light.position, light.direction);
                        Ray ray = Ray(_1096.basic_params.camera_position, normalize(vFrustum.xyz));
                        float vv = 0.0;
                        Cone param_8 = cone;
                        Ray param_9 = ray;
                        bool _3044 = intersect_cone(param_8, param_9, param_10);
                        vv = param_10;
                        if (_3044 == false)
                        {
                            int _3500 = light_idx;
                            light_idx = _3500 + 1;
                            continue;
                        }
                    }
                }
                vec3 pointToLight = light.position - world;
                if ((light.type & 1) != 0)
                {
                    pointToLight = -light.direction;
                }
                pointToLight = normalize(pointToLight);
                float NdotL = dot(vNorm, pointToLight);
                if ((materialId & 1) == 1)
                {
                    NdotL = 1.0;
                }
                vec3 param_11 = pointToLight;
                MaterialInfo param_12 = materialInfo;
                vec3 param_13 = vNorm;
                vec3 param_14 = view;
                light_color = (getPointShade(param_11, param_12, param_13, param_14) * light.intensity) * light.diffuse.xyz;
                float shadow = 0.0;
                bool _3095 = (material_flags & 512u) != 0u;
                bool _3102;
                if (_3095)
                {
                    _3102 = (light.type & 8) != 0;
                }
                else
                {
                    _3102 = _3095;
                }
                bool calculate_shadows = _3102;
                if (is_background)
                {
                    shadow = 0.0;
                    light_color = vec3(0.0);
                    calculate_shadows = false;
                }
                float light_attenuation = 1.0;
                if ((light.type & 130) == 130)
                {
                    LightProperties param_15 = light;
                    vec3 param_16 = world;
                    light_attenuation = light_calculate_spot_attenuation(param_15, param_16);
                }
                else
                {
                    if ((light.type & 132) == 132)
                    {
                        LightProperties param_17 = light;
                        vec3 param_18 = world;
                        light_attenuation = light_calculate_point_attenuation(param_17, param_18);
                    }
                }
                if (((light.type & 3) != 0) && calculate_shadows)
                {
                    vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                    float in_frustum = 0.0;
                    vec2 penumbraHash = texelFetch(s_BlueNoise, ivec3(screen_pos & ivec2(127), (_709.globals.monotonic + light_idx) & 15), 0).xy;
                    float light_size = length(light.dimensions);
                    int penumbra_iterations = max(6, min(10, int(light_size * 0.0024999999441206455230712890625)));
                    float penumbra = light.roughness_modifier / 1024.0;
                    if ((light.type & 2) != 0)
                    {
                        if (true)
                        {
                            float search_radius = max(0.25, light_size * 0.20000000298023223876953125) / 1024.0;
                            if (true)
                            {
                                _3199 = light.downsampled_shadowmap_sampler;
                            }
                            else
                            {
                                _3199 = light.shadowmap_sampler0;
                            }
                            float param_19 = light_size;
                            vec2 param_20 = penumbraHash;
                            vec4 param_21 = vShadowCoords;
                            float param_22 = search_radius;
                            int param_23 = penumbra_iterations;
                            float param_24 = materials.material_properties[material].shadowmap_bias;
                            penumbra = PenumbraFromOccluderSearch(LightShadowmapSamplers[_3199], param_19, param_20, param_21, param_22, param_23, param_24);
                        }
                        else
                        {
                            penumbra = 0.0;
                        }
                    }
                    int light_iterations = max(4, min(12, int((penumbra * light.roughness_modifier) * 0.25)));
                    vec4 param_25 = vShadowCoords;
                    ivec2 param_26 = screen_pos;
                    int param_28 = light_iterations;
                    float param_29 = max(0.25, penumbra * light.roughness_modifier) / 1024.0;
                    float param_30 = materials.material_properties[material].shadowmap_bias;
                    float _3255 = sampleShadowPCFNoiseOffset(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_25, param_26, param_27, param_28, param_29, param_30);
                    in_frustum = param_27;
                    shadow = _3255;
                    if (NdotL <= 0.0)
                    {
                        shadow = max(shadow, smoothstep(0.0, -0.0500000007450580596923828125, NdotL));
                    }
                }
                light_color *= ((1.0 - shadow) * light_attenuation);
                if ((light.type & 16) != 0)
                {
                    vec4 vShadowCoords_1 = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                    vec4 param_31 = vShadowCoords_1;
                    vec4 _3294 = sampleProjectorTexture(LightProjectorSamplers[light.projector_sampler], param_31);
                    vec3 projector_color = _3294.xyz * light.projector_intensity;
                    light_color *= projector_color;
                }
                SPIRV_CROSS_BRANCH
                if (light.is_area != 0)
                {
                    if ((materialId & 1) == 1)
                    {
                    }
                    else
                    {
                        LightProperties param_32 = light;
                        InitRect(param_32, param_33);
                        LTCRect rect = param_33;
                        LTCRect param_34 = rect;
                        InitRectPoints(param_34, param_35);
                        vec3 points[4] = param_35;
                        float ltc_roughness = roughness;
                        float ltc_intensity = light.intensity;
                        vec3 dcol = light.diffuse.xyz;
                        vec3 scol = dcol;
                        vec3 col = vec3(0.0);
                        vec3 pos = world;
                        vec3 N = vNorm;
                        vec3 V = normalize(_1096.basic_params.camera_position - world);
                        float ndotv = clamp(dot(N, V), 0.0500000007450580596923828125, 1.0);
                        vec2 uv = vec2(ltc_roughness, sqrt(1.0 - ndotv));
                        uv = (uv * 0.984375) + vec2(0.0078125);
                        vec4 t1 = texture(s_LTC1, uv);
                        vec4 t2 = texture(s_LTC2, uv);
                        mat3 Minv = mat3(vec3(vec3(t1.x, 0.0, t1.y)), vec3(0.0, 1.0, 0.0), vec3(vec3(t1.z, 0.0, t1.w)));
                        vec3 param_36 = N;
                        vec3 param_37 = V;
                        vec3 param_38 = pos;
                        mat3 param_39 = Minv;
                        vec3 param_40[4] = points;
                        bool param_41 = twoSided;
                        vec3 _3410 = LTC_Evaluate(param_36, param_37, param_38, param_39, param_40, param_41);
                        vec3 spec = _3410;
                        spec *= ((scol * t2.x) + ((vec3(1.0) - scol) * t2.y));
                        vec3 param_42 = N;
                        vec3 param_43 = V;
                        vec3 param_44 = pos;
                        mat3 param_45 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
                        vec3 param_46[4] = points;
                        bool param_47 = twoSided;
                        vec3 _3439 = LTC_Evaluate(param_42, param_43, param_44, param_45, param_46, param_47);
                        vec3 diff = _3439;
                        col = ((spec * specularColor) + ((dcol * diff) * diffuseColor)) * ltc_intensity;
                        light_color = col;
                    }
                    if ((light.type & 128) == 128)
                    {
                        LightProperties param_48 = light;
                        vec3 param_49 = world;
                        float attenuation = light_calculate_area_attenuation(param_48, param_49);
                        light_color *= attenuation;
                    }
                }
                SPIRV_CROSS_BRANCH
                if ((light.type & 64) != 0)
                {
                    float attenuation_1 = 0.0;
                    vec4 projector_color_1 = vec4(0.0);
                    LightProperties param_50 = light;
                    vec3 param_51 = vFrustum.xyz;
                    float param_52 = depth;
                    float _3486 = volumetric_sample_shadow_spot(param_50, param_51, param_52, param_53, param_54);
                    attenuation_1 = param_53;
                    projector_color_1 = param_54;
                    float volume_attenuation = _3486;
                    outColor.w += (light.diffuse.w * volume_attenuation);
                }
                outLightColor += light_color;
                int _3500 = light_idx;
                light_idx = _3500 + 1;
                continue;
            }
            else
            {
                break;
            }
        }
        if (true)
        {
            if (is_raytraced)
            {
                vec2 p = vTexcoord0 * _2669.render_lights_params.raytrace_scaling_factor;
                vec4 raytraceColor = texture(sRaytrace, p);
                vec4 _3521 = raytraceColor;
                vec3 _3523 = _3521.xyz * _2669.render_lights_params.raytrace_strength;
                raytraceColor.x = _3523.x;
                raytraceColor.y = _3523.y;
                raytraceColor.z = _3523.z;
                outLightColor += ((specularColor * raytraceColor.xyz) * (1.0 - roughness));
                outLightColor = mix(outLightColor, raytraceColor.xyz, vec3(raytraceColor.w));
            }
        }
    }
    outLightColor += base_emissive;
    if (is_background == false)
    {
        vec4 ibl_occlusion = texelFetch(sIBL, screen_pos, 0);
        vec3 ibl = ibl_occlusion.xyz;
        float occlusion = ibl_occlusion.w;
        outLightColor = ibl;
        outLightColor *= vec3(1.0 - (pow(occlusion, 0.25) * _3571.composite_setup.occlusion_base_strength));
    }
    vec4 _3580 = outColor;
    vec3 _3582 = _3580.xyz + outLightColor;
    outColor.x = _3582.x;
    outColor.y = _3582.y;
    outColor.z = _3582.z;
    if (is_background == false)
    {
        vec4 _3605 = outColor;
        vec3 _3607 = _3605.xyz * (((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz) + vec3(1.0));
        outColor.x = _3607.x;
        outColor.y = _3607.y;
        outColor.z = _3607.z;
        vec4 _3624 = outColor;
        vec3 _3626 = _3624.xyz + ((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz);
        outColor.x = _3626.x;
        outColor.y = _3626.y;
        outColor.z = _3626.z;
    }
    vec3 noisyColor = outColor.xyz - outLightColor;
}

 