/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.DebuggerState;
import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.debugger.ui15.CPURegistersView;
import bk2010.gui.debugger.ui15.DebuggerControlsPanel;
import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.debugger.ui15.DisasmPanel;
import bk2010.gui.debugger.ui15.LabelsPanel;
import bk2010.gui.debugger.ui15.MemoryPanel;
import bk2010.gui.debugger.ui15.StackView;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.util.ResourceManager;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JFrame;

public class DebuggerFrame
extends JFrame
implements AddressCallback {
    private static final long serialVersionUID = 1L;
    transient K1801VM1 cpu;
    DebuggerControlsPanel controlsPanel;
    DisasmPanel disasmPanel;
    LabelsPanel labelsPanel;
    MemoryPanel memoryPanel;
    Box systemPanel;
    DebuggerState dbgState;

    public DebuggerFrame(K1801VM1 cpu, CPUTimer timer, DebuggerState dbgState) {
        super("Debugger");
        this.setIconImage(ResourceManager.getEmulatorIcon());
        this.cpu = cpu;
        this.setDefaultCloseOperation(1);
        this.dbgState = dbgState;
        this.labelsPanel = new LabelsPanel(this);
        this.labelsPanel.loadLabels("default.map");
        this.add((Component)this.labelsPanel, "West");
        this.disasmPanel = new DisasmPanel(new DisasmModel(cpu.machine), dbgState);
        this.disasmPanel.setTrapSource(cpu);
        this.add((Component)this.disasmPanel, "Center");
        this.memoryPanel = new MemoryPanel(cpu.machine);
        this.add((Component)this.memoryPanel, "South");
        this.systemPanel = Box.createVerticalBox();
        this.systemPanel.add(new CPURegistersView(cpu, timer));
        this.systemPanel.add(new StackView(cpu, cpu.machine));
        this.add((Component)this.systemPanel, "East");
        this.controlsPanel = new DebuggerControlsPanel(this.disasmPanel);
        this.add((Component)this.controlsPanel, "North");
        this.pack();
        this.setFocusable(true);
        this.setAutoRequestFocus(true);
    }

    @Override
    public void selectAddress(int address) {
        if (address >= 0 && address < 65536) {
            this.disasmPanel.ensureVisible(address);
        }
    }

    public void resync() {
        this.disasmPanel.purge();
        this.disasmPanel.setPC(this.cpu.regs[7]);
    }

    public boolean invokeDebugger() {
        this.resync();
        int state = this.dbgState.get();
        if (state == 3) {
            this.dbgState.set(1);
            return false;
        }
        this.dbgState.set(2);
        this.setVisible(true);
        this.repaint();
        while (this.dbgState.get() == 2) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.isVisible()) continue;
            this.dbgState.set(0);
        }
        state = this.dbgState.get();
        if (state == 0) {
            this.setVisible(false);
        }
        return this.dbgState.get() == 1;
    }
}

