/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.dialogs.ConfigurationDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddressDialog
extends ConfigurationDialog {
    private static final long serialVersionUID = 3916282794172218228L;
    AddressCallback callback;
    JTextField input;

    public AddressDialog(final AddressCallback callback) {
        super("Address");
        this.callback = callback;
        this.input = new JTextField(8);
        this.add(this.input);
        AbstractAction okAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = AddressDialog.this.input.getText().trim();
                try {
                    int addr = Integer.parseUnsignedInt(text, 8);
                    if (addr > 0 && addr < 65536) {
                        callback.selectAddress(addr);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                AddressDialog.this.setVisible(false);
            }
        };
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressDialog.this.setVisible(false);
            }
        };
        Box okCancelPanel = Box.createHorizontalBox();
        okCancelPanel.add(Box.createHorizontalGlue());
        JButton jbOk = new JButton("OK");
        jbOk.addActionListener(okAction);
        okCancelPanel.add(jbOk);
        JButton jbCancel = new JButton("Cancel");
        jbCancel.addActionListener(cancelAction);
        okCancelPanel.add(jbCancel);
        okCancelPanel.add(Box.createHorizontalGlue());
        InputMap imap = okCancelPanel.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "OK");
        imap.put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        ActionMap amap = okCancelPanel.getActionMap();
        amap.put("OK", okAction);
        amap.put("Cancel", cancelAction);
        this.add((Component)okCancelPanel, "South");
        this.pack();
        this.center();
        this.input.requestFocusInWindow();
    }

    public void clearInput() {
        this.input.setText("");
    }
}

